/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.sse.autenvironment;

import com.microfocus.application.automation.tools.common.SSEException;
import com.microfocus.application.automation.tools.model.AutEnvironmentParameterModel;
import com.microfocus.application.automation.tools.sse.autenvironment.AUTEnvironmentFolder;
import com.microfocus.application.automation.tools.sse.autenvironment.AUTEnvironmnentParameter;
import com.microfocus.application.automation.tools.sse.autenvironment.request.get.GetAutEnvFoldersByIdRequest;
import com.microfocus.application.automation.tools.sse.autenvironment.request.get.GetParametersByAutEnvConfIdRequest;
import com.microfocus.application.automation.tools.sse.autenvironment.request.put.PutAutEnvironmentParametersBulkRequest;
import com.microfocus.application.automation.tools.sse.common.JsonHandler;
import com.microfocus.application.automation.tools.sse.common.StringUtils;
import com.microfocus.application.automation.tools.sse.common.XPathUtils;
import com.microfocus.application.automation.tools.sse.sdk.Client;
import com.microfocus.application.automation.tools.sse.sdk.Logger;
import com.microfocus.application.automation.tools.sse.sdk.Response;
import hudson.util.VariableResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AUTEnvironmentParametersManager {
    public static final String PARAMETER_PATH_DELIMITER = "/";
    private Logger logger;
    private Client client;
    private List<AutEnvironmentParameterModel> parametersToAssign;
    private String parametersRootFolderId;
    private String autEnvironmentConfigurationId;
    private Map<String, AUTEnvironmnentParameter> parameters;
    private VariableResolver<String> buildVariableResolver;
    private String pathToJsonFile;
    private String selectedNode;

    public AUTEnvironmentParametersManager(Client client, List<AutEnvironmentParameterModel> parametersToAssign, String parametersRootFolderId, String autEnvironmentConfigurationId, VariableResolver<String> buildVariableResolver, String pathToJsonFile, Logger logger, String selectedNode) {
        this.logger = logger;
        this.client = client;
        this.parametersToAssign = parametersToAssign;
        this.parametersRootFolderId = parametersRootFolderId;
        this.autEnvironmentConfigurationId = autEnvironmentConfigurationId;
        this.buildVariableResolver = buildVariableResolver;
        this.pathToJsonFile = pathToJsonFile;
        this.selectedNode = selectedNode;
    }

    public Collection<AUTEnvironmnentParameter> getParametersToUpdate() {
        this.parameters = this.getAllParametersByAutEnvConfId();
        Map<String, AUTEnvironmentFolder> parametersFolders = this.getAllRelevantParametersFolders();
        for (AUTEnvironmnentParameter parameter : this.parameters.values()) {
            parameter.setFullPath(parametersFolders.get(parameter.getParentId()).getPath() + PARAMETER_PATH_DELIMITER + parameter.getName());
        }
        this.resolveValuesOfParameters();
        return this.getResolvedParametersWithAssignedValues();
    }

    public void updateParametersValues(Collection<AUTEnvironmnentParameter> parametersToUpdate) {
        Response response = new PutAutEnvironmentParametersBulkRequest(this.client, parametersToUpdate).execute();
        if (!response.isOk()) {
            throw new SSEException(String.format("Failed to update the parameters of AUT Environment Configuration with ID: [%s]", this.autEnvironmentConfigurationId), response.getFailure());
        }
        this.logger.log("Submitted all parameters to ALM");
    }

    private Map<String, AUTEnvironmnentParameter> getAllParametersByAutEnvConfId() {
        HashMap<String, AUTEnvironmnentParameter> parametersMap = new HashMap<String, AUTEnvironmnentParameter>();
        Response response = new GetParametersByAutEnvConfIdRequest(this.client, this.autEnvironmentConfigurationId).execute();
        if (!response.isOk()) {
            throw new SSEException(String.format("Failed to retrieve the parameters of AUT Environment Configuration with ID: [%s]", this.autEnvironmentConfigurationId), response.getFailure());
        }
        List<Map<String, String>> parameters = XPathUtils.toEntities(response.toString());
        for (Map<String, String> parameter : parameters) {
            String id = parameter.get("id");
            AUTEnvironmnentParameter param = new AUTEnvironmnentParameter(id, parameter.get("parent-id"), parameter.get("name"));
            parametersMap.put(id, param);
        }
        return parametersMap;
    }

    private Map<String, AUTEnvironmentFolder> getAllRelevantParametersFolders() {
        HashMap<String, AUTEnvironmentFolder> parametersFolders = new HashMap<String, AUTEnvironmentFolder>();
        StringBuilder foldersToGet = new StringBuilder(this.parametersRootFolderId);
        for (AUTEnvironmnentParameter parameter : this.parameters.values()) {
            foldersToGet.append("%20OR%20" + parameter.getParentId());
        }
        Response response = new GetAutEnvFoldersByIdRequest(this.client, foldersToGet.toString()).execute();
        if (!response.isOk()) {
            throw new SSEException(String.format("Failed to retrieve parameters folders of AUT Environment Configuration with ID: [%s]", this.autEnvironmentConfigurationId), response.getFailure());
        }
        List<Map<String, String>> folders = XPathUtils.toEntities(response.toString());
        for (Map<String, String> folder : folders) {
            String folderId = folder.get("id");
            if (parametersFolders.containsKey(folderId)) continue;
            AUTEnvironmentFolder autEnvironmentFolder = new AUTEnvironmentFolder(folderId, (String)folder.get("parent-id"), (String)folder.get("name"));
            parametersFolders.put(folderId, autEnvironmentFolder);
        }
        for (Map<String, String> folder : parametersFolders.values()) {
            this.calculatePaths((AUTEnvironmentFolder)((Object)folder), parametersFolders);
        }
        return parametersFolders;
    }

    private String calculatePaths(AUTEnvironmentFolder folder, Map<String, AUTEnvironmentFolder> parametersFolders) {
        Object calculatedPath = folder.getId().equals(this.parametersRootFolderId) ? folder.getName() : (StringUtils.isNullOrEmpty(folder.getPath()) ? this.calculatePaths(parametersFolders.get(folder.getParentId()), parametersFolders) + PARAMETER_PATH_DELIMITER + folder.getName() : folder.getPath());
        folder.setPath((String)calculatedPath);
        return calculatedPath;
    }

    private void resolveValuesOfParameters() {
        boolean shouldLoadJsonObject = true;
        Object jsonObject = null;
        JsonHandler jsonHandler = new JsonHandler(this.logger);
        for (AutEnvironmentParameterModel parameter : this.parametersToAssign) {
            String resolvedValue = "";
            switch (AutEnvironmentParameterModel.AutEnvironmentParameterType.get(parameter.getParamType())) {
                case ENVIRONMENT: {
                    resolvedValue = (String)this.buildVariableResolver.resolve(parameter.getValue());
                    break;
                }
                case EXTERNAL: {
                    if (shouldLoadJsonObject) {
                        jsonObject = jsonHandler.load(this.selectedNode, this.pathToJsonFile);
                        shouldLoadJsonObject = false;
                    }
                    resolvedValue = jsonHandler.getValueFromJsonAsString(jsonObject, parameter.getValue(), parameter.isShouldGetOnlyFirstValueFromJson());
                    break;
                }
                case USER_DEFINED: {
                    resolvedValue = parameter.getValue();
                    break;
                }
                case UNDEFINED: {
                    resolvedValue = "";
                }
            }
            parameter.setResolvedValue(resolvedValue);
        }
    }

    private Collection<AUTEnvironmnentParameter> getResolvedParametersWithAssignedValues() {
        ArrayList<AUTEnvironmnentParameter> valuesToReturn = new ArrayList<AUTEnvironmnentParameter>();
        block0: for (AutEnvironmentParameterModel parameterByModel : this.parametersToAssign) {
            String parameterPathByModel = parameterByModel.getName();
            for (AUTEnvironmnentParameter parameter : this.parameters.values()) {
                if (!parameterPathByModel.equalsIgnoreCase(parameter.getFullPath())) continue;
                String resolvedValue = parameterByModel.getResolvedValue();
                parameter.setValue(resolvedValue);
                this.logger.log(String.format("Parameter: [%s] of type: [%s] will get the value: [%s] ", parameter.getFullPath(), parameterByModel.getParamType(), resolvedValue));
                valuesToReturn.add(parameter);
                continue block0;
            }
        }
        this.logger.log(this.parametersToAssign.size() > 0 ? "Finished assignment of values for all parameters" : "There was no parameters to assign");
        return valuesToReturn;
    }
}

