/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.run;

import com.microfocus.application.automation.tools.mc.JobConfigurationProxy;
import com.microfocus.application.automation.tools.model.AuthModel;
import com.microfocus.application.automation.tools.model.MCServerSettingsModel;
import com.microfocus.application.automation.tools.model.ProxySettings;
import com.microfocus.application.automation.tools.model.UploadAppModel;
import com.microfocus.application.automation.tools.model.UploadAppPathModel;
import com.microfocus.application.automation.tools.settings.MCServerSettingsGlobalConfiguration;
import com.microfocus.application.automation.tools.sse.common.StringUtils;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.apache.commons.io.FilenameUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class UploadAppBuilder
extends Builder {
    private final UploadAppModel uploadAppModel;

    @DataBoundConstructor
    public UploadAppBuilder(String mcServerName, AuthModel authModel, ProxySettings proxySettings, List<UploadAppPathModel> applicationPaths) {
        this.uploadAppModel = new UploadAppModel(mcServerName, authModel, proxySettings, applicationPaths);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        MCServerSettingsModel mcServerSettingsModel = this.getMCServerSettingsModel();
        JobConfigurationProxy job = JobConfigurationProxy.getInstance();
        JSONObject app = null;
        String mcServerUrl = "";
        PrintStream out = listener.getLogger();
        List<UploadAppPathModel> paths = null;
        if (this.uploadAppModel != null) {
            paths = this.uploadAppModel.getApplicationPaths();
        }
        boolean allSuccess = true;
        if (mcServerSettingsModel == null) {
            out.println("Failed to upload app to Functional Testing Lab server. Cause: Functional Testing Lab URL was not configured.");
            return false;
        }
        mcServerUrl = mcServerSettingsModel.getProperties().getProperty("MobileHostAddress");
        Map<String, String> headers = job.login(mcServerUrl, this.uploadAppModel.getAuthModel(), this.uploadAppModel.getProxySettings());
        if (headers == null || headers.size() == 0) {
            if (this.uploadAppModel.isUseProxy()) {
                out.println(String.format("Failed to upload app, Cause Functional Testing Lab connection info is incorrect. url:%s, Proxy url:%s", mcServerUrl, this.uploadAppModel.getProxySettings().getFsProxyAddress()));
            } else if (this.uploadAppModel.isUseAuthentication()) {
                out.println(String.format("Failed to upload app, Cause Functional Testing Lab connection info is incorrect. url:%s, Proxy url:%s, proxy userName:%s", mcServerUrl, this.uploadAppModel.getProxySettings().getFsProxyAddress(), this.uploadAppModel.getProxySettings().getFsProxyUserName()));
            } else {
                out.println(String.format("Failed to upload app, Cause Functional Testing Lab connection info is incorrect. url:%s", mcServerUrl));
            }
            build.setResult(Result.FAILURE);
            return false;
        }
        if (paths == null || paths.size() == 0) {
            return true;
        }
        out.println(String.format("There are %d apps to be uploaded.", paths.size()));
        String workspace = build.getWorkspace() == null ? "" : build.getWorkspace().toURI().getPath();
        for (int i = 1; i <= paths.size(); ++i) {
            String path;
            String appUploadWorkspace = paths.get(i - 1).getMcAppWorkspace();
            String originPath = path = paths.get(i - 1).getMcAppPath();
            if (StringUtils.isNullOrEmpty(path)) {
                out.println(String.format("ignore the empty app %d upload", i));
                continue;
            }
            if (path.toUpperCase(Locale.ENGLISH).startsWith("${WORKSPACE}") && !FilenameUtils.normalize((String)(path = path.replaceAll("(?i)" + Pattern.quote("${WORKSPACE}"), Matcher.quoteReplacement(workspace)))).startsWith(FilenameUtils.normalize((String)workspace))) {
                out.println(String.format("Failed to upload app, Cause invalid application file: %s", path));
                build.setResult(Result.FAILURE);
                allSuccess = false;
                continue;
            }
            FilePath filePath = new FilePath(build.getWorkspace().getChannel(), path);
            File tempFile = null;
            if (filePath.isRemote()) {
                tempFile = File.createTempFile("uftm", "." + FilenameUtils.getExtension((String)path));
                try (FileOutputStream outputStream = new FileOutputStream(tempFile);){
                    filePath.copyTo((OutputStream)outputStream);
                    path = tempFile.getCanonicalPath();
                }
                catch (NoSuchFileException noSuchFileException) {
                    out.println(String.format("Failed to upload app, Cause cannot find application file: %s", path));
                    build.setResult(Result.FAILURE);
                    allSuccess = false;
                    continue;
                }
                catch (Exception e) {
                    out.println(String.format("Failed to upload app, Cause failed to copy application file: %s", path));
                    build.setResult(Result.FAILURE);
                    allSuccess = false;
                    continue;
                }
            }
            String appUploadWorkspaceName = "";
            if (!StringUtils.isNullOrEmpty(appUploadWorkspace)) {
                JSONObject result = job.isWorkspaceExist(headers, mcServerUrl, this.uploadAppModel.getProxySettings(), appUploadWorkspace);
                if (result == null || result != null && (!result.containsKey((Object)"uuid") || !result.getAsString("uuid").equals(appUploadWorkspace))) {
                    out.println(String.format("Failed to upload app %d %s, Cause cannot find target workspace id: %s", i, originPath, appUploadWorkspace));
                    build.setResult(Result.FAILURE);
                    allSuccess = false;
                    continue;
                }
                appUploadWorkspaceName = result.getAsString("name");
            } else {
                appUploadWorkspaceName = "Shared assets";
            }
            try {
                out.println(String.format("starting to upload app %d %s to workspace %s", i, originPath, appUploadWorkspaceName));
                app = job.upload(headers, mcServerUrl, this.uploadAppModel.getProxySettings(), path, appUploadWorkspace);
                if (app == null) {
                    out.println("Failed to upload app.");
                    build.setResult(Result.FAILURE);
                    boolean result = false;
                    return result;
                }
                if (((Boolean)app.get((Object)"error")).booleanValue()) {
                    out.println("Job failed because got error message during the application uploading. " + app.toJSONString());
                    allSuccess = false;
                    build.setResult(Result.FAILURE);
                }
                out.println("uploaded app info: " + app.toJSONString());
                continue;
            }
            catch (FileNotFoundException fnf) {
                out.println(String.format("Failed to upload app to Functional Testing Lab server. Cause: File: %s is not found.", path));
                build.setResult(Result.FAILURE);
                allSuccess = false;
                continue;
            }
            catch (IOException ioe) {
                Util.displayIOException((IOException)ioe, (TaskListener)listener);
                build.setResult(Result.FAILURE);
                allSuccess = false;
                continue;
            }
            catch (Exception e) {
                out.println("Failed to upload app.");
                build.setResult(Result.FAILURE);
                boolean bl = false;
                return bl;
            }
            finally {
                if (tempFile != null) {
                    Files.delete(tempFile.toPath());
                }
            }
        }
        return allSuccess;
    }

    public MCServerSettingsModel getMCServerSettingsModel() {
        for (MCServerSettingsModel mcServer : this.getDescriptor().getMcServers()) {
            if (this.uploadAppModel == null || !this.uploadAppModel.getMcServerName().equals(mcServer.getMcServerName())) continue;
            return mcServer;
        }
        return null;
    }

    public UploadAppModel getUploadAppModel() {
        return this.uploadAppModel;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Upload app to Functional Testing Lab (Digital Lab) Server";
        }

        public boolean hasMCServers() {
            return MCServerSettingsGlobalConfiguration.getInstance().hasMCServers();
        }

        public MCServerSettingsModel[] getMcServers() {
            return MCServerSettingsGlobalConfiguration.getInstance().getInstallations();
        }

        @JavaScriptMethod
        public JSONArray getValidWorkspaces(String mcUrl, String authType, String mcUserName, String mcPassword, String mcExecToken, boolean useProxy, String proxyAddress, boolean useAuthentication, String proxyUserName, String proxyPassword) {
            JSONArray workspaces = null;
            for (MCServerSettingsModel mcServer : this.getMcServers()) {
                if (StringUtils.isNullOrEmpty(mcUrl) || !mcUrl.equals(mcServer.getMcServerName())) continue;
                mcUrl = mcServer.getMcServerUrl();
            }
            AuthModel authModel = new AuthModel(mcUserName, mcPassword, mcExecToken, authType);
            ProxySettings proxySettings = new ProxySettings(useAuthentication, proxyAddress, proxyUserName, proxyPassword);
            try {
                JobConfigurationProxy job = JobConfigurationProxy.getInstance();
                workspaces = job.getAllValidWorkspaces(mcUrl, authModel, proxySettings);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return this.changeResult(workspaces);
        }

        private JSONArray changeResult(JSONArray workspaces) {
            JSONArray result = new JSONArray();
            if (workspaces != null) {
                JSONObject workspace;
                int i;
                for (i = 0; i < workspaces.size(); ++i) {
                    workspace = (JSONObject)workspaces.get(i);
                    if (!workspace.getAsString("name").equals("Shared assets")) continue;
                    result.add((Object)workspace);
                }
                for (i = 0; i < workspaces.size(); ++i) {
                    workspace = (JSONObject)workspaces.get(i);
                    if (workspace.getAsString("name").equals("Shared assets")) continue;
                    result.add((Object)workspace);
                }
            }
            return result;
        }
    }
}

