/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.run;

import com.microfocus.application.automation.tools.model.SvExportModel;
import com.microfocus.application.automation.tools.model.SvServerSettingsModel;
import com.microfocus.application.automation.tools.model.SvServiceSelectionModel;
import com.microfocus.application.automation.tools.sv.runner.AbstractSvRemoteRunner;
import com.microfocus.application.automation.tools.sv.runner.AbstractSvRunBuilder;
import com.microfocus.application.automation.tools.sv.runner.AbstractSvRunDescriptor;
import com.microfocus.application.automation.tools.sv.runner.ServiceInfo;
import com.microfocus.sv.svconfigurator.build.ProjectBuilder;
import com.microfocus.sv.svconfigurator.core.IProject;
import com.microfocus.sv.svconfigurator.core.IService;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommandExecutorException;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommunicatorException;
import com.microfocus.sv.svconfigurator.core.impl.exception.SVCParseException;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.ServiceRuntimeConfiguration;
import com.microfocus.sv.svconfigurator.processor.ChmodeProcessor;
import com.microfocus.sv.svconfigurator.processor.ChmodeProcessorInput;
import com.microfocus.sv.svconfigurator.processor.ExportProcessor;
import com.microfocus.sv.svconfigurator.processor.IChmodeProcessor;
import com.microfocus.sv.svconfigurator.serverclient.ICommandExecutor;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class SvExportBuilder
extends AbstractSvRunBuilder<SvExportModel> {
    @DataBoundConstructor
    public SvExportBuilder(String serverName, boolean force, String targetDirectory, boolean cleanTargetDirectory, SvServiceSelectionModel serviceSelection, boolean switchToStandByFirst, boolean archive) {
        super(new SvExportModel(serverName, force, targetDirectory, cleanTargetDirectory, serviceSelection, switchToStandByFirst, archive));
    }

    @Override
    protected void logConfig(PrintStream logger, String prefix) {
        logger.println(prefix + "Target Directory: " + ((SvExportModel)this.model).getTargetDirectory());
        logger.println(prefix + "Switch to Stand-By: " + ((SvExportModel)this.model).isSwitchToStandByFirst());
        super.logConfig(logger, prefix);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    protected RemoteRunner getRemoteRunner(@Nonnull FilePath workspace, TaskListener listener, SvServerSettingsModel server) {
        return new RemoteRunner((SvExportModel)this.model, workspace, listener, server);
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractSvRunDescriptor {
        public DescriptorImpl() {
            super("SV: Export Virtual Service");
        }

        public FormValidation doCheckTargetDirectory(@QueryParameter String targetDirectory) {
            if (StringUtils.isBlank((String)targetDirectory)) {
                return FormValidation.error((String)"Target directory cannot be empty");
            }
            return FormValidation.ok();
        }
    }

    private static class RemoteRunner
    extends AbstractSvRemoteRunner<SvExportModel> {
        private RemoteRunner(SvExportModel model, FilePath workspace, TaskListener listener, SvServerSettingsModel server) {
            super(listener, model, workspace, server);
        }

        public String call() throws Exception {
            PrintStream logger = this.listener.getLogger();
            SvExportBuilder.verifyNotNull(((SvExportModel)this.model).getTargetDirectory(), "Target directory must be set");
            ExportProcessor exportProcessor = new ExportProcessor(null);
            ChmodeProcessor chmodeProcessor = new ChmodeProcessor(null);
            IProject project = null;
            String targetDirectory = this.workspace.child(((SvExportModel)this.model).getTargetDirectory()).getRemote();
            ICommandExecutor exec = this.createCommandExecutor();
            if (((SvExportModel)this.model).isCleanTargetDirectory()) {
                this.cleanTargetDirectory(logger, new FilePath(new File(targetDirectory)));
            }
            if (((SvExportModel)this.model).getServiceSelection().getSelectionType().equals((Object)SvServiceSelectionModel.SelectionType.PROJECT)) {
                project = new ProjectBuilder().buildProject(new File(((SvExportModel)this.model).getServiceSelection().getProjectPath()), ((SvExportModel)this.model).getServiceSelection().getProjectPassword());
            }
            for (ServiceInfo serviceInfo : this.getServiceList(false, logger, this.workspace)) {
                if (((SvExportModel)this.model).isSwitchToStandByFirst()) {
                    this.switchToStandBy(serviceInfo, (IChmodeProcessor)chmodeProcessor, exec, logger);
                }
                logger.printf("  Exporting service '%s' [%s] to %s %n", serviceInfo.getName(), serviceInfo.getId(), targetDirectory);
                this.verifyNotLearningBeforeExport(logger, exec, serviceInfo);
                if (((SvExportModel)this.model).getServiceSelection().getSelectionType().equals((Object)SvServiceSelectionModel.SelectionType.PROJECT)) continue;
                exportProcessor.process(exec, targetDirectory, serviceInfo.getId(), project, false, ((SvExportModel)this.model).isArchive(), false);
            }
            if (((SvExportModel)this.model).getServiceSelection().getSelectionType().equals((Object)SvServiceSelectionModel.SelectionType.PROJECT)) {
                exportProcessor.process(exec, targetDirectory, null, project, false, ((SvExportModel)this.model).isArchive(), false);
            }
            return null;
        }

        private void switchToStandBy(ServiceInfo service, IChmodeProcessor chmodeProcessor, ICommandExecutor exec, PrintStream logger) throws CommandExecutorException, SVCParseException, CommunicatorException {
            logger.printf("  Switching service '%s' [%s] to Stand-By mode before export%n", service.getName(), service.getId());
            ChmodeProcessorInput chmodeInput = new ChmodeProcessorInput(((SvExportModel)this.model).isForce(), null, service.getId(), null, null, ServiceRuntimeConfiguration.RuntimeMode.STAND_BY, false, false);
            chmodeProcessor.process(chmodeInput, exec);
        }

        private void cleanTargetDirectory(PrintStream logger, FilePath targetDirectory) throws IOException, InterruptedException {
            if (targetDirectory.exists()) {
                List subfolders = targetDirectory.listDirectories();
                List files = targetDirectory.list((FileFilter)new SuffixFileFilter(".vproj"));
                if (subfolders.size() > 0 || files.size() > 0) {
                    logger.println("  Cleaning target directory...");
                }
                for (FilePath file : files) {
                    file.delete();
                }
                for (FilePath subfolder : subfolders) {
                    if (subfolder.list((FileFilter)new SuffixFileFilter(".vproj")).size() > 0) {
                        logger.println("    Deleting subfolder of target directory: " + String.valueOf(subfolder.absolutize()));
                        subfolder.deleteRecursive();
                        continue;
                    }
                    logger.println("    Skipping delete of directory '" + String.valueOf(subfolder.absolutize()) + "' because it does not contain any *.vproj file.");
                }
            }
        }

        private void verifyNotLearningBeforeExport(PrintStream logger, ICommandExecutor exec, ServiceInfo serviceInfo) throws CommunicatorException, CommandExecutorException {
            IService service = exec.findService(serviceInfo.getId(), null);
            ServiceRuntimeConfiguration info = exec.getServiceRuntimeInfo(service);
            if (info.getRuntimeMode() == ServiceRuntimeConfiguration.RuntimeMode.LEARNING) {
                logger.printf("    WARNING: Service '%s' [%s] is in Learning mode. Exported model need not be complete!", serviceInfo.getName(), serviceInfo.getId());
            }
        }
    }
}

