/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.run;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.cloudbees.plugins.credentials.matchers.IdMatcher;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcException;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcRunEventLog;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcRunEventLogRecord;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcRunResponse;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PostRunAction;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.RunState;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.TimeslotDuration;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.TrendReportTypes;
import com.microfocus.application.automation.tools.pc.PcClient;
import com.microfocus.application.automation.tools.pc.PcModel;
import com.microfocus.application.automation.tools.pc.helper.DateFormatter;
import com.microfocus.application.automation.tools.run.AdditionalParametersAction;
import com.microfocus.application.automation.tools.run.Messages;
import com.microfocus.application.automation.tools.sse.result.model.junit.Error;
import com.microfocus.application.automation.tools.sse.result.model.junit.Failure;
import com.microfocus.application.automation.tools.sse.result.model.junit.Testcase;
import com.microfocus.application.automation.tools.sse.result.model.junit.Testsuite;
import com.microfocus.application.automation.tools.sse.result.model.junit.Testsuites;
import com.thoughtworks.xstream.XStream;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Plugin;
import hudson.PluginWrapper;
import hudson.Util;
import hudson.console.HyperlinkNote;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.LogTaskListener;
import java.beans.IntrospectionException;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.ClientProtocolException;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class PcBuilder
extends Builder
implements SimpleBuildStep {
    public static final String artifactsResourceName = "artifact";
    public static final String runReportStructure = "%s/%s/performanceTestsReports/pcRun";
    public static final String trendReportStructure = "%s/%s/performanceTestsReports/TrendReports";
    public static final String pcReportArchiveName = "Reports.zip";
    public static final String pcReportFileName = "Report.html";
    public static final String TRENDED = "Trended";
    public static final String PENDING = "Pending";
    public static final String PUBLISHING = "Publishing";
    public static final String ERROR = "Error";
    private static final String artifactsDirectoryName = "archive";
    private static final String RUNID_BUILD_VARIABLE = "PC_RUN_ID";
    public static UsernamePasswordCredentials usernamePCPasswordCredentials;
    public static UsernamePasswordCredentials usernamePCPasswordCredentialsForProxy;
    private static transient Run<?, ?> _run;
    private static PrintStream logger;
    private final String timeslotDurationHours;
    private final String timeslotDurationMinutes;
    private final boolean statusBySLA;
    private PcModel pcModel;
    private String serverAndPort;
    private String pcServerName;
    private String credentialsId;
    private String almDomain;
    private String almProject;
    private String testId;
    private String testInstanceId;
    private String autoTestInstanceID;
    private PostRunAction postRunAction;
    private boolean vudsMode;
    private String description;
    private String addRunToTrendReport;
    private String trendReportId;
    private boolean HTTPSProtocol;
    private String proxyOutURL;
    private String credentialsProxyId;
    private String retry;
    private String retryDelay;
    private String retryOccurrences;
    private boolean authenticateWithToken;
    private int runId;
    private String testName;
    private FilePath pcReportFile;
    private String junitResultsFileName;
    private File WorkspacePath;
    private FilePath Workspace;

    @DataBoundConstructor
    public PcBuilder(String serverAndPort, String pcServerName, String credentialsId, String almDomain, String almProject, String testId, String testInstanceId, String autoTestInstanceID, String timeslotDurationHours, String timeslotDurationMinutes, PostRunAction postRunAction, boolean vudsMode, boolean statusBySLA, String description, String addRunToTrendReport, String trendReportId, boolean HTTPSProtocol, String proxyOutURL, String credentialsProxyId, String retry, String retryDelay, String retryOccurrences, boolean authenticateWithToken) {
        this.serverAndPort = serverAndPort;
        this.pcServerName = pcServerName;
        this.credentialsId = credentialsId;
        this.almDomain = almDomain;
        this.almProject = almProject;
        this.testId = testId;
        this.testInstanceId = testInstanceId;
        this.autoTestInstanceID = autoTestInstanceID;
        this.timeslotDurationHours = timeslotDurationHours;
        this.timeslotDurationMinutes = timeslotDurationMinutes;
        this.postRunAction = postRunAction;
        this.vudsMode = vudsMode;
        this.statusBySLA = statusBySLA;
        this.description = description;
        this.addRunToTrendReport = addRunToTrendReport;
        this.trendReportId = trendReportId;
        this.HTTPSProtocol = HTTPSProtocol;
        this.proxyOutURL = proxyOutURL;
        this.credentialsProxyId = credentialsProxyId;
        String string = this.retry = retry == null || retry.isEmpty() ? "NO_RETRY" : retry;
        String string2 = "NO_RETRY".equals(this.retry) ? "0" : (this.retryDelay = retryDelay == null || retryDelay.isEmpty() ? "5" : retryDelay);
        this.retryOccurrences = "NO_RETRY".equals(this.retry) ? "0" : (retryOccurrences == null || retryOccurrences.isEmpty() ? "3" : retryOccurrences);
        this.authenticateWithToken = authenticateWithToken;
    }

    public static UsernamePasswordCredentials getCredentialsId(String credentialsId) {
        if (credentialsId != null && _run != null) {
            return PcBuilder.getCredentialsById(credentialsId, _run, logger);
        }
        return null;
    }

    public static UsernamePasswordCredentials getCredentialsProxyId(String credentialsProxyId) {
        if (credentialsProxyId != null && _run != null) {
            return PcBuilder.getCredentialsById(credentialsProxyId, _run, logger);
        }
        return null;
    }

    private static UsernamePasswordCredentials getCredentialsById(String credentialsId, Run<?, ?> run, PrintStream logger) {
        if (StringUtils.isBlank((String)credentialsId)) {
            return null;
        }
        UsernamePasswordCredentials usernamePCPasswordCredentials = (UsernamePasswordCredentials)CredentialsProvider.findCredentialById((String)credentialsId, StandardUsernamePasswordCredentials.class, run, (List)URIRequirementBuilder.create().build());
        if (usernamePCPasswordCredentials == null) {
            logger.println(String.format("%s : %s", Messages.CannotFindCredentials(), credentialsId));
        }
        return usernamePCPasswordCredentials;
    }

    public static String getArtifactsDirectoryName() {
        return artifactsDirectoryName;
    }

    public static String getArtifactsResourceName() {
        return artifactsResourceName;
    }

    public static String getRunReportStructure() {
        return runReportStructure;
    }

    public static String getPcReportArchiveName() {
        return pcReportArchiveName;
    }

    public static String getPcreportFileName() {
        return pcReportFileName;
    }

    public static String getPluginVersion() {
        Plugin plugin = PcBuilder.getJenkinsInstance().getPlugin(Messages.ArtifactId());
        return plugin.getWrapper().getVersion();
    }

    private static Jenkins getJenkinsInstance() {
        Jenkins result = Jenkins.getInstance();
        if (result == null) {
            throw new IllegalStateException(Messages.FailedToObtainInstance());
        }
        return result;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        this.WorkspacePath = build.getWorkspace() != null ? new File(build.getWorkspace().toURI()) : null;
        if (this.getPcModel() != null && build != null && build instanceof AbstractBuild) {
            this.setPcModelBuildParameters(build, listener);
        }
        if (build.getWorkspace() == null) {
            return false;
        }
        this.perform((Run<?, ?>)build, build.getWorkspace(), launcher, (TaskListener)listener);
        return true;
    }

    private void setPcModelBuildParameters(AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        HashMap mapParamsAndEnvars = new HashMap();
        Map buildParameters = build.getBuildVariables();
        mapParamsAndEnvars.putAll(buildParameters);
        if (listener != null) {
            buildEnvars = build.getEnvironment((TaskListener)listener);
            mapParamsAndEnvars.putAll(buildEnvars);
        } else {
            buildEnvars = build.getEnvironment((TaskListener)new LogTaskListener(null, Level.INFO));
            mapParamsAndEnvars.putAll(buildEnvars);
        }
        String buildParametersAndEnvars = ((Object)mapParamsAndEnvars).toString();
        if (!buildParameters.isEmpty()) {
            this.getPcModel().setBuildParameters(buildParametersAndEnvars);
        }
    }

    public File getWorkspacePath() {
        return this.WorkspacePath;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public void setCredentialsId(String newCredentialsId) {
        this.credentialsId = newCredentialsId;
        this.pcModel = null;
        this.getPcModel();
    }

    public String getCredentialsProxyId() {
        return this.credentialsProxyId;
    }

    public void setCredentialsProxyId(String newCredentialsProxyId) {
        this.credentialsProxyId = newCredentialsProxyId;
        this.pcModel = null;
        this.getPcModel();
    }

    public PcModel getPcModel() {
        if (this.pcModel == null) {
            this.pcModel = new PcModel(this.serverAndPort.trim(), this.pcServerName.trim(), this.credentialsId, this.almDomain.trim(), this.almProject.trim(), this.testId.trim(), this.autoTestInstanceID, this.testInstanceId.trim(), this.timeslotDurationHours.trim(), this.timeslotDurationMinutes.trim(), this.postRunAction, this.vudsMode, this.description, this.addRunToTrendReport, this.trendReportId, this.HTTPSProtocol, this.proxyOutURL, this.credentialsProxyId, this.retry, this.retryDelay, this.retryOccurrences, this.authenticateWithToken);
        }
        return this.pcModel;
    }

    public String getRunResultsFileName() {
        return this.junitResultsFileName;
    }

    private void setBuildParameters(AbstractBuild<?, ?> build) {
        try {
            if (build != null && build.getBuildVariables() != null) {
                this.getPcModel().setBuildParameters(build.getBuildVariables().toString());
            }
        }
        catch (Exception ex) {
            logger.println(String.format("%s - %s: %s", DateFormatter.getDateTime(), Messages.BuildParameterNotConsidered(), ex.getMessage()));
        }
    }

    private String getVersion() {
        String completeVersion = PcBuilder.getPluginVersion();
        if (completeVersion != null) {
            String[] partsOfCompleteVersion = completeVersion.split(" [(]");
            return partsOfCompleteVersion[0];
        }
        return "unknown";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Testsuites execute(PcClient pcClient, Run<?, ?> build) throws InterruptedException, NullPointerException {
        _run = build;
        try {
            String version = this.getVersion();
            if (version != null && !version.equals("unknown")) {
                logger.println(String.format("%s - %s '%s'", DateFormatter.getDateTime(), Messages.PluginVersionIs(), version));
            }
            if (this.getPcModel() != null && build != null && build instanceof AbstractBuild) {
                this.setPcModelBuildParameters((AbstractBuild)build, null);
            }
            if (!StringUtils.isBlank((String)this.getPcModel().getDescription())) {
                logger.println(String.format("%s - %s: %s", DateFormatter.getDateTime(), Messages.TestDescription(), this.getPcModel().getDescription()));
            }
            if (!this.beforeRun(pcClient)) {
                Testsuites testsuites = null;
                return testsuites;
            }
            Testsuites testsuites = this.run(pcClient, build);
            return testsuites;
        }
        catch (InterruptedException e) {
            build.setResult(Result.ABORTED);
            pcClient.stopRun(this.runId);
            throw e;
        }
        catch (NullPointerException e) {
            logger.println(String.format("%s - %s: %s", DateFormatter.getDateTime(), Messages.Error(), e.getMessage()));
        }
        catch (Exception e) {
            logger.println(String.format("%s - %s", DateFormatter.getDateTime(), e.getMessage()));
        }
        finally {
            pcClient.logout();
        }
        return null;
    }

    private Testsuites run(PcClient pcClient, Run<?, ?> build) throws InterruptedException, ClientProtocolException, IOException, PcException {
        if (this.getPcModel() != null && build != null && build instanceof AbstractBuild) {
            this.setPcModelBuildParameters((AbstractBuild)build, null);
        }
        PcRunResponse response = null;
        String errorMessage = "";
        String eventLogString = "";
        boolean trendReportReady = false;
        try {
            this.runId = pcClient.startRun();
            if (this.runId == 0) {
                return null;
            }
        }
        catch (PcException | NumberFormatException | ClientProtocolException ex) {
            logger.println(String.format("%s - %s. %s: %s", DateFormatter.getDateTime(), Messages.StartRunFailed(), Messages.Error(), ex.getMessage()));
            throw ex;
        }
        catch (IOException ex) {
            logger.println(String.format("%s - %s. %s: %s", DateFormatter.getDateTime(), Messages.StartRunFailed(), Messages.Error(), ex.getMessage()));
            throw ex;
        }
        try {
            this.testName = pcClient.getTestName();
            if (this.testName == null) {
                this.testName = String.format("TestId_%s", this.getPcModel().getTestId());
                logger.println(String.format("%s - getTestName failed. Using '%s' as testname.", DateFormatter.getDateTime(), this.testName));
            } else {
                logger.println(String.format("%s - %s %s", DateFormatter.getDateTime(), Messages.TestNameIs(), this.testName));
            }
        }
        catch (PcException | IOException ex) {
            this.testName = String.format("TestId_%s", this.getPcModel().getTestId());
            logger.println(String.format("%s - getTestName failed. Using '%s' as testname. Error: %s \n", DateFormatter.getDateTime(), this.testName, ex.getMessage()));
        }
        try {
            ArrayList<ParameterValue> parameters = new ArrayList<ParameterValue>();
            parameters.add((ParameterValue)new StringParameterValue(RUNID_BUILD_VARIABLE, "" + this.runId));
            build.addAction((Action)new AdditionalParametersAction(parameters));
            logger.print(String.format("%s - %s: %s = %s \n", DateFormatter.getDateTime(), Messages.SetEnvironmentVariable(), RUNID_BUILD_VARIABLE, this.runId));
            response = pcClient.waitForRunCompletion(this.runId);
            if (response != null && RunState.get((String)response.getRunState()) == RunState.FINISHED && this.getPcModel().getPostRunAction() != PostRunAction.DO_NOTHING) {
                this.pcReportFile = pcClient.publishRunReport(this.runId, this.getReportDirectory(build));
                if (("USE_ID".equals(this.getPcModel().getAddRunToTrendReport()) && this.getPcModel().getTrendReportId(true) != null || "ASSOCIATED".equals(this.getPcModel().getAddRunToTrendReport())) && RunState.get((String)response.getRunState()) != RunState.RUN_FAILURE) {
                    Thread.sleep(5000L);
                    pcClient.addRunToTrendReport(this.runId, this.getPcModel().getTrendReportId(true));
                    pcClient.waitForRunToPublishOnTrendReport(this.runId, this.getPcModel().getTrendReportId(true));
                    pcClient.downloadTrendReportAsPdf(this.getPcModel().getTrendReportId(true), this.getTrendReportsDirectory(build));
                    trendReportReady = true;
                }
            } else if (response != null && RunState.get((String)response.getRunState()).ordinal() > RunState.FINISHED.ordinal()) {
                PcRunEventLog eventLog = pcClient.getRunEventLog(this.runId);
                eventLogString = this.buildEventLogString(eventLog);
            }
        }
        catch (PcException e) {
            logger.println(String.format("%s - Error: %s", DateFormatter.getDateTime(), e.getMessage()));
        }
        Testsuites ret = new Testsuites();
        this.parsePcRunResponse(ret, response, build, errorMessage, eventLogString);
        try {
            this.parsePcTrendResponse(ret, build, pcClient, trendReportReady, this.getPcModel().getTrendReportId(true), this.runId);
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return ret;
    }

    private String buildEventLogString(PcRunEventLog eventLog) {
        String logFormat = "%-5s | %-7s | %-19s | %s\n";
        StringBuilder eventLogStr = new StringBuilder("Event Log:\n\n" + String.format(logFormat, "ID", "TYPE", "TIME", "DESCRIPTION"));
        for (PcRunEventLogRecord record : eventLog.getRecordsList()) {
            eventLogStr.append(String.format(logFormat, record.getID(), record.getType(), record.getTime(), record.getDescription()));
        }
        return eventLogStr.toString();
    }

    private boolean beforeRun(PcClient pcClient) {
        return this.validatePcForm() && pcClient.login();
    }

    private String getReportDirectory(Run<?, ?> build) {
        return String.format(runReportStructure, build.getRootDir().getPath(), artifactsDirectoryName);
    }

    private String getTrendReportsDirectory(Run<?, ?> build) {
        return String.format(trendReportStructure, build.getRootDir().getPath(), artifactsDirectoryName);
    }

    @Deprecated
    public boolean perform(Build<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        return super.perform(build, launcher, listener);
    }

    private boolean validatePcForm() {
        logger.println(String.format("%s - %s", DateFormatter.getDateTime(), Messages.ValidatingParametersBeforeRun()));
        String prefix = "doCheck";
        boolean ret = true;
        Method[] methods = ((Object)((Object)this.getDescriptor())).getClass().getMethods();
        Method[] modelMethods = this.getPcModel().getClass().getMethods();
        block2: for (Method method : methods) {
            String name = method.getName();
            if (!name.startsWith(prefix)) continue;
            name = name.replace(prefix, "").toLowerCase();
            for (Method modelMethod : modelMethods) {
                String modelMethodName = modelMethod.getName();
                if (!modelMethodName.toLowerCase().equals("get" + name) || modelMethod.getParameterTypes().length != 0) continue;
                try {
                    Object obj = FormValidation.ok();
                    if (!("testinstanceid".equals(name) && "AUTO".equals(this.getPcModel().getAutoTestInstanceID()) || "retrydelay".equals(name) && "NO_RETRY".equals(this.getPcModel().getRetry()) || this.getPcModel().getRetry().isEmpty() || "retryoccurrences".equals(name) && "NO_RETRY".equals(this.getPcModel().getRetry()) || this.getPcModel().getRetry().isEmpty())) {
                        obj = "doCheckCredentialsId".equals(method.getName()) && "credentialsid".equals(name) && "getCredentialsId".equals(modelMethodName) || "doCheckCredentialsProxyId".equals(method.getName()) && "credentialsproxyid".equals(name) && "getCredentialsProxyId".equals(modelMethodName) ? method.invoke((Object)this.getDescriptor(), null, null, modelMethod.invoke((Object)this.getPcModel(), new Object[0])) : method.invoke((Object)this.getDescriptor(), modelMethod.invoke((Object)this.getPcModel(), new Object[0]));
                    }
                    if (obj.equals(FormValidation.ok())) continue block2;
                    logger.println(obj);
                    ret = false;
                    continue block2;
                }
                catch (Exception e) {
                    logger.println(String.format("%s - Validation error: method.getName() = '%s', name = '%s', modelMethodName = '%s', exception = '%s'.", DateFormatter.getDateTime(), method.getName(), name, modelMethodName, e.getMessage()));
                }
            }
        }
        boolean isTrendReportIdValid = this.validateTrendReportIdIsNumeric(this.getPcModel().getTrendReportId(true), "USE_ID".equals(this.getPcModel().getAddRunToTrendReport()));
        return ret &= isTrendReportIdValid;
    }

    private boolean validateTrendReportIdIsNumeric(String trendReportId, boolean addRunToTrendReport) {
        FormValidation res = FormValidation.ok();
        if (addRunToTrendReport) {
            if (trendReportId.isEmpty()) {
                res = FormValidation.error((String)String.format("%s: %s.", Messages.ParameterIsMissing(), Messages.TrendReportIDIsMissing()));
            } else {
                try {
                    Integer.parseInt(trendReportId);
                }
                catch (NumberFormatException e) {
                    res = FormValidation.error((String)Messages.IllegalParameter());
                }
            }
        }
        logger.println(String.format("%s - %s", DateFormatter.getDateTime(), res.toString().replace(": <div/>", "")));
        return res.equals(FormValidation.ok());
    }

    private Testsuites parsePcRunResponse(Testsuites ret, PcRunResponse runResponse, Run<?, ?> build, String errorMessage, String eventLogString) throws IOException, InterruptedException {
        RunState runState = RunState.get((String)runResponse.getRunState());
        List<Testsuite> testSuites = ret.getTestsuite();
        Testsuite testSuite = new Testsuite();
        Testcase testCase = new Testcase();
        testCase.setClassname("Performance Test.Load Test");
        testCase.setName(this.testName + "(ID:" + runResponse.getTestID() + ")");
        testCase.setTime(String.valueOf(runResponse.getDuration() * 60));
        if (this.pcReportFile != null && this.pcReportFile.exists() && runState == RunState.FINISHED) {
            testCase.getSystemOut().add(this.getOutputForReportLinks(build));
        }
        this.updateTestStatus(testCase, runResponse, errorMessage, eventLogString);
        testSuite.getTestcase().add(testCase);
        testSuite.setName("Performance Test ID: " + runResponse.getTestID() + ", Run ID: " + runResponse.getID());
        testSuites.add(testSuite);
        return ret;
    }

    private Testsuites parsePcTrendResponse(Testsuites ret, Run<?, ?> build, PcClient pcClient, boolean trendReportReady, String TrendReportID, int runID) throws PcException, IntrospectionException, IOException, InterruptedException, NoSuchMethodException {
        if (trendReportReady) {
            String reportUrlTemp = trendReportStructure.replaceFirst("%s/", "") + "/trendReport%s.pdf";
            String reportUrl = String.format(reportUrlTemp, artifactsResourceName, this.getPcModel().getTrendReportId(true));
            pcClient.publishTrendReport(reportUrl, this.getPcModel().getTrendReportId(true));
            if (this.isPluginActive("Plot plugin")) {
                logger.println(String.format("%s %s.", DateFormatter.getDateTime(), Messages.UpdatingCsvFilesForTrendingCharts()));
                this.updateCSVFilesForPlot(pcClient, runID);
                String plotUrlPath = "/job/" + build.getParent().getName() + "/plot";
                logger.println(String.format("%s - %s", DateFormatter.getDateTime(), HyperlinkNote.encodeTo((String)plotUrlPath, (String)Messages.TrendingCharts())));
            } else {
                logger.println(String.format("%s - %s %s (%s).", DateFormatter.getDateTime(), Messages.YouCanViewTrendCharts(), HyperlinkNote.encodeTo((String)"https://admhelp.microfocus.com/lre/en/2023-2023-r1/online_help/Content/PC/Continuous-Integration-Jenkins.htm#mt-item-4", (String)Messages.Documentation()), Messages.PerformanceCenter1255AndLater()));
            }
        }
        return ret;
    }

    private boolean isPluginActive(String pluginDisplayName) {
        List allPlugin = Jenkins.get().pluginManager.getPlugins();
        for (PluginWrapper pw : allPlugin) {
            if (!pw.getDisplayName().toLowerCase().equals(pluginDisplayName.toLowerCase())) continue;
            return pw.isActive();
        }
        return false;
    }

    private void updateCSVFilesForPlot(PcClient pcClient, int runId) throws IOException, PcException, IntrospectionException, NoSuchMethodException {
        TriTrendReportTypes[] triTrendReportTypes;
        for (TriTrendReportTypes triTrendReportType : triTrendReportTypes = new TriTrendReportTypes[]{new TriTrendReportTypes(TrendReportTypes.DataType.Transaction, TrendReportTypes.PctType.TRT, TrendReportTypes.Measurement.PCT_MINIMUM), new TriTrendReportTypes(TrendReportTypes.DataType.Transaction, TrendReportTypes.PctType.TRT, TrendReportTypes.Measurement.PCT_MAXIMUM), new TriTrendReportTypes(TrendReportTypes.DataType.Transaction, TrendReportTypes.PctType.TRT, TrendReportTypes.Measurement.PCT_AVERAGE), new TriTrendReportTypes(TrendReportTypes.DataType.Transaction, TrendReportTypes.PctType.TRT, TrendReportTypes.Measurement.PCT_MEDIAN), new TriTrendReportTypes(TrendReportTypes.DataType.Transaction, TrendReportTypes.PctType.TRT, TrendReportTypes.Measurement.PCT_STDDEVIATION), new TriTrendReportTypes(TrendReportTypes.DataType.Transaction, TrendReportTypes.PctType.TRT, TrendReportTypes.Measurement.PCT_COUNT1), new TriTrendReportTypes(TrendReportTypes.DataType.Transaction, TrendReportTypes.PctType.TRT, TrendReportTypes.Measurement.PCT_PERCENTILE_90), new TriTrendReportTypes(TrendReportTypes.DataType.Transaction, TrendReportTypes.PctType.TRT, TrendReportTypes.Measurement.PCT_PERCENTILE_95), new TriTrendReportTypes(TrendReportTypes.DataType.Transaction, TrendReportTypes.PctType.TPS, TrendReportTypes.Measurement.PCT_MINIMUM), new TriTrendReportTypes(TrendReportTypes.DataType.Transaction, TrendReportTypes.PctType.TPS, TrendReportTypes.Measurement.PCT_MAXIMUM), new TriTrendReportTypes(TrendReportTypes.DataType.Transaction, TrendReportTypes.PctType.TPS, TrendReportTypes.Measurement.PCT_AVERAGE), new TriTrendReportTypes(TrendReportTypes.DataType.Transaction, TrendReportTypes.PctType.TPS, TrendReportTypes.Measurement.PCT_MEDIAN), new TriTrendReportTypes(TrendReportTypes.DataType.Transaction, TrendReportTypes.PctType.TPS, TrendReportTypes.Measurement.PCT_SUM1), new TriTrendReportTypes(TrendReportTypes.DataType.Transaction, TrendReportTypes.PctType.TRS, TrendReportTypes.Measurement.PCT_COUNT1), new TriTrendReportTypes(TrendReportTypes.DataType.Monitors, TrendReportTypes.PctType.UDP, TrendReportTypes.Measurement.PCT_MINIMUM), new TriTrendReportTypes(TrendReportTypes.DataType.Monitors, TrendReportTypes.PctType.UDP, TrendReportTypes.Measurement.PCT_MAXIMUM), new TriTrendReportTypes(TrendReportTypes.DataType.Monitors, TrendReportTypes.PctType.UDP, TrendReportTypes.Measurement.PCT_AVERAGE), new TriTrendReportTypes(TrendReportTypes.DataType.Monitors, TrendReportTypes.PctType.UDP, TrendReportTypes.Measurement.PCT_MEDIAN), new TriTrendReportTypes(TrendReportTypes.DataType.Monitors, TrendReportTypes.PctType.UDP, TrendReportTypes.Measurement.PCT_STDDEVIATION), new TriTrendReportTypes(TrendReportTypes.DataType.Monitors, TrendReportTypes.PctType.UDP, TrendReportTypes.Measurement.PCT_COUNT1), new TriTrendReportTypes(TrendReportTypes.DataType.Monitors, TrendReportTypes.PctType.UDP, TrendReportTypes.Measurement.PCT_SUM1), new TriTrendReportTypes(TrendReportTypes.DataType.Regular, TrendReportTypes.PctType.VU, TrendReportTypes.Measurement.PCT_MAXIMUM), new TriTrendReportTypes(TrendReportTypes.DataType.Regular, TrendReportTypes.PctType.VU, TrendReportTypes.Measurement.PCT_AVERAGE), new TriTrendReportTypes(TrendReportTypes.DataType.Regular, TrendReportTypes.PctType.WEB, TrendReportTypes.Measurement.PCT_MINIMUM), new TriTrendReportTypes(TrendReportTypes.DataType.Regular, TrendReportTypes.PctType.WEB, TrendReportTypes.Measurement.PCT_MAXIMUM), new TriTrendReportTypes(TrendReportTypes.DataType.Regular, TrendReportTypes.PctType.WEB, TrendReportTypes.Measurement.PCT_AVERAGE), new TriTrendReportTypes(TrendReportTypes.DataType.Regular, TrendReportTypes.PctType.WEB, TrendReportTypes.Measurement.PCT_MEDIAN), new TriTrendReportTypes(TrendReportTypes.DataType.Regular, TrendReportTypes.PctType.WEB, TrendReportTypes.Measurement.PCT_SUM1)}) {
            this.saveFileToWorkspacePath(pcClient, this.getPcModel().getTrendReportId(true), runId, triTrendReportType.getDataType(), triTrendReportType.getPctType(), triTrendReportType.getMeasurement());
        }
    }

    private boolean saveFileToWorkspacePath(PcClient pcClient, String trendReportID, int runId, TrendReportTypes.DataType dataType, TrendReportTypes.PctType pctType, TrendReportTypes.Measurement measurement) throws IOException, PcException, IntrospectionException, NoSuchMethodException {
        String fileName = measurement.toString().toLowerCase() + "_" + pctType.toString().toLowerCase() + ".csv";
        Map<String, String> measurementMap = pcClient.getTrendReportByXML(trendReportID, runId, dataType, pctType, measurement);
        try {
            FilePath filePath = new FilePath(this.Workspace.getChannel(), this.getWorkspacePath().getPath() + "/" + fileName);
            Object filepathContent = "";
            for (String key : measurementMap.keySet()) {
                filepathContent = (String)filepathContent + key + ",";
            }
            filepathContent = (String)filepathContent + "\r\n";
            for (String value : measurementMap.values()) {
                filepathContent = (String)filepathContent + value + ",";
            }
            filePath.write((String)filepathContent, null);
            return true;
        }
        catch (InterruptedException e) {
            if (this.getWorkspacePath().getPath() != null) {
                logger.println(String.format("%s - %s: %s %s: %s. %s: %s", DateFormatter.getDateTime(), Messages.ErrorSavingFile(), fileName, Messages.ToWorkspacePath(), this.getWorkspacePath().getPath(), Messages.Error(), e.getMessage()));
            } else {
                logger.println(String.format("%s - %s: %s. %s. %s: %s", DateFormatter.getDateTime(), Messages.ErrorSavingFile(), fileName, Messages.WorkspacePathIsUnavailable(), Messages.Error(), e.getMessage()));
            }
            return false;
        }
    }

    private void updateTestStatus(Testcase testCase, PcRunResponse response, String errorMessage, String eventLog) {
        RunState runState = RunState.get((String)response.getRunState());
        if (runState == RunState.RUN_FAILURE) {
            this.setError(testCase, String.format("%s. %s", runState, errorMessage), eventLog);
        } else if (this.statusBySLA && runState == RunState.FINISHED && !response.getRunSLAStatus().equalsIgnoreCase("passed")) {
            this.setFailure(testCase, Messages.RunMeasurementsNotReachSLACriteria() + ": " + response.getRunSLAStatus(), eventLog);
        } else if (runState.hasFailure()) {
            this.setFailure(testCase, String.format("%s. %s", runState, errorMessage), eventLog);
        } else if (errorMessage != null && !errorMessage.isEmpty()) {
            this.setFailure(testCase, String.format("%s. %s", runState, errorMessage), eventLog);
        } else {
            testCase.setStatus("pass");
        }
    }

    private void setError(Testcase testCase, String message, String eventLog) {
        Error error = new Error();
        error.setMessage(message);
        if (eventLog != null && !eventLog.isEmpty()) {
            testCase.getSystemErr().add(eventLog);
        }
        testCase.getError().add(error);
        testCase.setStatus("error");
        logger.println(String.format("%s - %s %s", DateFormatter.getDateTime(), message, eventLog));
    }

    private void setFailure(Testcase testCase, String message, String eventLog) {
        Failure failure = new Failure();
        failure.setMessage(message);
        if (eventLog != null && !eventLog.isEmpty()) {
            testCase.getSystemErr().add(eventLog);
        }
        testCase.getFailure().add(failure);
        testCase.setStatus("failure");
        logger.println(String.format("%s - %s: %s %s", DateFormatter.getDateTime(), Messages.Failure(), message, eventLog));
    }

    private String getOutputForReportLinks(Run<?, ?> build) {
        String urlPattern = this.getArtifactsUrlPattern(build);
        String viewUrl = String.format(urlPattern + "/%s", pcReportFileName);
        String downloadUrl = String.format(urlPattern + "/%s", "*zip*/pcRun");
        logger.println(String.format("%s - %s", DateFormatter.getDateTime(), HyperlinkNote.encodeTo((String)viewUrl, (String)(Messages.ViewAnalysisReportOfRun() + " " + this.runId))));
        return String.format("%s: %s\n\n%s:\n%s\n\n%s:\n%s", Messages.LoadTestRunID(), this.runId, Messages.ViewAnalysisReport(), this.getPcModel().getserverAndPort() + "/" + build.getUrl() + viewUrl, Messages.DownloadReport(), this.getPcModel().getserverAndPort() + "/" + build.getUrl() + downloadUrl);
    }

    private String getArtifactsUrlPattern(Run<?, ?> build) {
        String runReportUrlTemp = runReportStructure.replaceFirst("%s/", "");
        return String.format(runReportUrlTemp, artifactsResourceName);
    }

    private void provideStepResultStatus(Result resultStatus, Run<?, ?> build) {
        String runIdStr = this.runId > 0 ? String.format(" (RunID: %s)", String.valueOf(this.runId)) : "";
        logger.println(String.format("%s - %s%s: %s\n- - -", DateFormatter.getDateTime(), Messages.ResultStatus(), runIdStr, resultStatus.toString()));
        build.setResult(resultStatus);
    }

    private Result createRunResults(FilePath filePath, Testsuites testsuites) {
        Result ret = Result.SUCCESS;
        try {
            if (testsuites != null) {
                StringWriter writer = new StringWriter();
                XStream xstream = new XStream();
                xstream.autodetectAnnotations(true);
                xstream.toXML((Object)testsuites, (Writer)writer);
                filePath.write(writer.toString(), null);
                if (this.containsErrorsOrFailures(testsuites.getTestsuite())) {
                    ret = Result.FAILURE;
                }
            } else {
                logger.println(String.format("%s - %s", DateFormatter.getDateTime(), Messages.EmptyResults()));
                ret = Result.FAILURE;
            }
        }
        catch (Exception cause) {
            logger.print(String.format("%s - %s. %s: %s", DateFormatter.getDateTime(), Messages.FailedToCreateRunResults(), Messages.Exception(), cause.getMessage()));
            ret = Result.FAILURE;
        }
        return ret;
    }

    private boolean containsErrorsOrFailures(List<Testsuite> testsuites) {
        boolean ret = false;
        block0: for (Testsuite testsuite : testsuites) {
            for (Testcase testcase : testsuite.getTestcase()) {
                String status = testcase.getStatus();
                if (!status.equals("error") && !status.equals("failure")) continue;
                ret = true;
                continue block0;
            }
        }
        return ret;
    }

    private String getJunitResultsFileName() {
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("ddMMyyyyHHmmssSSS");
        String time = now.format(formatter);
        this.junitResultsFileName = String.format("Results%s.xml", time);
        return this.junitResultsFileName;
    }

    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        this.Workspace = workspace;
        this.WorkspacePath = new File(workspace.toURI());
        Result resultStatus = Result.FAILURE;
        logger = listener.getLogger();
        if (this.credentialsId != null) {
            usernamePCPasswordCredentials = PcBuilder.getCredentialsById(this.credentialsId, build, logger);
        }
        if (this.credentialsProxyId != null && !this.credentialsProxyId.isEmpty()) {
            usernamePCPasswordCredentialsForProxy = PcBuilder.getCredentialsById(this.credentialsProxyId, build, logger);
        }
        PcClient pcClient = new PcClient(this.getPcModel(), logger);
        Testsuites testsuites = this.execute(pcClient, build);
        FilePath resultsFilePath = workspace.child(this.getJunitResultsFileName());
        resultStatus = this.createRunResults(resultsFilePath, testsuites);
        this.provideStepResultStatus(resultStatus, build);
        ParametersAction parameterAction = (ParametersAction)build.getAction(ParametersAction.class);
        ArrayList<ParameterValue> newParams = parameterAction != null ? new ArrayList<ParameterValue>(parameterAction.getAllParameters()) : new ArrayList();
        newParams.add((ParameterValue)new StringParameterValue("buildStepName", "PcBuilder"));
        newParams.add((ParameterValue)new StringParameterValue("resultsFilename", this.getRunResultsFileName()));
        if (parameterAction instanceof AdditionalParametersAction) {
            build.addOrReplaceAction((Action)new AdditionalParametersAction(newParams));
        } else {
            build.addOrReplaceAction((Action)new ParametersAction(newParams));
        }
        if (!Result.SUCCESS.equals(resultStatus) && !Result.FAILURE.equals(resultStatus)) {
            return;
        }
    }

    public String getServerAndPort() {
        return this.getPcModel().getserverAndPort();
    }

    public String getPcServerName() {
        return this.getPcModel().getPcServerName();
    }

    public String getAlmProject() {
        return this.getPcModel().getAlmProject();
    }

    public String getTestId() {
        return this.getPcModel().getTestId();
    }

    public String getAlmDomain() {
        return this.getPcModel().getAlmDomain();
    }

    public String getTimeslotDurationHours() {
        return this.getPcModel().getTimeslotDurationHours();
    }

    public String getTimeslotDurationMinutes() {
        return this.getPcModel().getTimeslotDurationMinutes();
    }

    public PostRunAction getPostRunAction() {
        return this.getPcModel().getPostRunAction();
    }

    public String getTrendReportId() {
        return this.getPcModel().getTrendReportId(true);
    }

    public String getAutoTestInstanceID() {
        return this.getPcModel().getAutoTestInstanceID();
    }

    public String getTestInstanceId() {
        return this.getPcModel().getTestInstanceId();
    }

    public String getAddRunToTrendReport() {
        return this.getPcModel().getAddRunToTrendReport();
    }

    public boolean isVudsMode() {
        return this.getPcModel().isVudsMode();
    }

    public boolean isAuthenticateWithToken() {
        return this.getPcModel().isAuthenticateWithToken();
    }

    public String getRetry() {
        return this.getPcModel().getRetry();
    }

    public String getRetryOccurrences() {
        return this.getPcModel().getRetryOccurrences();
    }

    public String getRetryDelay() {
        return this.getPcModel().getRetryDelay();
    }

    public String getDescription() {
        return this.getPcModel().getDescription();
    }

    public boolean isHTTPSProtocol() {
        return this.getPcModel().httpsProtocol();
    }

    public boolean isStatusBySLA() {
        return this.statusBySLA;
    }

    public String getProxyOutURL() {
        return this.getPcModel().getProxyOutURL();
    }

    @Extension
    @Symbol(value={"pcBuild"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return Messages.DisplayName();
        }

        public FormValidation doCheckPcServerName(@QueryParameter String value) {
            return this.validateString(value, "Server");
        }

        public FormValidation doCheckAlmDomain(@QueryParameter String value) {
            return this.validateString(value, "Domain");
        }

        public FormValidation doCheckAlmProject(@QueryParameter String value) {
            return this.validateString(value, "Project");
        }

        public FormValidation doCheckTestId(@QueryParameter String value) {
            return this.validateHigherThanInt(value, "Test ID", 0, true);
        }

        public FormValidation doCheckRetryDelay(@QueryParameter String value) {
            return this.validateHigherThanInt(value, "Delay between attempts (in minutes)", 0, true);
        }

        public FormValidation doCheckRetryOccurrences(@QueryParameter String value) {
            return this.validateHigherThanInt(value, "Number of attempts", 0, true);
        }

        public FormValidation doCheckTestInstanceId(@QueryParameter String value) {
            return this.validateHigherThanInt(value, "Test Instance ID", 0, true);
        }

        public FormValidation doCheckTimeslotDuration(@QueryParameter TimeslotDuration value) {
            return this.validateHigherThanInt(String.valueOf(value.toMinutes()), "Timeslot Duration (in minutes)", 30, false);
        }

        public FormValidation doCheckTimeslotId(@QueryParameter String value) {
            return this.validateHigherThanInt(value, "Timeslot ID", 0, true);
        }

        public FormValidation doCheckCredentialsId(@AncestorInPath Item project, @QueryParameter String pcUrl, @QueryParameter String value) {
            return this.checkCredentialsId(project, pcUrl, value);
        }

        public FormValidation doCheckCredentialsProxyId(@AncestorInPath Item project, @QueryParameter String pcUrl, @QueryParameter String value) {
            return this.checkCredentialsId(project, pcUrl, value);
        }

        public FormValidation checkCredentialsId(@AncestorInPath Item project, @QueryParameter String pcUrl, @QueryParameter String credentialIdValue) {
            if (project == null || !project.hasPermission(Item.EXTENDED_READ)) {
                return FormValidation.ok();
            }
            String credentialIdValueStr = Util.fixEmptyAndTrim((String)credentialIdValue);
            if (credentialIdValueStr == null) {
                return FormValidation.ok();
            }
            String pcUrlStr = Util.fixEmptyAndTrim((String)pcUrl);
            if (pcUrlStr == null) {
                return FormValidation.ok();
            }
            if (pcUrlStr.indexOf(36) >= 0) {
                return FormValidation.ok();
            }
            for (ListBoxModel.Option o : CredentialsProvider.listCredentials(StandardUsernamePasswordCredentials.class, (Item)project, (Authentication)(project instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)project)) : ACL.SYSTEM), (List)URIRequirementBuilder.create().build(), (CredentialsMatcher)new IdMatcher(credentialIdValueStr))) {
                if (!StringUtils.equals((String)credentialIdValueStr, (String)o.value)) continue;
                return FormValidation.ok();
            }
            return FormValidation.warning((String)String.format("%s s", Messages.CannotFindAnyCredentials(), credentialIdValueStr));
        }

        private FormValidation validateHigherThanInt(String value, String field, int limit, boolean limitIncluded) {
            FormValidation ret = FormValidation.ok();
            if (StringUtils.isBlank((String)(value = value.trim()))) {
                ret = FormValidation.error((String)(" " + Messages.MustBeSet()));
            } else {
                try {
                    if (value.matches("^\\$\\{[\\w-. ]*}$|^\\$[\\w-.]*$")) {
                        return ret;
                    }
                    if (value.matches("[0-9]*$|")) {
                        if (limitIncluded && Integer.parseInt(value) <= limit) {
                            ret = FormValidation.error((String)(" " + Messages.MustBeHigherThan() + " " + limit));
                        } else if (Integer.parseInt(value) < limit) {
                            ret = FormValidation.error((String)(" " + Messages.MustBeAtLeast() + " " + limit));
                        }
                    } else {
                        ret = FormValidation.error((String)(" " + Messages.MustBeAWholeNumberOrAParameter() + ", " + Messages.ForExample() + ": 23, $TESTID or ${TEST_ID}."));
                    }
                }
                catch (Exception e) {
                    ret = FormValidation.error((String)(" " + Messages.MustBeAWholeNumberOrAParameter() + " (" + Messages.ForExample() + ": $TESTID or ${TestID})"));
                }
            }
            return ret;
        }

        private FormValidation validateString(String value, String field) {
            FormValidation ret = FormValidation.ok();
            if (StringUtils.isBlank((String)value.trim())) {
                ret = FormValidation.error((String)(field + " " + Messages.MustBeSet()));
            }
            return ret;
        }

        public List<PostRunAction> getPostRunActions() {
            return PcModel.getPostRunActions();
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item project, @QueryParameter String credentialsId) {
            if (project == null || !project.hasPermission(Item.CONFIGURE)) {
                return new StandardUsernameListBoxModel().includeCurrentValue(credentialsId);
            }
            return new StandardUsernameListBoxModel().includeEmptyValue().includeAs(project instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)project)) : ACL.SYSTEM, project, StandardUsernamePasswordCredentials.class, URIRequirementBuilder.create().build()).includeCurrentValue(credentialsId);
        }

        public ListBoxModel doFillCredentialsProxyIdItems(@AncestorInPath Item project, @QueryParameter String credentialsId) {
            return this.doFillCredentialsIdItems(project, credentialsId);
        }
    }

    private class TriTrendReportTypes {
        private TrendReportTypes.DataType dataType;
        private TrendReportTypes.PctType pctType;
        private TrendReportTypes.Measurement measurement;

        TriTrendReportTypes(TrendReportTypes.DataType dataType, TrendReportTypes.PctType pctType, TrendReportTypes.Measurement measurement) {
            this.dataType = dataType;
            this.pctType = pctType;
            this.measurement = measurement;
        }

        public TrendReportTypes.DataType getDataType() {
            return this.dataType;
        }

        public TrendReportTypes.PctType getPctType() {
            return this.pctType;
        }

        public TrendReportTypes.Measurement getMeasurement() {
            return this.measurement;
        }
    }
}

