/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.run;

import com.google.common.collect.ArrayListMultimap;
import com.microfocus.application.automation.tools.model.AlmServerSettingsModel;
import com.microfocus.application.automation.tools.model.CredentialsModel;
import com.microfocus.application.automation.tools.model.SSOCredentialsModel;
import com.microfocus.application.automation.tools.run.RunFromAlmBuilder;
import com.microfocus.application.automation.tools.settings.AlmServerSettingsGlobalConfiguration;
import com.microfocus.application.automation.tools.sse.common.StringUtils;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Project;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.Secret;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.kohsuke.stapler.DataBoundConstructor;

public class MigrateAlmCredentialsBuilder
extends Recorder
implements Serializable,
SimpleBuildStep {
    @DataBoundConstructor
    public MigrateAlmCredentialsBuilder() {
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath filePath, @Nonnull Launcher launcher, @Nonnull TaskListener taskListener) throws InterruptedException, IOException {
        if (!this.isMigrationDone().booleanValue()) {
            MigrateAlmCredentialsBuilder.scanJobs(taskListener);
        } else {
            taskListener.getLogger().println("ALM credentials have been already migrated to Jenkins Configure page.");
        }
    }

    public static void scanJobs(TaskListener listener) {
        List jobs = Jenkins.getInstanceOrNull().getAllItems(Project.class);
        List<AlmServerSettingsModel> models = Arrays.asList(AlmServerSettingsGlobalConfiguration.getInstance().getInstallations());
        ArrayListMultimap serverUsernames = ArrayListMultimap.create();
        ArrayListMultimap serverClientIds = ArrayListMultimap.create();
        for (Project job : jobs) {
            List builders = job.getBuilders();
            if (builders == null) continue;
            for (Builder builder : builders) {
                if (!(builder instanceof RunFromAlmBuilder)) continue;
                RunFromAlmBuilder almBuilder = (RunFromAlmBuilder)builder;
                String almUsername = almBuilder.runFromAlmModel.getAlmUserName();
                String almClientID = almBuilder.runFromAlmModel.getAlmClientID();
                if (StringUtils.isNullOrEmpty(almUsername) && StringUtils.isNullOrEmpty(almClientID)) continue;
                listener.getLogger().println("Migrating credentials from task " + job.getDisplayName());
                for (AlmServerSettingsModel model : models) {
                    if (!model.getAlmServerName().equals(almBuilder.getAlmServerName())) continue;
                    if (!(StringUtils.isNullOrEmpty(almUsername) || serverUsernames.get((Object)model.getAlmServerName()).contains(almUsername) || almUsername.equals("No username defined in Jenkins Configure System page") || almBuilder.runFromAlmModel.getAlmPassword() == null)) {
                        Secret almPassword = almBuilder.runFromAlmModel.getAlmPassword();
                        serverUsernames.put((Object)model.getAlmServerName(), (Object)almUsername);
                        model.set_almCredentials(Arrays.asList(new CredentialsModel(almUsername, almPassword)));
                        listener.getLogger().println("Migrating username '" + almUsername + "' 'for server: " + model.getAlmServerName() + ", " + model.getAlmServerUrl());
                    }
                    if (!(StringUtils.isNullOrEmpty(almClientID) || serverClientIds.get((Object)model.getAlmServerName()).contains(almClientID) || almClientID.equals("No client ID defined in Jenkins Configure System page") || almBuilder.runFromAlmModel.getAlmApiKey() == null)) {
                        String almApiKeySecret = almBuilder.runFromAlmModel.getAlmApiKey().getPlainText();
                        serverClientIds.put((Object)model.getAlmServerName(), (Object)almClientID);
                        model.set_almSSOCredentials(Arrays.asList(new SSOCredentialsModel(almClientID, almApiKeySecret)));
                        listener.getLogger().println("Migrating client ID '" + almClientID + "' for server: " + model.getAlmServerName() + ", " + model.getAlmServerUrl());
                    }
                    try {
                        job.save();
                    }
                    catch (IOException e) {
                        listener.getLogger().println("Job not saved.");
                    }
                    listener.getLogger().println("------------------------------");
                }
            }
        }
    }

    public Boolean isMigrationDone() {
        List<AlmServerSettingsModel> models = Arrays.asList(AlmServerSettingsGlobalConfiguration.getInstance().getInstallations());
        for (AlmServerSettingsModel model : models) {
            if (model == null || model.getAlmCredentials().isEmpty() && model.getAlmSSOCredentials().isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Migrate ALM Credentials";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

