/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.results.service;

import com.microfocus.application.automation.tools.results.parser.ReportParserManager;
import com.microfocus.application.automation.tools.results.service.AlmRestInfo;
import com.microfocus.application.automation.tools.results.service.AlmRestTool;
import com.microfocus.application.automation.tools.results.service.ExternalEntityUploadException;
import com.microfocus.application.automation.tools.results.service.IExternalEntityUploadService;
import com.microfocus.application.automation.tools.results.service.almentities.AlmEntity;
import com.microfocus.application.automation.tools.results.service.almentities.AlmRun;
import com.microfocus.application.automation.tools.results.service.almentities.AlmTest;
import com.microfocus.application.automation.tools.results.service.almentities.AlmTestConfig;
import com.microfocus.application.automation.tools.results.service.almentities.AlmTestConfigImpl;
import com.microfocus.application.automation.tools.results.service.almentities.AlmTestFolder;
import com.microfocus.application.automation.tools.results.service.almentities.AlmTestFolderImpl;
import com.microfocus.application.automation.tools.results.service.almentities.AlmTestImpl;
import com.microfocus.application.automation.tools.results.service.almentities.AlmTestInstance;
import com.microfocus.application.automation.tools.results.service.almentities.AlmTestInstanceImpl;
import com.microfocus.application.automation.tools.results.service.almentities.AlmTestSet;
import com.microfocus.application.automation.tools.results.service.almentities.AlmTestSetFolder;
import com.microfocus.application.automation.tools.results.service.almentities.AlmTestSetFolderImpl;
import com.microfocus.application.automation.tools.results.service.almentities.AlmTestSetImpl;
import com.microfocus.application.automation.tools.sse.sdk.Logger;
import hudson.FilePath;
import java.sql.Date;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;

public class DefaultExternalEntityUploadServiceImpl
implements IExternalEntityUploadService {
    Logger logger;
    private AlmRestTool restTool;
    private FilePath workspace;
    String FOLDER_SEPERATOR = "\\";

    public DefaultExternalEntityUploadServiceImpl(AlmRestTool restTool, FilePath workspace, Logger logger) {
        this.restTool = restTool;
        this.logger = logger;
        this.workspace = workspace;
    }

    private String[] getTestCreationFields() {
        return new String[]{"name", "subtype-id", "testing-framework", "testing-tool", "ut-package-name", "ut-class-name", "ut-method-name", "parent-id", "owner"};
    }

    private AlmTest importTest(AlmTest test, int testFolderId, String testingTool, String testdesigner) throws ExternalEntityUploadException {
        String className = (String)test.getFieldValue("ut-class-name");
        String methodName = (String)test.getFieldValue("ut-method-name");
        String packageName = (String)test.getFieldValue("ut-package-name");
        String testingFramework = (String)test.getFieldValue("testing-framework");
        String queryString = String.format("query={parent-id[%s];subtype-id[EXTERNAL-TEST];ut-class-name[%s];ut-method-name[%s]}&fields=id,name,ut-package-name,ut-class-name,ut-method-name,testing-framework&page-size=2000", String.valueOf(testFolderId), AlmRestTool.getEncodedString(className), AlmRestTool.getEncodedString(methodName));
        List<AlmTestImpl> existingTests = this.restTool.getAlmEntity(new AlmTestImpl(), queryString);
        AlmTestImpl importedTest = null;
        if (existingTests != null && existingTests.size() > 0) {
            boolean exists = false;
            HashMap<String, AlmTestImpl> existingTestMap = new HashMap<String, AlmTestImpl>();
            for (AlmTestImpl existingTest : existingTests) {
                if (existingTest.getKey().endsWith(test.getKey())) {
                    exists = true;
                    importedTest = existingTest;
                    break;
                }
                existingTestMap.put(existingTest.getName(), existingTest);
            }
            if (!exists) {
                String tempName = className + "_" + methodName;
                if (!existingTestMap.containsKey(tempName)) {
                    test.setFieldValue("name", tempName);
                } else if (!existingTestMap.containsKey(tempName = packageName + "_" + tempName)) {
                    test.setFieldValue("name", tempName);
                } else if (!existingTestMap.containsKey(tempName = tempName + "_" + testingFramework)) {
                    test.setFieldValue("name", tempName);
                }
            }
        }
        if (importedTest == null) {
            test.setFieldValue("parent-id", String.valueOf(testFolderId));
            test.setFieldValue("testing-tool", testingTool);
            test.setFieldValue("owner", testdesigner);
            return this.restTool.createAlmEntity(test, this.getTestCreationFields());
        }
        return importedTest;
    }

    private String[] getTestSetCreationFields() {
        return new String[]{"parent-id", "name", "subtype-id"};
    }

    private AlmTestSet importTestSet(AlmTestSet testset, int testsetFolderId) throws ExternalEntityUploadException {
        AlmTestSetImpl importedTestset = this.restTool.getEntityUnderParentFolder(AlmTestSetImpl.class, testsetFolderId, testset.getName());
        if (importedTestset == null) {
            testset.setFieldValue("parent-id", String.valueOf(testsetFolderId));
            return this.restTool.createAlmEntity(testset, this.getTestSetCreationFields());
        }
        return importedTestset;
    }

    private AlmTestConfig getMainTestConfig(AlmTest test) {
        AlmTestConfigImpl testConfigImpl = new AlmTestConfigImpl();
        String queryString = String.format("query={parent-id[%s]}&fields=id,name", String.valueOf(test.getId()));
        List<AlmTestConfigImpl> testconfigs = this.restTool.getAlmEntity(testConfigImpl, queryString);
        if (testconfigs != null && testconfigs.size() > 0) {
            return testconfigs.get(0);
        }
        return null;
    }

    private String[] getTestInstanceCreationFields() {
        return new String[]{"cycle-id", "test-config-id", "test-id", "owner", "subtype-id"};
    }

    private AlmTestInstance importTestInstance(AlmTestInstance testinstance, String testsetId, String testId, String testconfigId, String tester) throws ExternalEntityUploadException {
        String queryString = String.format("query={cycle-id[%s];test-config-id[%s];test-id[%s]}&fields=id,name", String.valueOf(testsetId), String.valueOf(testconfigId), String.valueOf(testId));
        List<AlmTestInstanceImpl> testInstances = this.restTool.getAlmEntity(new AlmTestInstanceImpl(), queryString);
        if (testInstances != null && testInstances.size() > 0) {
            return testInstances.get(0);
        }
        testinstance.setFieldValue("cycle-id", String.valueOf(testsetId));
        testinstance.setFieldValue("test-config-id", String.valueOf(testconfigId));
        testinstance.setFieldValue("test-id", String.valueOf(testId));
        testinstance.setFieldValue("owner", tester);
        return this.restTool.createAlmEntity(testinstance, this.getTestInstanceCreationFields());
    }

    private String generateImportRunName() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date(System.currentTimeMillis()));
        return String.format("Import_Run_%d-%d_%d-%d-%d", cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13));
    }

    private String[] getRunCreationFields() {
        return new String[]{"test-config-id", "cycle-id", "test-id", "testcycl-id", "build-revision", "name", "owner", "status", "subtype-id", "detail", "duration", "jenkins-job-name", "jenkins-url", "execution-date", "execution-time", "status"};
    }

    private AlmRun generateRun(String tester, AlmRun run, String testsetId, String testId, String testInstanceId, String testconfigId, String subversion, String jobName, String buildUrl) throws ExternalEntityUploadException {
        run.setFieldValue("test-config-id", String.valueOf(testconfigId));
        run.setFieldValue("cycle-id", String.valueOf(testsetId));
        run.setFieldValue("test-id", String.valueOf(testId));
        run.setFieldValue("testcycl-id", String.valueOf(testInstanceId));
        run.setFieldValue("jenkins-job-name", jobName);
        run.setFieldValue("jenkins-url", buildUrl);
        if (subversion != null && subversion.length() > 0) {
            run.setFieldValue("build-revision", subversion);
        } else {
            run.setFieldValue("build-revision", "");
        }
        run.setFieldValue("name", this.generateImportRunName());
        run.setFieldValue("owner", tester);
        return this.restTool.createAlmEntity(run, this.getRunCreationFields());
    }

    private String[] getCreationFieldsForTestFolder() {
        return new String[]{"name", "parent-id"};
    }

    private AlmTestFolder createTestFolder(int parentId, String folderName) throws ExternalEntityUploadException {
        AlmTestFolderImpl testFolder = this.restTool.getEntityUnderParentFolder(AlmTestFolderImpl.class, parentId, folderName);
        String encodedFolderName = folderName;
        if (testFolder == null) {
            testFolder = new AlmTestFolderImpl();
            testFolder.setFieldValue("parent-id", String.valueOf(parentId));
            testFolder.setFieldValue("name", encodedFolderName);
            return this.restTool.createAlmEntity(testFolder, this.getCreationFieldsForTestFolder());
        }
        return testFolder;
    }

    private AlmTestFolder createTestFolderPath(int parentId, String path) throws ExternalEntityUploadException {
        ArrayList<AlmTestFolder> folders = new ArrayList<AlmTestFolder>();
        StringTokenizer tokenizer = new StringTokenizer(path, this.FOLDER_SEPERATOR);
        while (tokenizer.hasMoreTokens()) {
            String itemString = tokenizer.nextToken();
            AlmTestFolder testFolder = this.createTestFolder(parentId, itemString);
            if (testFolder == null) continue;
            folders.add(testFolder);
            parentId = Integer.valueOf(testFolder.getId());
        }
        if (folders.size() > 0) {
            return (AlmTestFolder)folders.get(folders.size() - 1);
        }
        return null;
    }

    private String[] getCreationFieldsForTestSetFolder() {
        return new String[]{"name", "parent-id"};
    }

    private AlmTestSetFolder createTestSetFolder(int parentId, String folderName) throws ExternalEntityUploadException {
        AlmTestSetFolderImpl testsetFolder = this.restTool.getEntityUnderParentFolder(AlmTestSetFolderImpl.class, parentId, folderName);
        String encodedFolderName = folderName;
        if (testsetFolder == null) {
            testsetFolder = new AlmTestSetFolderImpl();
            testsetFolder.setFieldValue("parent-id", String.valueOf(parentId));
            testsetFolder.setFieldValue("name", encodedFolderName);
            return this.restTool.createAlmEntity(testsetFolder, this.getCreationFieldsForTestSetFolder());
        }
        return testsetFolder;
    }

    private AlmTestSetFolder createTestSetFolderPath(int parentId, String path) throws ExternalEntityUploadException {
        ArrayList<AlmTestSetFolder> folders = new ArrayList<AlmTestSetFolder>();
        StringTokenizer tokenizer = new StringTokenizer(path, this.FOLDER_SEPERATOR);
        while (tokenizer.hasMoreTokens()) {
            String itemString = tokenizer.nextToken();
            AlmTestSetFolder testsetFolder = this.createTestSetFolder(parentId, itemString);
            if (testsetFolder == null) continue;
            folders.add(testsetFolder);
            parentId = Integer.valueOf(testsetFolder.getId());
        }
        if (folders.size() > 0) {
            return (AlmTestSetFolder)folders.get(folders.size() - 1);
        }
        return null;
    }

    @Override
    public List<String> uploadExternalTestSet(AlmRestInfo loginInfo, String reportFilePath, String testsetFolderPath, String testFolderPath, String testingFramework, String testingTool, String subversion, String jobName, String buildUrl) throws ExternalEntityUploadException {
        this.logger.log("INFO: Start to parse file: " + reportFilePath);
        List<String> importedTestsetIds = new ArrayList<String>();
        ReportParserManager reportParserManager = ReportParserManager.getInstance(this.workspace, this.logger);
        List<AlmTestSet> testsets = reportParserManager.parseTestSets(reportFilePath, testingFramework, testingTool);
        if (testsets == null) {
            throw new ExternalEntityUploadException("Failed to parse file: " + reportFilePath);
        }
        this.logger.log("INFO: parse resut file succeed.");
        if (testsets.size() <= 0) {
            this.logger.log("INFO: No testset to upload.");
            return importedTestsetIds;
        }
        this.logger.log("INFO: Start to login to ALM Server.");
        try {
            if (!this.restTool.login()) {
                throw new ExternalEntityUploadException("Failed to login to ALM Server.");
            }
            String actualUser = this.restTool.getActualUsername();
            if (actualUser == null || actualUser.length() == 0) {
                throw new ExternalEntityUploadException("Failed to get actual login user.");
            }
            this.logger.log("INFO: Checking test folder...");
            AlmTestFolder testFolder = this.createTestFolderPath(2, testFolderPath);
            this.logger.log("INFO: Checking testset folder...");
            AlmTestSetFolder testsetFolder = this.createTestSetFolderPath(0, testsetFolderPath);
            if (testFolder != null && testsetFolder != null) {
                this.logger.log("INFO: Uploading ALM Entities...");
                importedTestsetIds = this.importExternalTestSet(testsets, actualUser, Integer.valueOf(testsetFolder.getId()), Integer.valueOf(testFolder.getId()), testingTool, subversion, jobName, buildUrl);
            }
        }
        catch (Exception e) {
            throw new ExternalEntityUploadException(e);
        }
        return importedTestsetIds;
    }

    private List<String> importExternalTestSet(List<AlmTestSet> testsets, String tester, int testsetFolderId, int testFolderId, String testingTool, String subversion, String jobName, String buildUrl) throws ExternalEntityUploadException {
        ArrayList<String> importedTestsetIds = new ArrayList<String>();
        for (AlmTestSet testset : testsets) {
            AlmTestSet importedTestSet = this.importTestSet(testset, testsetFolderId);
            if (importedTestSet == null) continue;
            importedTestsetIds.add(importedTestSet.getId());
            List<AlmEntity> testinstances = testset.getRelatedEntities().get("TESTSET_TO_TESTINSTANCE_CONTAINMENT_RELATION");
            if (testinstances == null || testinstances.size() <= 0) continue;
            for (AlmEntity testinstanceEntity : testinstances) {
                AlmTestConfig mainTestConfig;
                AlmTest test;
                AlmTest importedTest;
                AlmTestInstance testInstance = (AlmTestInstance)testinstanceEntity;
                List<AlmEntity> tests = testInstance.getRelatedEntities().get("TEST_TO_TESTINSTANCE_REALIZATION_RELATION");
                if (tests == null || tests.size() <= 0 || (importedTest = this.importTest(test = (AlmTest)tests.get(0), testFolderId, testingTool, tester)) == null || (mainTestConfig = this.getMainTestConfig(importedTest)) == null) continue;
                AlmTestInstance importedTestInstance = this.importTestInstance(testInstance, importedTestSet.getId(), importedTest.getId(), mainTestConfig.getId(), tester);
                List<AlmEntity> runs = testInstance.getRelatedEntities().get("TESTINSTANCE_TO_RUN_REALIZATION_RELATION");
                if (runs == null || runs.size() <= 0) continue;
                AlmRun run = (AlmRun)runs.get(0);
                this.generateRun(tester, run, importedTestSet.getId(), importedTest.getId(), importedTestInstance.getId(), mainTestConfig.getId(), subversion, jobName, buildUrl);
            }
        }
        return importedTestsetIds;
    }
}

