/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.results.service;

import com.microfocus.application.automation.tools.common.Pair;
import com.microfocus.application.automation.tools.rest.RestClient;
import com.microfocus.application.automation.tools.results.service.AlmRestInfo;
import com.microfocus.application.automation.tools.results.service.ExternalEntityUploadException;
import com.microfocus.application.automation.tools.results.service.almentities.AlmEntity;
import com.microfocus.application.automation.tools.results.service.rest.CreateAlmEntityRequest;
import com.microfocus.application.automation.tools.results.service.rest.GetAlmEntityRequest;
import com.microfocus.application.automation.tools.results.service.rest.UpdateAlmEntityRequest;
import com.microfocus.application.automation.tools.sse.common.XPathUtils;
import com.microfocus.application.automation.tools.sse.sdk.Logger;
import com.microfocus.application.automation.tools.sse.sdk.ResourceAccessLevel;
import com.microfocus.application.automation.tools.sse.sdk.Response;
import com.microfocus.application.automation.tools.sse.sdk.authenticator.AuthenticationTool;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlmRestTool {
    private Logger _logger;
    private RestClient restClient;
    private AlmRestInfo almLoginInfo;
    private final String USERNAMEPRETAG = "<Username>";
    private final String USERNAMESUBTAG = "</Username>";

    public AlmRestTool(RestClient restClient, Logger logger) {
        this.restClient = restClient;
        this._logger = logger;
    }

    public AlmRestTool(AlmRestInfo almLoginInfo, Logger logger) {
        this.restClient = new RestClient(almLoginInfo.getServerUrl(), almLoginInfo.getDomain(), almLoginInfo.getProject(), almLoginInfo.getUserName());
        this.almLoginInfo = almLoginInfo;
        this._logger = logger;
    }

    public RestClient getRestClient() {
        return this.restClient;
    }

    public boolean login() {
        return AuthenticationTool.getInstance().authenticate(this.restClient, this.almLoginInfo.getUserName(), this.almLoginInfo.getPassword(), this.almLoginInfo.getServerUrl(), this.almLoginInfo.getClientType(), this._logger);
    }

    public String getActualUsername() {
        Response response = this.restClient.httpGet(this.restClient.build("rest/is-authenticated"), null, null, ResourceAccessLevel.PUBLIC);
        if (!response.isOk()) {
            this._logger.log("ERR: Cannot get actual login username: " + String.valueOf(response.getFailure()));
            return null;
        }
        String responseData = new String(response.getData());
        if (!responseData.contains("<Username>") || !responseData.contains("</Username>")) {
            this._logger.log("ERR: Response is not as expected: " + responseData);
            return null;
        }
        return responseData.substring(responseData.indexOf("<Username>") + "<Username>".length(), responseData.indexOf("</Username>"));
    }

    public List<Pair<String, String>> getPairListForAlmEntityFields(AlmEntity almEntity, List<String> fieldNames) {
        ArrayList<Pair<String, String>> pairs = new ArrayList<Pair<String, String>>();
        for (String fieldName : fieldNames) {
            pairs.add(new Pair<String, String>(fieldName, String.valueOf(almEntity.getFieldValue(fieldName))));
        }
        return pairs;
    }

    public List<Pair<String, String>> getPairListForAlmEntityFields(AlmEntity almEntity, String[] fieldNames) {
        ArrayList<Pair<String, String>> pairs = new ArrayList<Pair<String, String>>();
        for (String fieldName : fieldNames) {
            pairs.add(new Pair<String, String>(fieldName, String.valueOf(almEntity.getFieldValue(fieldName))));
        }
        return pairs;
    }

    public List<Map<String, String>> getMapListForAlmEntityFields(AlmEntity almEntity, String[] fieldNames) {
        ArrayList<Map<String, String>> fieldsMapList = new ArrayList<Map<String, String>>();
        HashMap<String, String> fieldsMap = new HashMap<String, String>();
        for (String fieldName : fieldNames) {
            fieldsMap.put(fieldName, String.valueOf(almEntity.getFieldValue(fieldName)));
        }
        fieldsMapList.add(fieldsMap);
        return fieldsMapList;
    }

    public void populateAlmEntityFieldValue(Map<String, String> mapFieldValue, AlmEntity almEntity) {
        for (Map.Entry<String, String> entry : mapFieldValue.entrySet()) {
            almEntity.setFieldValue(entry.getKey(), entry.getValue());
        }
    }

    public <E extends AlmEntity> List<E> getAlmEntityList(List<Map<String, String>> entities, Class<E> c) {
        ArrayList<AlmEntity> entityList = new ArrayList<AlmEntity>();
        for (Map<String, String> fieldValueMap : entities) {
            try {
                AlmEntity entity = (AlmEntity)c.newInstance();
                this.populateAlmEntityFieldValue(fieldValueMap, entity);
                entityList.add(entity);
            }
            catch (Exception exception) {}
        }
        return entityList;
    }

    public static String getEncodedString(String s) {
        Object quotedStr = "\"" + s + "\"";
        try {
            quotedStr = URLEncoder.encode((String)quotedStr, "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return quotedStr;
    }

    public <E extends AlmEntity> E getEntityUnderParentFolder(Class<E> entityClass, int parentId, String entityName) {
        String getEntityUnderParentFolderQuery = String.format("fields=id,name&query={parent-id[%s];name[%s]}", String.valueOf(parentId), AlmRestTool.getEncodedString(entityName));
        try {
            AlmEntity entity = (AlmEntity)entityClass.newInstance();
            GetAlmEntityRequest getRequest = new GetAlmEntityRequest(entity, this.getRestClient(), getEntityUnderParentFolderQuery);
            Response response = getRequest.perform();
            if (response.isOk()) {
                List<Map<String, String>> entities2 = XPathUtils.toEntities(response.toString());
                List<E> entities = this.getAlmEntityList(entities2, entityClass);
                if (entities.size() > 0) {
                    return (E)((AlmEntity)entities.get(0));
                }
                return null;
            }
            this._logger.log("Failed to get Entity:" + getEntityUnderParentFolderQuery);
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public <E extends AlmEntity> List<E> getAlmEntity(E entity, String queryString) {
        ArrayList ret = new ArrayList();
        try {
            GetAlmEntityRequest getRequest = new GetAlmEntityRequest(entity, this.getRestClient(), queryString);
            Response response = getRequest.perform();
            if (response.isOk() && !response.toString().equals("")) {
                List<Map<String, String>> entities2 = XPathUtils.toEntities(response.toString());
                List<?> entities = this.getAlmEntityList(entities2, entity.getClass());
                return entities;
            }
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            this._logger.log("Failed to get Entity:" + entity.toString() + " with query string:" + queryString);
            return ret;
        }
    }

    public <E extends AlmEntity> E createAlmEntity(E entity, String[] fieldsForCreation) throws ExternalEntityUploadException {
        CreateAlmEntityRequest createRequest = new CreateAlmEntityRequest(this.getRestClient(), entity, this.getPairListForAlmEntityFields(entity, fieldsForCreation));
        Response response = createRequest.perform();
        if (response.isOk() && !response.toString().equals("")) {
            List<Map<String, String>> entities2 = XPathUtils.toEntities(response.toString());
            List<?> entities = this.getAlmEntityList(entities2, entity.getClass());
            if (entities.size() > 0) {
                return (E)((AlmEntity)entities.get(0));
            }
            this._logger.log("Failed to create Entity:" + entity.toString());
            throw new ExternalEntityUploadException("Failed to create Entity:" + entity.toString());
        }
        this._logger.log("Failed to create Entity:" + entity.toString());
        throw new ExternalEntityUploadException("Failed to create Entity:" + entity.toString());
    }

    public <E extends AlmEntity> void updateAlmEntity(E entity, String[] fieldsForUpdate) {
        UpdateAlmEntityRequest updateRequest = new UpdateAlmEntityRequest(this.getRestClient(), entity, this.getMapListForAlmEntityFields(entity, fieldsForUpdate));
        Response response = updateRequest.execute();
        if (!response.isOk()) {
            this._logger.log("Failed to update entity:" + entity.toString());
        }
    }
}

