/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.results.parser.nunit3;

import com.microfocus.application.automation.tools.results.parser.ReportParseException;
import com.microfocus.application.automation.tools.results.parser.ReportParser;
import com.microfocus.application.automation.tools.results.parser.antjunit.AntJUnitReportParserImpl;
import com.microfocus.application.automation.tools.results.service.almentities.AlmTestSet;
import hudson.FilePath;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class NUnit3ReportParserImpl
implements ReportParser {
    private static final String TEMP_JUNIT_FILE_PREFIX = "temp-junit";
    private static final String TEMP_JUNIT_FILE_SUFFIX = ".xml";
    private static final String NUNIT_TO_JUNIT_XSLFILE = "nunit-to-junit.xsl";
    private FilePath workspace;

    public NUnit3ReportParserImpl(FilePath workspace) {
        this.workspace = workspace;
    }

    @Override
    public List<AlmTestSet> parseTestSets(InputStream reportInputStream, String testingFramework, String testingTool) throws ReportParseException {
        FileOutputStream fileOutputStream = null;
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer nunitTransformer = transformerFactory.newTransformer(new StreamSource(this.getClass().getResourceAsStream(NUNIT_TO_JUNIT_XSLFILE)));
            File junitTargetFile = new File(this.workspace.createTempFile(TEMP_JUNIT_FILE_PREFIX, TEMP_JUNIT_FILE_SUFFIX).toURI());
            fileOutputStream = new FileOutputStream(junitTargetFile);
            nunitTransformer.transform(new StreamSource(reportInputStream), new StreamResult(fileOutputStream));
            FileInputStream in = new FileInputStream(junitTargetFile);
            List<AlmTestSet> list = new AntJUnitReportParserImpl().parseTestSets(in, testingFramework, testingTool);
            return list;
        }
        catch (Exception e) {
            throw new ReportParseException(e);
        }
        finally {
            try {
                if (reportInputStream != null) {
                    reportInputStream.close();
                }
            }
            catch (IOException e) {
                throw new ReportParseException(e);
            }
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException e) {
                throw new ReportParseException(e);
            }
        }
    }
}

