/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.results.lrscriptresultparser;

import com.microfocus.application.automation.tools.results.lrscriptresultparser.LrScriptHtmlReport;
import hudson.model.Action;
import hudson.model.Run;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import jenkins.util.VirtualFile;

public class LrScriptHtmlReportAction
implements Action {
    private final VirtualFile basePath;
    private Run build;
    private HashSet<String> scripts = new HashSet();
    private List<LrScriptHtmlReport> reportMetaDataList = new ArrayList<LrScriptHtmlReport>();

    public LrScriptHtmlReportAction(Run<?, ?> build) {
        this.build = build;
        this.basePath = build.getArtifactManager().root().child("LRReport");
    }

    public final Run<?, ?> getBuild() {
        return this.build;
    }

    protected File reportFile() {
        return this.getBuildHtmlReport();
    }

    private File getBuildHtmlReport() {
        return new File(this.basePath.child("index.html").toURI());
    }

    public String getIconFileName() {
        return "/plugin/hp-application-automation-tools-plugin/PerformanceReport/VuGen.png";
    }

    public String getDisplayName() {
        return "LR VuGen Report";
    }

    public String getUrlName() {
        return "LRReport";
    }

    public List<LrScriptHtmlReport> getAllReports() {
        return this.reportMetaDataList;
    }

    public void mergeResult(Run<?, ?> build, String scriptName) {
        if (this.scripts == null) {
            this.reportMetaDataList = new ArrayList<LrScriptHtmlReport>();
            this.scripts = new HashSet();
        }
        this.scripts.add(scriptName);
        String scriptResultPath = build.getArtifactManager().root().child("LRReport").child(scriptName).toString();
        LrScriptHtmlReport lrScriptHtmlReport = new LrScriptHtmlReport(scriptName, "/result.html", scriptResultPath);
        this.reportMetaDataList.add(lrScriptHtmlReport);
    }
}

