/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.results;

import com.microfocus.application.automation.tools.JenkinsUtils;
import com.microfocus.application.automation.tools.common.RuntimeUtils;
import com.microfocus.application.automation.tools.model.EnumDescription;
import com.microfocus.application.automation.tools.model.ResultsPublisherModel;
import com.microfocus.application.automation.tools.results.HtmlBuildReportAction;
import com.microfocus.application.automation.tools.results.PerformanceJobReportAction;
import com.microfocus.application.automation.tools.results.PerformanceReportAction;
import com.microfocus.application.automation.tools.results.ReportMetaData;
import com.microfocus.application.automation.tools.results.RichReportAction;
import com.microfocus.application.automation.tools.results.TransactionSummaryAction;
import com.microfocus.application.automation.tools.results.projectparser.performance.AvgTransactionResponseTime;
import com.microfocus.application.automation.tools.results.projectparser.performance.JobLrScenarioResult;
import com.microfocus.application.automation.tools.results.projectparser.performance.LrJobResults;
import com.microfocus.application.automation.tools.results.projectparser.performance.LrTest;
import com.microfocus.application.automation.tools.results.projectparser.performance.PercentileTransactionWholeRun;
import com.microfocus.application.automation.tools.results.projectparser.performance.TimeRange;
import com.microfocus.application.automation.tools.results.projectparser.performance.TimeRangeResult;
import com.microfocus.application.automation.tools.results.projectparser.performance.WholeRunResult;
import com.microfocus.application.automation.tools.results.projectparser.performance.XmlParserUtil;
import com.microfocus.application.automation.tools.run.PcBuilder;
import com.microfocus.application.automation.tools.run.RunFromAlmBuilder;
import com.microfocus.application.automation.tools.run.RunFromFileBuilder;
import com.microfocus.application.automation.tools.run.SseBuilder;
import com.microfocus.application.automation.tools.uft.utils.UftToolUtils;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Node;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Project;
import hudson.model.Run;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.JUnitResultArchiver;
import hudson.tasks.junit.SuiteResult;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import hudson.tasks.test.TestResultAggregator;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.AgeFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.kohsuke.stapler.DataBoundConstructor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RunResultRecorder
extends Recorder
implements Serializable,
MatrixAggregatable,
SimpleBuildStep {
    public static final String REPORT_NAME_FIELD = "report";
    public static final int SECS_IN_DAY = 86400;
    public static final int SECS_IN_HOUR = 3600;
    public static final int SECS_IN_MINUTE = 60;
    public static final String SLA_ULL_NAME = "FullName";
    public static final String ARCHIVING_TEST_REPORTS_FAILED_DUE_TO_XML_PARSING_ERROR = "Archiving test reports failed due to xml parsing error: ";
    private static final long serialVersionUID = 1L;
    private static final String PERFORMANCE_REPORT_FOLDER = "PerformanceReport";
    private static final String IE_REPORT_FOLDER = "IE";
    private static final String HTML_REPORT_FOLDER = "HTML";
    private static final String LRA_FOLDER = "LRA";
    private static final String INDEX_HTML_NAME = "index.html";
    private static final String REPORT_INDEX_NAME = "report.index";
    private static final String TRANSACTION_SUMMARY_FOLDER = "TransactionSummary";
    private static final String RICH_REPORT_FOLDER = "RichReport";
    private static final String TRANSACTION_REPORT_NAME = "TransactionReport";
    private static final String SLA_ACTUAL_VALUE_LABEL = "ActualValue";
    private static final String SLA_GOAL_VALUE_LABEL = "GoalValue";
    private static final String NO_RICH_REPORTS_ERROR = "Template contains no rich reports.";
    private static final String NO_TRANSACTION_SUMMARY_REPORT_ERROR = "Template contains no transaction summary report.";
    private static final String PARALLEL_RESULT_FILE = "parallelrun_results.html";
    private static final String REPORT_ARCHIVE_SUFFIX = "_Report.zip";
    private static final String RUN_RESULTS_XML = "run_results.xml";
    private static final String RESULT = "Result";
    private final ResultsPublisherModel _resultsPublisherModel;
    private List<FilePath> runReportList;

    @DataBoundConstructor
    public RunResultRecorder(String archiveTestResultsMode) {
        this._resultsPublisherModel = new ResultsPublisherModel(archiveTestResultsMode);
    }

    private static void addTimeRanges(TimeRangeResult transactionTimeRange, Element slaRuleElement) {
        NodeList timeRanges = slaRuleElement.getElementsByTagName("TimeRangeInfo");
        if (timeRanges == null || timeRanges.getLength() == 0) {
            return;
        }
        double generalGoalValue = Double.parseDouble(((Element)timeRanges.item(0)).getAttribute(SLA_GOAL_VALUE_LABEL));
        transactionTimeRange.setGoalValue(generalGoalValue);
        for (int k = 0; k < timeRanges.getLength(); ++k) {
            org.w3c.dom.Node timeRangeNode = timeRanges.item(k);
            Element timeRangeElement = (Element)timeRangeNode;
            double actualValue = Double.parseDouble(timeRangeElement.getAttribute(SLA_ACTUAL_VALUE_LABEL));
            double goalValue = Double.parseDouble(timeRangeElement.getAttribute(SLA_GOAL_VALUE_LABEL));
            int loadValue = Integer.parseInt(timeRangeElement.getAttribute("LoadValue"));
            double startTime = Double.parseDouble(timeRangeElement.getAttribute("StartTime"));
            double endTIme = Double.parseDouble(timeRangeElement.getAttribute("EndTime"));
            transactionTimeRange.incActualValue(actualValue);
            LrTest.SLA_STATUS slaStatus = LrTest.SLA_STATUS.checkStatus(timeRangeElement.getFirstChild().getTextContent());
            TimeRange timeRange = new TimeRange(actualValue, goalValue, slaStatus, loadValue, startTime, endTIme);
            transactionTimeRange.getTimeRanges().add(timeRange);
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public void pipelinePerform(@Nonnull Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener, @Nonnull Map<String, String> builderResultNames) throws IOException, InterruptedException {
        ArrayList<String> mergedResultNames = new ArrayList<String>();
        this.runReportList = new ArrayList<FilePath>();
        ArrayList<String> fileSystemResultNames = new ArrayList<String>();
        fileSystemResultNames.add(builderResultNames.get(RunFromFileBuilder.class.getName()));
        mergedResultNames.addAll(builderResultNames.values());
        if (mergedResultNames.isEmpty()) {
            listener.getLogger().println("RunResultRecorder: no results xml File provided");
            return;
        }
        this.recordRunResults(build, workspace, launcher, listener, mergedResultNames, fileSystemResultNames);
    }

    private void recordRunResults(@Nonnull Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener, List<String> mergedResultNames, List<String> fileSystemResultNames) throws InterruptedException, IOException {
        for (String resultFile : mergedResultNames) {
            JUnitResultArchiver jUnitResultArchiver = new JUnitResultArchiver(resultFile);
            jUnitResultArchiver.setKeepLongStdio(true);
            jUnitResultArchiver.setAllowEmptyResults(true);
            jUnitResultArchiver.setSkipMarkingBuildUnstable(true);
            jUnitResultArchiver.perform(build, workspace, launcher, listener);
        }
        TestResultAction tempAction = (TestResultAction)build.getAction(TestResultAction.class);
        if (tempAction == null || tempAction.getResult() == null) {
            listener.getLogger().println("RunResultRecorder: didn't find any test results to record");
            return;
        }
        TestResult result = tempAction.getResult();
        try {
            this.archiveTestsReport(build, listener, fileSystemResultNames, result, workspace);
        }
        catch (ParserConfigurationException | SAXException e) {
            listener.error(ARCHIVING_TEST_REPORTS_FAILED_DUE_TO_XML_PARSING_ERROR + String.valueOf(e));
        }
        if (this.runReportList != null && !this.runReportList.isEmpty()) {
            LrJobResults jobDataSet = null;
            try {
                jobDataSet = this.buildJobDataset(listener);
            }
            catch (ParserConfigurationException | SAXException e) {
                listener.error(ARCHIVING_TEST_REPORTS_FAILED_DUE_TO_XML_PARSING_ERROR + String.valueOf(e));
            }
            if (jobDataSet != null && !jobDataSet.getLrScenarioResults().isEmpty()) {
                PerformanceJobReportAction performanceJobReportAction = (PerformanceJobReportAction)build.getAction(PerformanceJobReportAction.class);
                if (performanceJobReportAction != null) {
                    performanceJobReportAction.mergeResults(jobDataSet);
                } else {
                    performanceJobReportAction = new PerformanceJobReportAction(build, jobDataSet);
                }
                build.replaceAction((Action)performanceJobReportAction);
            }
        }
        this.publishLrReports(build);
    }

    private void publishLrReports(@Nonnull Run<?, ?> build) throws IOException {
        File htmlIndexFile;
        File richDirectory;
        File htmlIndexFile2;
        File summaryDirectory;
        File htmlIndexFile3;
        File reportDirectory = new File(build.getRootDir(), PERFORMANCE_REPORT_FOLDER);
        if (reportDirectory.exists() && (htmlIndexFile3 = new File(reportDirectory, INDEX_HTML_NAME)).exists()) {
            build.replaceAction((Action)new PerformanceReportAction(build));
        }
        if ((summaryDirectory = new File(build.getRootDir(), TRANSACTION_SUMMARY_FOLDER)).exists() && (htmlIndexFile2 = new File(summaryDirectory, INDEX_HTML_NAME)).exists()) {
            build.replaceAction((Action)new TransactionSummaryAction(build));
        }
        if ((richDirectory = new File(build.getRootDir(), RICH_REPORT_FOLDER)).exists() && (htmlIndexFile = new File(richDirectory, INDEX_HTML_NAME)).exists()) {
            build.replaceAction((Action)new RichReportAction(build));
        }
    }

    private boolean isParallelRunnerReportPath(FilePath reportPath) throws IOException, InterruptedException {
        FilePath parallelRunnerResultsFile = new FilePath(reportPath, PARALLEL_RESULT_FILE);
        return parallelRunnerResultsFile.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void archiveTestsReport(Run<?, ?> build, TaskListener listener, List<String> resultFiles, TestResult testResult, FilePath runWorkspace) throws ParserConfigurationException, SAXException, IOException, InterruptedException {
        VirtualChannel channel;
        if (resultFiles == null) return;
        if (resultFiles.isEmpty()) {
            return;
        }
        ArrayList<String> zipFileNames = new ArrayList<String>();
        ArrayList<FilePath> reportFolders = new ArrayList<FilePath>();
        ArrayList<String> reportNames = new ArrayList<String>();
        listener.getLogger().println("Report archiving mode is set to: " + this._resultsPublisherModel.getArchiveTestResultsMode());
        if (this._resultsPublisherModel.getArchiveTestResultsMode().equals(ResultsPublisherModel.dontArchiveResults.getValue())) {
            return;
        }
        FilePath projectWS = runWorkspace;
        File artifactsDir = new File(build.getRootDir(), "archive");
        artifactsDir.mkdirs();
        PerformanceJobReportAction performanceJobReportAction = (PerformanceJobReportAction)build.getAction(PerformanceJobReportAction.class);
        if (performanceJobReportAction != null) {
            reportNames.addAll(performanceJobReportAction.getLrResultBuildDataset().getLrScenarioResults().keySet());
        }
        EnvVars env = build.getEnvironment(listener);
        Node node = Jenkins.get().getNode((String)env.get((Object)"NODE_NAME"));
        String nodeName = "";
        if (node != null) {
            channel = node.getChannel();
            nodeName = node.getNodeName();
        } else {
            channel = projectWS.getChannel();
            try {
                node = JenkinsUtils.getCurrentNode(runWorkspace);
                nodeName = node != null ? node.getNodeName() : "";
                listener.getLogger().println("Node name = " + nodeName);
            }
            catch (Exception e) {
                listener.getLogger().println("Failed to get the current Node: " + e.getMessage());
            }
        }
        Iterator<String> iterator = resultFiles.iterator();
        block18: while (iterator.hasNext()) {
            HashMap<String, Integer> filePathCount;
            HashMap<String, Integer> fileNameCount;
            NodeList testCasesNodes;
            boolean isHtmlReport;
            String resultsFilePath = iterator.next();
            FilePath resultsFile = projectWS.child(resultsFilePath);
            ArrayList<ReportMetaData> ReportInfoToCollect = new ArrayList<ReportMetaData>();
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(resultsFile.read());
            doc.getDocumentElement().normalize();
            org.w3c.dom.Node testSuiteNode = doc.getElementsByTagName("testsuite").item(0);
            Element testSuiteElement = (Element)testSuiteNode;
            if (!testSuiteElement.hasAttribute("name") || !testSuiteElement.getAttribute("name").endsWith(".lrs")) {
                isHtmlReport = false;
                testCasesNodes = ((Element)testSuiteNode).getElementsByTagName("testcase");
                fileNameCount = new HashMap<String, Integer>();
                filePathCount = new HashMap<String, Integer>();
            } else {
                NodeList testSuiteNodes = doc.getElementsByTagName("testsuite");
                int i = 0;
                while (true) {
                    if (i >= testSuiteNodes.getLength()) continue block18;
                    testSuiteNode = testSuiteNodes.item(i);
                    testSuiteElement = (Element)testSuiteNode;
                    if (testSuiteElement.hasAttribute("name")) {
                        Element testCaseElement;
                        String testFolderPath = testSuiteElement.getAttribute("name");
                        int testPathArr = testFolderPath.lastIndexOf(92);
                        String testName = testFolderPath.substring(testPathArr + 1);
                        reportNames.add(testName);
                        String testStatus = "0".equals(testSuiteElement.getAttribute("failures")) ? "pass" : "fail";
                        org.w3c.dom.Node testCaseNode = testSuiteElement.getElementsByTagName("testcase").item(0);
                        if (testCaseNode == null) {
                            listener.getLogger().println("No report folder was found in results");
                            return;
                        }
                        if (testCaseNode.getNodeType() == 1 && (testCaseElement = (Element)testCaseNode).hasAttribute(REPORT_NAME_FIELD)) {
                            String reportFolderPath = testCaseElement.getAttribute(REPORT_NAME_FIELD);
                            FilePath reportFolder = new FilePath(projectWS.getChannel(), reportFolderPath);
                            reportFolders.add(reportFolder);
                            FilePath testFolder = new FilePath(projectWS.getChannel(), testFolderPath);
                            String zipFileName = this.getUniqueZipFileNameInFolder(zipFileNames, testFolder.getName(), "LR");
                            FilePath archivedFile = new FilePath(new FilePath(artifactsDir), zipFileName);
                            if (this.archiveFolder(reportFolder, testStatus, archivedFile, listener)) {
                                zipFileNames.add(zipFileName);
                            }
                            this.createRichReports(reportFolder, testFolderPath, artifactsDir, reportNames, testResult, listener);
                            this.createHtmlReport(reportFolder, testFolderPath, artifactsDir, reportNames, testResult);
                            this.createTransactionSummary(reportFolder, testFolderPath, artifactsDir, reportNames, testResult);
                            try {
                                FilePath testSla = this.copyRunReport(reportFolder, build.getRootDir(), testFolder.getName());
                                if (testSla == null) {
                                    listener.getLogger().println("no RunReport.xml file was created");
                                } else {
                                    this.runReportList.add(testSla);
                                }
                            }
                            catch (IOException | InterruptedException e) {
                                listener.getLogger().println(e);
                            }
                        }
                    }
                    ++i;
                }
            }
            for (int i = 0; i < testCasesNodes.getLength(); ++i) {
                boolean archiveTestResult;
                Element eElement;
                org.w3c.dom.Node nNode = testCasesNodes.item(i);
                if (nNode.getNodeType() != 1 || !(eElement = (Element)nNode).hasAttribute(REPORT_NAME_FIELD)) continue;
                String reportFolderPath = eElement.getAttribute(REPORT_NAME_FIELD);
                String testFolderPath = eElement.getAttribute("name");
                String testStatus = eElement.getAttribute("status");
                org.w3c.dom.Node nodeSystemInfo = eElement.getElementsByTagName("system-out").item(0);
                String sysInfo = nodeSystemInfo.getFirstChild().getNodeValue();
                String testDateTime = sysInfo.substring(0, 19);
                FilePath testFileFullName = new FilePath(channel, testFolderPath);
                if (!testFileFullName.exists()) break;
                Object testName = testFileFullName.getName();
                int nameCount = 1;
                if (fileNameCount.containsKey(testName)) {
                    nameCount = (Integer)fileNameCount.get(testName) + 1;
                }
                fileNameCount.put((String)testName, nameCount);
                testName = (String)testName + "[" + nameCount + "]";
                String testPath = testFileFullName.getRemote();
                int pathCount = 1;
                if (filePathCount.containsKey(testPath)) {
                    pathCount = (Integer)filePathCount.get(testPath) + 1;
                }
                filePathCount.put(testPath, pathCount);
                String reportIndex = "";
                reportIndex = filePathCount.get(testPath) != null ? Integer.toString((Integer)filePathCount.get(testPath)) : "1";
                FilePath reportFolder = new FilePath(channel, reportFolderPath + reportIndex);
                if (!reportFolder.exists()) {
                    reportFolder = new FilePath(channel, reportFolderPath);
                }
                if (!reportFolder.exists()) {
                    listener.getLogger().println("Report folder does not exist.");
                }
                boolean isParallelRunnerReport = this.isParallelRunnerReportPath(reportFolder);
                reportFolders.add(reportFolder);
                String archiveTestResultMode = this._resultsPublisherModel.getArchiveTestResultsMode();
                FilePath htmlReport = new FilePath(reportFolder, isParallelRunnerReport ? PARALLEL_RESULT_FILE : "run_results.html");
                ReportMetaData reportMetaData = new ReportMetaData();
                if (htmlReport.exists()) {
                    isHtmlReport = true;
                    String htmlReportDir = reportFolder.getRemote();
                    reportMetaData.setFolderPath(htmlReportDir);
                    reportMetaData.setIsHtmlReport(true);
                    reportMetaData.setDateTime(testDateTime);
                    reportMetaData.setStatus(testStatus);
                    reportMetaData.setIsParallelRunnerReport(isParallelRunnerReport);
                    String urlEncodedTestName = URLEncoder.encode((String)testName, StandardCharsets.UTF_8).replaceAll("\\+", "%20");
                    String resourceUrl = "artifact/UFTReport/" + (String)(StringUtils.isBlank((String)nodeName) ? "" : nodeName + "/") + urlEncodedTestName + "/Result";
                    reportMetaData.setResourceURL(resourceUrl);
                    reportMetaData.setDisPlayName((String)testName);
                    reportMetaData.computeStResFolders(new FilePath(reportFolder, RUN_RESULTS_XML), listener);
                    ReportInfoToCollect.add(reportMetaData);
                }
                if (!(archiveTestResult = this.isArchiveTestResult(testStatus, archiveTestResultMode))) continue;
                if (reportFolder.exists()) {
                    FilePath testFolder = new FilePath(channel, testFolderPath);
                    String zipFileName = this.getUniqueZipFileNameInFolder(zipFileNames, (String)(StringUtils.isBlank((String)nodeName) ? "" : nodeName + "_") + testFolder.getName(), "UFT");
                    zipFileNames.add(zipFileName);
                    try (ByteArrayOutputStream outStr = new ByteArrayOutputStream();){
                        reportFolder.zip((OutputStream)outStr);
                        try (ByteArrayInputStream instr = new ByteArrayInputStream(outStr.toByteArray());){
                            FilePath archivedFile = new FilePath(new FilePath(artifactsDir), zipFileName);
                            archivedFile.copyFrom((InputStream)instr);
                        }
                    }
                    String zipFileUrlName = "artifact/" + zipFileName;
                    reportMetaData.setArchiveUrl(zipFileUrlName);
                    continue;
                }
                listener.getLogger().println("No report folder was found in: " + reportFolderPath);
            }
            if (isHtmlReport && !ReportInfoToCollect.isEmpty()) {
                this.collectAndPrepareHtmlReports(build, listener, ReportInfoToCollect, runWorkspace, nodeName);
            }
            if (ReportInfoToCollect.isEmpty()) continue;
            int index = 1;
            String reportName = "report_metadata_" + index + ".xml";
            Class<HtmlBuildReportAction> clazz = HtmlBuildReportAction.class;
            // MONITORENTER : com.microfocus.application.automation.tools.results.HtmlBuildReportAction.class
            while (new File(artifactsDir.getParent(), reportName).exists()) {
                reportName = "report_metadata_" + ++index + ".xml";
            }
            File reportMetaDataXmlFile = new File(artifactsDir.getParent(), reportName);
            String reportMetaDataXml = reportMetaDataXmlFile.getAbsolutePath();
            this.writeReportMetaData2XML(ReportInfoToCollect, reportMetaDataXml, listener);
            try {
                listener.getLogger().println("Adding a report action to the current build.");
                HtmlBuildReportAction reportAction = new HtmlBuildReportAction(build, reportName, index);
                build.addAction((Action)reportAction);
            }
            catch (IOException | ParserConfigurationException | SAXException ex) {
                listener.getLogger().println("a problem adding action: " + String.valueOf(ex));
            }
        }
    }

    private void writeReportMetaData2XML(List<ReportMetaData> htmlReportsInfo, String xmlFile, TaskListener _logger) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            builder = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            _logger.error("Failed creating xml doc report: " + String.valueOf(e));
            return;
        }
        Document doc = builder.newDocument();
        Element root = doc.createElement("reports_data");
        doc.appendChild(root);
        int currentReport = 1;
        for (ReportMetaData htmlReportInfo : htmlReportsInfo) {
            String disPlayName = htmlReportInfo.getDisPlayName();
            String urlName = htmlReportInfo.getUrlName();
            String resourceURL = htmlReportInfo.getResourceURL();
            String dateTime = htmlReportInfo.getDateTime();
            String status = htmlReportInfo.getStatus();
            String isHtmlReport = htmlReportInfo.getIsHtmlReport() != false ? "true" : "false";
            String isParallelRunnerReport = htmlReportInfo.getIsParallelRunnerReport() != false ? "true" : "false";
            String archiveUrl = htmlReportInfo.getArchiveUrl();
            Element elmReport = doc.createElement(REPORT_NAME_FIELD);
            elmReport.setAttribute("disPlayName", disPlayName);
            elmReport.setAttribute("urlName", urlName);
            elmReport.setAttribute("resourceURL", resourceURL);
            elmReport.setAttribute("dateTime", dateTime);
            elmReport.setAttribute("status", status);
            elmReport.setAttribute("isHtmlreport", isHtmlReport);
            elmReport.setAttribute("isParallelRunnerReport", isParallelRunnerReport);
            elmReport.setAttribute("archiveUrl", archiveUrl);
            root.appendChild(elmReport);
            ++currentReport;
        }
        try {
            this.write2XML(doc, xmlFile);
        }
        catch (TransformerException e) {
            _logger.error("Failed transforming xml file: " + String.valueOf(e));
            _logger.getLogger().println("Failed transforming xml file: " + String.valueOf(e));
        }
        catch (FileNotFoundException e) {
            _logger.error("Failed to find " + xmlFile + ": " + String.valueOf(e));
            _logger.getLogger().println("Failed to find " + xmlFile + ": " + String.valueOf(e));
        }
    }

    private void write2XML(Document document, String filename) throws TransformerException, FileNotFoundException {
        document.normalize();
        TransformerFactory tFactory = TransformerFactory.newInstance();
        tFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        Transformer transformer = tFactory.newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        DOMSource source = new DOMSource(document);
        PrintWriter pw = new PrintWriter(new FileOutputStream(filename));
        StreamResult result = new StreamResult(pw);
        transformer.transform(source, result);
    }

    private void renamePath(FilePath src, FilePath dest, TaskListener listener, int idxOfRetry) {
        try {
            if (idxOfRetry > 5) {
                listener.getLogger().println("Failed to rename report path [" + src.getRemote() + "] as [" + dest.getRemote() + "] after 5 retries.");
                return;
            }
            Thread.sleep(1500L);
            src.renameTo(dest);
            if (idxOfRetry > 0) {
                String msg = String.format("Successfully renamed report path as [%s] after %d %s.", dest.getRemote(), idxOfRetry, idxOfRetry == 1 ? "retry" : "retries");
                listener.getLogger().println(msg);
            }
        }
        catch (Exception e) {
            this.renamePath(src, dest, listener, ++idxOfRetry);
        }
    }

    private Boolean collectAndPrepareHtmlReports(Run build, TaskListener listener, List<ReportMetaData> htmlReportsInfo, FilePath runWorkspace, String nodeName) {
        File reportMainDir = new File(new File(build.getRootDir(), "archive"), "UFTReport");
        if (StringUtils.isNotBlank((String)nodeName)) {
            reportMainDir = new File(reportMainDir, nodeName);
        }
        try {
            for (ReportMetaData htmlReportInfo : htmlReportsInfo) {
                if (!htmlReportInfo.getIsHtmlReport().booleanValue()) continue;
                String testName = htmlReportInfo.getDisPlayName();
                File reportDir = new File(reportMainDir, testName);
                String htmlReportDir = htmlReportInfo.getFolderPath();
                try {
                    for (String subdir : htmlReportInfo.getStResFolders()) {
                        File dir = new File(htmlReportDir);
                        String testFolderPath = dir.getPath().substring(0, dir.getPath().lastIndexOf(92));
                        String stResPath = new File(testFolderPath, subdir).getAbsolutePath();
                        if (!UftToolUtils.getFilePath(nodeName, stResPath).exists()) continue;
                        this.archiveAndCopyReportFolder(runWorkspace, reportDir, stResPath);
                    }
                }
                catch (Exception e) {
                    listener.getLogger().println("Path to test folder not found");
                }
                this.archiveAndCopyReportFolder(runWorkspace, reportDir, htmlReportDir);
                String unzippedFileName = FilenameUtils.getName((String)htmlReportDir);
                FilePath rootTarget = new FilePath(reportDir);
                FilePath targetPath = new FilePath(rootTarget, RESULT);
                if (targetPath.exists()) continue;
                FilePath unzippedFolderPath = new FilePath(rootTarget, unzippedFileName);
                this.renamePath(unzippedFolderPath, targetPath, listener, 0);
                String resourceUrl = htmlReportInfo.getResourceURL();
                FilePath source = new FilePath(runWorkspace, htmlReportDir);
                boolean isParallelRunner = this.isParallelRunnerReportPath(source);
                String resFileName = isParallelRunner ? "/parallelrun_results.html" : "/run_results.html";
                String urlName = resourceUrl + resFileName;
                htmlReportInfo.setUrlName(urlName);
            }
        }
        catch (Exception ex) {
            listener.getLogger().println("catch exception in collectAndPrepareHtmlReports: " + String.valueOf(ex));
            listener.getLogger().println(ex.getMessage());
            listener.getLogger().println(ex.getCause());
            listener.getLogger().println(ex.getStackTrace());
        }
        return true;
    }

    private void archiveAndCopyReportFolder(FilePath runWorkspace, File reportDir, String htmlReportDir) throws IOException, InterruptedException {
        FilePath rootTarget = new FilePath(reportDir);
        FilePath source = new FilePath(runWorkspace, htmlReportDir);
        String zipFileName = "UFT_Report_HTML_tmp.zip";
        FilePath archivedFile = new FilePath(rootTarget, zipFileName);
        try (ByteArrayOutputStream outStr = new ByteArrayOutputStream();){
            source.zip((OutputStream)outStr);
            try (ByteArrayInputStream inStr = new ByteArrayInputStream(outStr.toByteArray());){
                archivedFile.copyFrom((InputStream)inStr);
            }
            archivedFile.unzip(rootTarget);
            archivedFile.delete();
        }
    }

    private FilePath copyRunReport(FilePath reportFolder, File buildDir, String scenarioName) throws IOException, InterruptedException {
        FilePath slaReportFilePath = new FilePath(reportFolder, "RunReport.xml");
        if (slaReportFilePath.exists()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            slaReportFilePath.zip((OutputStream)baos);
            File slaDirectory = new File(buildDir, "RunReport");
            if (!slaDirectory.exists()) {
                slaDirectory.mkdir();
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            FilePath slaDirectoryFilePath = new FilePath(slaDirectory);
            FilePath tmpZipFile = new FilePath(slaDirectoryFilePath, "runReport.zip");
            tmpZipFile.copyFrom((InputStream)bais);
            bais.close();
            baos.close();
            tmpZipFile.unzip(slaDirectoryFilePath);
            FilePath slaFile = new FilePath(slaDirectoryFilePath, "RunReport.xml");
            slaFile.getBaseName();
            slaFile.renameTo(new FilePath(slaDirectoryFilePath, scenarioName + ".xml"));
            slaFile = new FilePath(slaDirectoryFilePath, scenarioName + ".xml");
            return slaFile;
        }
        return null;
    }

    private boolean archiveFolder(FilePath reportFolder, String testStatus, FilePath archivedFile, TaskListener listener) throws IOException, InterruptedException {
        String archiveTestResultMode = this._resultsPublisherModel.getArchiveTestResultsMode();
        boolean archiveTestResult = this.isArchiveTestResult(testStatus, archiveTestResultMode);
        if (archiveTestResult) {
            if (reportFolder.exists()) {
                listener.getLogger().println("Zipping report folder: " + String.valueOf(reportFolder));
                ByteArrayOutputStream outstr = new ByteArrayOutputStream();
                reportFolder.zip((OutputStream)outstr);
                ByteArrayInputStream instr = new ByteArrayInputStream(outstr.toByteArray());
                archivedFile.copyFrom((InputStream)instr);
                outstr.close();
                instr.close();
                return true;
            }
            listener.getLogger().println("No report folder was found in: " + String.valueOf(reportFolder));
        }
        return false;
    }

    private boolean isArchiveTestResult(String testStatus, String archiveTestResultMode) {
        if (archiveTestResultMode.equals(ResultsPublisherModel.alwaysArchiveResults.getValue()) || archiveTestResultMode.equals(ResultsPublisherModel.CreateHtmlReportResults.getValue())) {
            return true;
        }
        if (archiveTestResultMode.equals(ResultsPublisherModel.ArchiveFailedTestsResults.getValue())) {
            if ("fail".equals(testStatus)) {
                return true;
            }
            if (archiveTestResultMode.equals(ResultsPublisherModel.dontArchiveResults.getValue())) {
                return false;
            }
        }
        return false;
    }

    private void createHtmlReport(FilePath reportFolder, String testFolderPath, File artifactsDir, List<String> reportNames, TestResult testResult) throws IOException, InterruptedException {
        String archiveTestResultMode = this._resultsPublisherModel.getArchiveTestResultsMode();
        boolean createReport = archiveTestResultMode.equals(ResultsPublisherModel.CreateHtmlReportResults.getValue());
        if (createReport) {
            FilePath srcFilePath;
            File testFolderPathFile = new File(testFolderPath);
            FilePath srcDirectoryFilePath = new FilePath(reportFolder, HTML_REPORT_FOLDER);
            if (srcDirectoryFilePath.exists() && (srcFilePath = new FilePath(srcDirectoryFilePath, IE_REPORT_FOLDER)).exists()) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                srcFilePath.zip((OutputStream)baos);
                File reportDirectory = new File(artifactsDir.getParent(), PERFORMANCE_REPORT_FOLDER);
                if (!reportDirectory.exists()) {
                    reportDirectory.mkdir();
                }
                ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                FilePath reportDirectoryFilePath = new FilePath(reportDirectory);
                FilePath tmpZipFile = new FilePath(reportDirectoryFilePath, "tmp.zip");
                tmpZipFile.copyFrom((InputStream)bais);
                bais.close();
                baos.close();
                tmpZipFile.unzip(reportDirectoryFilePath);
                String newFolderName = FilenameUtils.getName((String)testFolderPathFile.getPath());
                FileUtils.moveDirectory((File)new File(reportDirectory, IE_REPORT_FOLDER), (File)new File(reportDirectory, newFolderName));
                tmpZipFile.delete();
                this.outputReportFiles(reportNames, reportDirectory, testResult, "Performance Report", HTML_REPORT_FOLDER);
            }
        }
    }

    private void createRichReports(FilePath reportFolder, String testFolderPath, File artifactsDir, List<String> reportNames, TestResult testResult, TaskListener listener) {
        try {
            File testFolderPathFile = new File(testFolderPath);
            FilePath htmlReportPath = new FilePath(reportFolder, LRA_FOLDER);
            if (htmlReportPath.exists()) {
                String newFolderName;
                File testDirectory;
                File reportDirectory = new File(artifactsDir.getParent(), RICH_REPORT_FOLDER);
                if (!reportDirectory.exists()) {
                    reportDirectory.mkdir();
                }
                if (!(testDirectory = new File(reportDirectory, newFolderName = FilenameUtils.getName((String)testFolderPathFile.getPath()))).exists()) {
                    testDirectory.mkdir();
                }
                FilePath dstReportPath = new FilePath(testDirectory);
                WildcardFileFilter reportFileFilter = new WildcardFileFilter("*.pdf");
                List reportFiles = htmlReportPath.list((FileFilter)reportFileFilter);
                ArrayList<String> richReportNames = new ArrayList<String>();
                for (FilePath fileToCopy : reportFiles) {
                    FilePath dstFilePath = new FilePath(dstReportPath, fileToCopy.getName());
                    fileToCopy.copyTo(dstFilePath);
                    richReportNames.add(dstFilePath.getName());
                }
                this.outputReportFiles(reportNames, reportDirectory, testResult, "Rich Reports", INDEX_HTML_NAME);
                this.createRichReportHtml(testDirectory, richReportNames);
            }
        }
        catch (IOException | InterruptedException ex) {
            listener.getLogger().println("Exception caught while creating rich reports: " + String.valueOf(ex));
        }
    }

    private void createErrorHtml(File htmlDirectory, String error) throws IOException {
        String htmlFileContents = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><HTML><HEAD><meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\"><TITLE>Rich Report</TITLE></HEAD><BODY>" + error + "</BODY>";
        this.writeToFile(htmlDirectory, htmlFileContents);
    }

    private void createRichReportHtml(File reportDirectory, List<String> richReportNames) throws IOException {
        Object htmlFileContents = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><HTML><HEAD><meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\"><TITLE>Rich Report</TITLE></HEAD><BODY>";
        if (richReportNames.size() == 0) {
            htmlFileContents = (String)htmlFileContents + NO_RICH_REPORTS_ERROR;
        } else {
            for (String richReportName : richReportNames) {
                htmlFileContents = (String)htmlFileContents + "<iframe src=\"./" + richReportName + "\" width=\"100%%\" height=\"800px\" frameBorder=\"0\"></iframe>";
            }
        }
        htmlFileContents = (String)htmlFileContents + "</BODY>";
        File richReportsHtml = new File(reportDirectory, "HTML.html");
        this.writeToFile(richReportsHtml, (String)htmlFileContents);
    }

    private void writeToFile(File file, String contents) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        writer.write(contents);
        writer.flush();
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputReportFiles(List<String> reportNames, File reportDirectory, TestResult testResult, String title, String htmlFileName) throws IOException {
        if (reportNames.isEmpty()) {
            return;
        }
        File htmlIndexFile = new File(reportDirectory, INDEX_HTML_NAME);
        BufferedWriter writer = new BufferedWriter(new FileWriter(htmlIndexFile));
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>%n");
        writer.write("<HTML><HEAD>%n");
        writer.write("<meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\">%n");
        writer.write(String.format("<TITLE>%s</TITLE>%n", title));
        writer.write("</HEAD>%n");
        writer.write("<BODY>%n");
        writer.write("<table style=\"font-size:15px;width:100%;max-width:100%;border-left:1px solid #DDD;border-right:1px solid #DDD;border-bottom:1px solid #DDD;\">%n");
        writer.write("<tr style=\"background-color: #F1F1F1;\"><th style=\"padding:8px;line-height:1.42857;vertical-align:top;border-top:1px solid #DDD;\">Name</th></tr>%n");
        boolean rolling = true;
        for (String report : reportNames) {
            if (rolling) {
                writer.write(String.format("<tr style=\"background-color: #FFF;\"><td style=\"padding:8px;line-height:1.42857;vertical-align:top;border-top:1px solid #DDD;\"><a href=\"./%s/%s\">%s</a></td></tr>%n", report, htmlFileName, report));
                rolling = false;
                continue;
            }
            writer.write(String.format("<tr style=\"background-color: #F1F1F1;\"><td style=\"padding:8px;line-height:1.42857;vertical-align:top;border-top:1px solid #DDD;\"><a href=\"./%s/%s\">%s</a></td></tr>%n", report, htmlFileName, report));
            rolling = true;
        }
        writer.write("</table>%n");
        writer.write("</BODY>%n");
        writer.flush();
        writer.close();
        File indexFile = new File(reportDirectory, REPORT_INDEX_NAME);
        try {
            writer = new BufferedWriter(new FileWriter(indexFile));
            Iterator resultIterator = null;
            if (testResult != null && !testResult.getSuites().isEmpty()) {
                resultIterator = testResult.getSuites().iterator();
            }
            for (String report : reportNames) {
                SuiteResult suitResult = null;
                if (resultIterator != null && resultIterator.hasNext()) {
                    suitResult = (SuiteResult)resultIterator.next();
                }
                if (suitResult == null) {
                    writer.write(report + "\t##\t##\t##%n");
                    continue;
                }
                int iDuration = (int)suitResult.getDuration();
                StringBuilder bld = new StringBuilder();
                String duration = "";
                if (iDuration / 86400 > 0) {
                    bld.append(String.format("%dday ", iDuration / 86400));
                    iDuration %= 86400;
                }
                if (iDuration / 3600 > 0) {
                    bld.append(String.format("%02dhr ", iDuration / 3600));
                    iDuration %= 3600;
                } else if (!duration.isEmpty()) {
                    bld.append("00hr ");
                }
                if (iDuration / 60 > 0) {
                    bld.append(String.format("%02dmin ", iDuration / 60));
                    iDuration %= 60;
                } else if (!duration.isEmpty()) {
                    bld.append("00min ");
                }
                bld.append(String.format("%02dsec", iDuration));
                duration = bld.toString();
                int iPassCount = 0;
                int iFailCount = 0;
                for (CaseResult caseResult : suitResult.getCases()) {
                    iPassCount += caseResult.getPassCount();
                    iFailCount += caseResult.getFailCount();
                }
                writer.write(String.format("%s\t%s\t%d\t%d%n", report, duration, iPassCount, iFailCount));
            }
        }
        finally {
            writer.flush();
            writer.close();
        }
    }

    private void createTransactionSummary(FilePath reportFolder, String testFolderPath, File artifactsDir, List<String> reportNames, TestResult testResult) throws IOException, InterruptedException {
        File testFolderPathFile = new File(testFolderPath);
        String subFolder = HTML_REPORT_FOLDER + File.separator + IE_REPORT_FOLDER + File.separator + HTML_REPORT_FOLDER;
        FilePath htmlReportPath = new FilePath(reportFolder, subFolder);
        if (htmlReportPath.exists()) {
            FilePath pngFilePath;
            String newFolderName;
            File testDirectory;
            File reportDirectory = new File(artifactsDir.getParent(), TRANSACTION_SUMMARY_FOLDER);
            if (!reportDirectory.exists()) {
                reportDirectory.mkdir();
            }
            if (!(testDirectory = new File(reportDirectory, newFolderName = FilenameUtils.getName((String)testFolderPathFile.getPath()))).exists()) {
                testDirectory.mkdir();
            }
            FilePath dstReportPath = new FilePath(testDirectory);
            FilePath transSummaryReport = this.getTransactionSummaryReport(htmlReportPath);
            if (transSummaryReport != null) {
                FilePath dstFilePath = new FilePath(dstReportPath, "TransactionReport.html");
                transSummaryReport.copyTo(dstFilePath);
                FilePath transSummaryReportExcel = this.getTransactionSummaryReportExcel(htmlReportPath, transSummaryReport.getName());
                if (transSummaryReportExcel != null) {
                    dstFilePath = new FilePath(dstReportPath, transSummaryReportExcel.getName());
                    transSummaryReportExcel.copyTo(dstFilePath);
                }
            } else {
                File htmlIndexFile = new File(testDirectory, "TransactionReport.html");
                this.createErrorHtml(htmlIndexFile, NO_TRANSACTION_SUMMARY_REPORT_ERROR);
            }
            FilePath cssFilePath = new FilePath(htmlReportPath, "Properties.css");
            if (cssFilePath.exists()) {
                FilePath dstFilePath = new FilePath(dstReportPath, cssFilePath.getName());
                cssFilePath.copyTo(dstFilePath);
            }
            if ((pngFilePath = new FilePath(htmlReportPath, "tbic_toexcel.png")).exists()) {
                FilePath dstFilePath = new FilePath(dstReportPath, pngFilePath.getName());
                pngFilePath.copyTo(dstFilePath);
            }
            FilePath jsDstReportPath = new FilePath(testDirectory);
            WildcardFileFilter jsReportFileFilter = new WildcardFileFilter("*.js");
            List jsReporFiles = htmlReportPath.list((FileFilter)jsReportFileFilter);
            for (FilePath fileToCopy : jsReporFiles) {
                FilePath dstFilePath = new FilePath(jsDstReportPath, fileToCopy.getName());
                fileToCopy.copyTo(dstFilePath);
            }
            this.outputReportFiles(reportNames, reportDirectory, testResult, "Transaction Summary", "TransactionReport.html");
        }
    }

    private FilePath getTransactionSummaryReport(FilePath htmlReportPath) throws IOException, InterruptedException {
        String[] transactionSummaryNames = new String[]{"Transaction Summary", "\u30c8\u30e9\u30f3\u30b6\u30af\u30b7\u30e7\u30f3 \u30b5\u30de\u30ea", "\ud2b8\ub79c\uc7ad\uc158 \uc694\uc57d", "\u4e8b\u52a1\u6458\u8981", "Transaktions\u00fcbersicht", "Resumen de transacciones", "Riepilogo transazioni", "R\u00e9capitulatif des transactions", "\u0421\u0432\u043e\u0434\u043a\u0430 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0439"};
        WildcardFileFilter reportFileFilter = new WildcardFileFilter("Report*.html");
        List reportFiles = htmlReportPath.list((FileFilter)reportFileFilter);
        for (FilePath fileToCopy : reportFiles) {
            Scanner scanner = new Scanner(fileToCopy.read()).useDelimiter("\\A");
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                for (String transactionSummaryName : transactionSummaryNames) {
                    if (!line.contains(transactionSummaryName)) continue;
                    return fileToCopy;
                }
            }
        }
        return null;
    }

    private FilePath getTransactionSummaryReportExcel(FilePath htmlReportPath, String reportName) throws IOException, InterruptedException {
        WildcardFileFilter reportFileFilter = new WildcardFileFilter(reportName.replace("html", "xls"));
        List reportFiles = htmlReportPath.list((FileFilter)reportFileFilter);
        if (!reportFiles.isEmpty()) {
            return (FilePath)reportFiles.get(0);
        }
        return null;
    }

    private String getUniqueZipFileNameInFolder(ArrayList<String> names, String fileName, String productName) {
        String result = fileName + REPORT_ARCHIVE_SUFFIX;
        int index = 1;
        if (productName.equals("UFT") && names.indexOf(result) == -1) {
            result = fileName + "_" + index + REPORT_ARCHIVE_SUFFIX;
        }
        while (names.indexOf(result) > -1) {
            result = fileName + "_" + ++index + REPORT_ARCHIVE_SUFFIX;
        }
        return result;
    }

    private LrJobResults buildJobDataset(TaskListener listener) throws ParserConfigurationException, SAXException, IOException, InterruptedException {
        listener.getLogger().println("Parsing test run dataset for performance report");
        LrJobResults jobResults = new LrJobResults();
        for (FilePath reportFilePath : this.runReportList) {
            JobLrScenarioResult jobLrScenarioResult = this.parseScenarioResults(reportFilePath);
            jobResults.addScenario(jobLrScenarioResult);
        }
        return jobResults;
    }

    private JobLrScenarioResult parseScenarioResults(FilePath slaFilePath) throws ParserConfigurationException, SAXException, IOException, InterruptedException {
        JobLrScenarioResult jobLrScenarioResult = new JobLrScenarioResult(slaFilePath.getBaseName());
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(slaFilePath.read());
        this.processSLA(jobLrScenarioResult, doc);
        this.processLrScenarioStats(jobLrScenarioResult, doc);
        return jobLrScenarioResult;
    }

    private void processLrScenarioStats(JobLrScenarioResult jobLrScenarioResult, Document doc) {
        NodeList rootNodes = doc.getChildNodes();
        org.w3c.dom.Node root = XmlParserUtil.getNode("Runs", rootNodes);
        Element generalNode = (Element)XmlParserUtil.getNode("General", root.getChildNodes());
        NodeList generalNodeChildren = generalNode.getChildNodes();
        this.extractVUserScenarioReult(jobLrScenarioResult, generalNodeChildren);
        this.extractTransactionScenarioResult(jobLrScenarioResult, generalNodeChildren);
        this.extractConnectionsScenarioResult(jobLrScenarioResult, generalNodeChildren);
        this.extractDuration(jobLrScenarioResult, generalNodeChildren);
    }

    private void extractDuration(JobLrScenarioResult jobLrScenarioResult, NodeList generalNodeChildren) {
        org.w3c.dom.Node ScenrioDurationNode = XmlParserUtil.getNode("Time", generalNodeChildren);
        String scenarioDurationAttr = XmlParserUtil.getNodeAttr("Duration", ScenrioDurationNode);
        jobLrScenarioResult.setScenarioDuration(Long.valueOf(scenarioDurationAttr));
    }

    private void extractConnectionsScenarioResult(JobLrScenarioResult jobLrScenarioResult, NodeList generalNodeChildren) {
        org.w3c.dom.Node connections = XmlParserUtil.getNode("Connections", generalNodeChildren);
        jobLrScenarioResult.setConnectionMax(Integer.valueOf(XmlParserUtil.getNodeAttr("MaxCount", connections)));
    }

    private void extractTransactionScenarioResult(JobLrScenarioResult jobLrScenarioResult, NodeList generalNodeChildren) {
        org.w3c.dom.Node transactions = XmlParserUtil.getNode("Transactions", generalNodeChildren);
        int atrrCount = transactions.getAttributes().getLength();
        for (int atrrIndx = 0; atrrIndx < atrrCount; ++atrrIndx) {
            org.w3c.dom.Node vUserAttr = transactions.getAttributes().item(atrrIndx);
            jobLrScenarioResult.transactionSum.put(vUserAttr.getNodeName(), Integer.valueOf(vUserAttr.getNodeValue()));
        }
        NodeList transactionNodes = transactions.getChildNodes();
        int transactionNodesCount = transactionNodes.getLength();
        for (int transIdx = 0; transIdx < transactionNodesCount; ++transIdx) {
            if (transactionNodes.item(transIdx).getNodeType() != 1) continue;
            Element transaction = (Element)transactionNodes.item(transIdx);
            TreeMap<String, Integer> transactionData = new TreeMap<String, Integer>();
            transactionData.put("Pass", Integer.valueOf(transaction.getAttribute("Pass")));
            transactionData.put("Fail", Integer.valueOf(transaction.getAttribute("Fail")));
            transactionData.put("Stop", Integer.valueOf(transaction.getAttribute("Stop")));
            jobLrScenarioResult.transactionData.put(transaction.getAttribute("Name"), transactionData);
        }
    }

    private void extractVUserScenarioReult(JobLrScenarioResult jobLrScenarioResult, NodeList generalNodeChildren) {
        org.w3c.dom.Node vUser = XmlParserUtil.getNode("VUsers", generalNodeChildren);
        int atrrCount = vUser.getAttributes().getLength();
        for (int atrrIndx = 0; atrrIndx < atrrCount; ++atrrIndx) {
            org.w3c.dom.Node vUserAttr = vUser.getAttributes().item(atrrIndx);
            jobLrScenarioResult.vUserSum.put(vUserAttr.getNodeName(), Integer.valueOf(vUserAttr.getNodeValue()));
        }
    }

    private void processSLA(JobLrScenarioResult jobLrScenarioResult, Document doc) {
        NodeList rootNodes = doc.getChildNodes();
        org.w3c.dom.Node root = XmlParserUtil.getNode("Runs", rootNodes);
        Element slaRoot = (Element)XmlParserUtil.getNode("SLA", root.getChildNodes());
        NodeList slaRuleResults = slaRoot.getChildNodes();
        for (int j = 0; j < slaRuleResults.getLength(); ++j) {
            org.w3c.dom.Node slaRuleNode = slaRuleResults.item(j);
            if (slaRuleNode.getNodeType() != 1) continue;
            Element slaRuleElement = (Element)slaRuleNode;
            LrTest.SLA_GOAL slaGoal = LrTest.SLA_GOAL.checkGoal(slaRuleElement.getAttribute("Measurement"));
            this.processSlaRule(jobLrScenarioResult, slaRuleElement, slaGoal);
        }
    }

    private void processSlaRule(JobLrScenarioResult jobLrScenarioResult, Element slaRuleElement, LrTest.SLA_GOAL slaGoal) {
        switch (slaGoal) {
            case AverageThroughput: {
                WholeRunResult averageThroughput = new WholeRunResult();
                averageThroughput.setSlaGoal(LrTest.SLA_GOAL.AverageThroughput);
                averageThroughput.setActualValue(Double.valueOf(slaRuleElement.getAttribute(SLA_ACTUAL_VALUE_LABEL)));
                averageThroughput.setGoalValue(Double.valueOf(slaRuleElement.getAttribute(SLA_GOAL_VALUE_LABEL)));
                averageThroughput.setFullName(slaRuleElement.getAttribute(SLA_ULL_NAME));
                averageThroughput.setStatus(LrTest.SLA_STATUS.checkStatus(slaRuleElement.getLastChild().getTextContent().trim()));
                jobLrScenarioResult.scenarioSlaResults.add(averageThroughput);
                break;
            }
            case TotalThroughput: {
                WholeRunResult totalThroughput = new WholeRunResult();
                totalThroughput.setSlaGoal(LrTest.SLA_GOAL.TotalThroughput);
                totalThroughput.setActualValue(Double.valueOf(slaRuleElement.getAttribute(SLA_ACTUAL_VALUE_LABEL)));
                totalThroughput.setGoalValue(Double.valueOf(slaRuleElement.getAttribute(SLA_GOAL_VALUE_LABEL)));
                totalThroughput.setFullName(slaRuleElement.getAttribute(SLA_ULL_NAME));
                totalThroughput.setStatus(LrTest.SLA_STATUS.checkStatus(slaRuleElement.getLastChild().getTextContent().trim()));
                jobLrScenarioResult.scenarioSlaResults.add(totalThroughput);
                break;
            }
            case AverageHitsPerSecond: {
                WholeRunResult averageHitsPerSecond = new WholeRunResult();
                averageHitsPerSecond.setSlaGoal(LrTest.SLA_GOAL.AverageHitsPerSecond);
                averageHitsPerSecond.setActualValue(Double.valueOf(slaRuleElement.getAttribute(SLA_ACTUAL_VALUE_LABEL)));
                averageHitsPerSecond.setGoalValue(Double.valueOf(slaRuleElement.getAttribute(SLA_GOAL_VALUE_LABEL)));
                averageHitsPerSecond.setFullName(slaRuleElement.getAttribute(SLA_ULL_NAME));
                averageHitsPerSecond.setStatus(LrTest.SLA_STATUS.checkStatus(slaRuleElement.getLastChild().getTextContent().trim()));
                jobLrScenarioResult.scenarioSlaResults.add(averageHitsPerSecond);
                break;
            }
            case TotalHits: {
                WholeRunResult totalHits = new WholeRunResult();
                totalHits.setSlaGoal(LrTest.SLA_GOAL.TotalHits);
                totalHits.setActualValue(Double.valueOf(slaRuleElement.getAttribute(SLA_ACTUAL_VALUE_LABEL)));
                totalHits.setGoalValue(Double.valueOf(slaRuleElement.getAttribute(SLA_GOAL_VALUE_LABEL)));
                totalHits.setFullName(slaRuleElement.getAttribute(SLA_ULL_NAME));
                totalHits.setStatus(LrTest.SLA_STATUS.checkStatus(slaRuleElement.getLastChild().getTextContent().trim()));
                jobLrScenarioResult.scenarioSlaResults.add(totalHits);
                break;
            }
            case ErrorsPerSecond: {
                AvgTransactionResponseTime errPerSec = new AvgTransactionResponseTime();
                errPerSec.setSlaGoal(LrTest.SLA_GOAL.ErrorsPerSecond);
                errPerSec.setFullName(slaRuleElement.getAttribute(SLA_ULL_NAME));
                errPerSec.setLoadThrashold(slaRuleElement.getAttribute("SLALoadThresholdValue"));
                errPerSec.setStatus(LrTest.SLA_STATUS.checkStatus(slaRuleElement.getLastChild().getTextContent().trim()));
                RunResultRecorder.addTimeRanges(errPerSec, slaRuleElement);
                jobLrScenarioResult.scenarioSlaResults.add(errPerSec);
                break;
            }
            case PercentileTRT: {
                PercentileTransactionWholeRun percentileTransactionWholeRun = new PercentileTransactionWholeRun();
                percentileTransactionWholeRun.setSlaGoal(LrTest.SLA_GOAL.PercentileTRT);
                percentileTransactionWholeRun.setName(slaRuleElement.getAttribute("TransactionName"));
                percentileTransactionWholeRun.setActualValue(Double.valueOf(slaRuleElement.getAttribute(SLA_ACTUAL_VALUE_LABEL)));
                percentileTransactionWholeRun.setGoalValue(Double.valueOf(slaRuleElement.getAttribute(SLA_GOAL_VALUE_LABEL)));
                percentileTransactionWholeRun.setFullName(slaRuleElement.getAttribute(SLA_ULL_NAME));
                percentileTransactionWholeRun.setPrecentage(Double.valueOf(slaRuleElement.getAttribute("Percentile")));
                percentileTransactionWholeRun.setStatus(LrTest.SLA_STATUS.checkStatus(slaRuleElement.getLastChild().getTextContent().trim()));
                jobLrScenarioResult.scenarioSlaResults.add(percentileTransactionWholeRun);
                break;
            }
            case AverageTRT: {
                AvgTransactionResponseTime transactionTimeRange = new AvgTransactionResponseTime();
                transactionTimeRange.setSlaGoal(LrTest.SLA_GOAL.AverageTRT);
                transactionTimeRange.setName(slaRuleElement.getAttribute("TransactionName"));
                transactionTimeRange.setFullName(slaRuleElement.getAttribute(SLA_ULL_NAME));
                transactionTimeRange.setLoadThrashold(slaRuleElement.getAttribute("SLALoadThresholdValue"));
                transactionTimeRange.setStatus(LrTest.SLA_STATUS.checkStatus(slaRuleElement.getLastChild().getTextContent().trim()));
                RunResultRecorder.addTimeRanges(transactionTimeRange, slaRuleElement);
                jobLrScenarioResult.scenarioSlaResults.add(transactionTimeRange);
                break;
            }
        }
    }

    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        this.runReportList = new ArrayList<FilePath>();
        HashSet mergedResultNames = new HashSet();
        ArrayList<String> almResultNames = new ArrayList<String>();
        ArrayList<String> fileSystemResultNames = new ArrayList<String>();
        ArrayList<String> almSSEResultNames = new ArrayList<String>();
        ArrayList<String> pcResultNames = new ArrayList<String>();
        if (build instanceof WorkflowRun) {
            List paramActions = build.getActions(ParametersAction.class);
            for (ParametersAction paramAction : paramActions) {
                String buildStepName;
                ParameterValue buildStepNameParam;
                if (paramAction == null || paramAction.getAllParameters() == null || (buildStepNameParam = paramAction.getParameter("buildStepName")) == null) continue;
                switch (buildStepName = ((StringParameterValue)buildStepNameParam).getValue()) {
                    case "RunFromAlmBuilder": {
                        ParameterValue resFileParam = paramAction.getParameter("resultsFilename");
                        if (resFileParam == null) break;
                        almResultNames.add(((StringParameterValue)resFileParam).getValue());
                        break;
                    }
                    case "RunFromAlmLabManagementBuilder": {
                        ParameterValue resFileParam = paramAction.getParameter("resultsFilename");
                        if (resFileParam == null) break;
                        almSSEResultNames.add(((StringParameterValue)resFileParam).getValue());
                        break;
                    }
                    case "PcBuilder": {
                        ParameterValue resFileParam = paramAction.getParameter("resultsFilename");
                        if (resFileParam == null) break;
                        pcResultNames.add(((StringParameterValue)resFileParam).getValue());
                        break;
                    }
                }
            }
        } else {
            Project project = (Project)RuntimeUtils.cast(build.getParent());
            List builders = project.getBuilders();
            for (Builder builder : builders) {
                String resultsFileName;
                if (builder instanceof RunFromAlmBuilder) {
                    almResultNames.add(((RunFromAlmBuilder)builder).getRunResultsFileName());
                    continue;
                }
                if (builder instanceof SseBuilder) {
                    resultsFileName = ((SseBuilder)builder).getRunResultsFileName();
                    if (resultsFileName == null) continue;
                    almSSEResultNames.add(resultsFileName);
                    continue;
                }
                if (!(builder instanceof PcBuilder) || (resultsFileName = ((PcBuilder)builder).getRunResultsFileName()) == null) continue;
                pcResultNames.add(resultsFileName);
            }
        }
        WildcardFileFilter byBuildNumberFileFilter = new WildcardFileFilter(Arrays.asList(String.format("*_%d.xml", build.getNumber()), String.format("*%d", build.getNumber()), "*-Report.xml"));
        AgeFileFilter byBuildStartedFileFilter = new AgeFileFilter(build.getStartTimeInMillis(), false);
        IOFileFilter fileFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{byBuildNumberFileFilter, byBuildStartedFileFilter});
        this.listFilesWithFilterRecursive(workspace, "", fileFilter, fileSystemResultNames);
        mergedResultNames.addAll(almResultNames);
        mergedResultNames.addAll(fileSystemResultNames);
        mergedResultNames.addAll(almSSEResultNames);
        mergedResultNames.addAll(pcResultNames);
        if (mergedResultNames.isEmpty()) {
            listener.getLogger().println("RunResultRecorder: no results xml File provided");
            return;
        }
        this.recordRunResults(build, workspace, launcher, listener, new ArrayList<String>(mergedResultNames), fileSystemResultNames);
    }

    private void listFilesWithFilterRecursive(FilePath path, String basePath, IOFileFilter fileFilter, List<String> fileSystemResultNames) throws IOException, InterruptedException {
        List fileSystemResultsPath = path.list((FileFilter)fileFilter);
        for (FilePath fileSystemResultPath : fileSystemResultsPath) {
            if (!fileSystemResultPath.isDirectory()) {
                fileSystemResultNames.add(basePath + fileSystemResultPath.getName());
                continue;
            }
            this.listFilesWithFilterRecursive(fileSystemResultPath, fileSystemResultPath.getName() + File.separator, fileFilter, fileSystemResultNames);
        }
    }

    public MatrixAggregator createAggregator(MatrixBuild build, Launcher launcher, BuildListener listener) {
        return new TestResultAggregator(build, launcher, listener);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public ResultsPublisherModel getResultsPublisherModel() {
        return this._resultsPublisherModel;
    }

    public String getArchiveTestResultsMode() {
        return this._resultsPublisherModel.getArchiveTestResultsMode();
    }

    @Symbol(value={"publishMicroFocusTestResults"})
    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Publish OpenText test results";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public List<EnumDescription> getReportArchiveModes() {
            return ResultsPublisherModel.archiveModes;
        }
    }

    public class RRVFileFilter
    implements FileFilter {
        private final String[] excludedFilenames = new String[]{"run_results.xml", "run_results.html", "diffcompare", "Resources"};
        private final String[] excludedDirnames = new String[]{"diffcompare", "Resources", "CheckPoints", "Snapshots"};

        @Override
        public boolean accept(File file) {
            boolean bRet = true;
            for (String filename : this.excludedFilenames) {
                if (!file.getName().equals(filename)) continue;
                bRet = false;
                break;
            }
            if (bRet) {
                for (String parentname : this.excludedDirnames) {
                    if (!file.getParent().contains(parentname)) continue;
                    bRet = false;
                    break;
                }
            }
            return bRet;
        }
    }
}

