/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.results;

import com.microfocus.application.automation.tools.results.DetailReport;
import hudson.FilePath;
import hudson.model.Action;
import hudson.model.DirectoryBrowserSupport;
import hudson.model.ModelObject;
import hudson.model.Run;
import hudson.tasks.test.TestResultProjectAction;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jenkins.tasks.SimpleBuildStep;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class PerformanceReportAction
implements Action,
SimpleBuildStep.LastBuildAction {
    private static final String PERFORMANCE_REPORT_FOLDER = "PerformanceReport";
    private static final String REPORT_INDEX = "report.index";
    private Map<String, DetailReport> detailReportMap = new LinkedHashMap<String, DetailReport>();
    private final List<TestResultProjectAction> projectActionList;
    private final Run<?, ?> build;

    public PerformanceReportAction(Run<?, ?> build) throws IOException {
        File indexFile;
        this.build = build;
        File reportFolder = new File(build.getRootDir(), PERFORMANCE_REPORT_FOLDER);
        if (reportFolder.exists() && (indexFile = new File(reportFolder, REPORT_INDEX)).exists()) {
            File file = new File(build.getRootDir(), PERFORMANCE_REPORT_FOLDER);
            DirectoryBrowserSupport dbs = new DirectoryBrowserSupport((ModelObject)this, new FilePath(file), "report", "graph.gif", false);
            this.createPreformanceIndexFile(build, indexFile, dbs);
        }
        this.projectActionList = new ArrayList<TestResultProjectAction>();
    }

    private void createPreformanceIndexFile(Run<?, ?> build, File indexFile, DirectoryBrowserSupport dbs) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(indexFile));
        boolean rolling = true;
        while ((line = br.readLine()) != null) {
            String[] values = line.split("\t");
            if (values.length < 1) continue;
            DetailReport report = new DetailReport(build, values[0], dbs);
            if (rolling) {
                report.setColor("#FFF");
                rolling = false;
            } else {
                report.setColor("#F1F1F1");
                rolling = true;
            }
            if (values.length >= 2) {
                report.setDuration(values[1]);
            } else {
                report.setDuration("##");
            }
            if (values.length >= 3) {
                report.setPass(values[2]);
            } else {
                report.setPass("##");
            }
            if (values.length >= 4) {
                report.setFail(values[3]);
            } else {
                report.setFail("##");
            }
            this.detailReportMap.put(values[0], report);
        }
        br.close();
    }

    public String getIconFileName() {
        return "/plugin/hp-application-automation-tools-plugin/PerformanceReport/LoadRunner.png";
    }

    public String getDisplayName() {
        return "Performance Report";
    }

    public String getUrlName() {
        return PERFORMANCE_REPORT_FOLDER;
    }

    public Run<?, ?> getBuild() {
        return this.build;
    }

    public Map<String, DetailReport> getDetailReportMap() {
        return this.detailReportMap;
    }

    public Object getDynamic(String name, StaplerRequest req, StaplerResponse rsp) {
        if (this.detailReportMap.containsKey(name)) {
            return this.detailReportMap.get(name);
        }
        return null;
    }

    public Collection<? extends Action> getProjectActions() {
        return Collections.emptySet();
    }
}

