/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.results;

import com.microfocus.application.automation.tools.results.ReportMetaData;
import hudson.model.Action;
import hudson.model.Run;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class HtmlBuildReportAction
implements Action {
    private Run build;
    private List<ReportMetaData> reportMetaDataList;
    private Integer index;

    public HtmlBuildReportAction(Run<?, ?> build, String reportName, Integer index) throws IOException, SAXException, ParserConfigurationException {
        this.build = build;
        File reportMetaData_XML = new File(build.getRootDir(), reportName);
        if (reportMetaData_XML.exists()) {
            this.reportMetaDataList = this.readReportFromXMLFile(reportMetaData_XML.getAbsolutePath());
        }
        this.index = index;
    }

    public final Run<?, ?> getBuild() {
        return this.build;
    }

    protected File reportFile() {
        return this.getBuildHtmlReport(this.build);
    }

    private File getBuildHtmlReport(Run run) {
        return new File(new File(new File(run.getRootDir(), "archive"), "UFTReport"), "index.html");
    }

    public String getDisplayName() {
        return "Functional Testing Report";
    }

    public String getUrlName() {
        return "uft-report" + (String)(this.index != null ? "-" + this.index : "");
    }

    public String getIconFileName() {
        return "/plugin/hp-application-automation-tools-plugin/icons/24x24/uft_report.png";
    }

    public List<ReportMetaData> getAllReports() {
        return this.reportMetaDataList;
    }

    public List<ReportMetaData> getReportMetaDataList() {
        return this.reportMetaDataList;
    }

    private List<ReportMetaData> readReportFromXMLFile(String filename) throws ParserConfigurationException, IOException, SAXException {
        ArrayList<ReportMetaData> listReport = new ArrayList<ReportMetaData>();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(filename);
        Element root = doc.getDocumentElement();
        NodeList reportList = root.getElementsByTagName("report");
        for (int i = 0; i < reportList.getLength(); ++i) {
            ReportMetaData reportmetadata = new ReportMetaData();
            Node nNode = reportList.item(i);
            if (nNode.getNodeType() != 1) continue;
            Element report = (Element)nNode;
            String disPlayName = report.getAttribute("disPlayName");
            String urlName = report.getAttribute("urlName");
            String resourceURL = report.getAttribute("resourceURL");
            String dateTime = report.getAttribute("dateTime");
            String status = report.getAttribute("status");
            String isHtmlreport = report.getAttribute("isHtmlreport");
            String isParallelRunnerReport = report.getAttribute("isParallelRunnerReport");
            String archiveUrl = report.getAttribute("archiveUrl");
            reportmetadata.setDisPlayName(disPlayName);
            reportmetadata.setUrlName(urlName);
            reportmetadata.setResourceURL(resourceURL);
            reportmetadata.setDateTime(dateTime);
            reportmetadata.setStatus(status);
            reportmetadata.setIsHtmlReport("true".equals(isHtmlreport));
            reportmetadata.setIsParallelRunnerReport("true".equals(isParallelRunnerReport));
            reportmetadata.setArchiveUrl(archiveUrl);
            listReport.add(reportmetadata);
        }
        return listReport;
    }
}

