/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.pipelineSteps;

import com.microfocus.application.automation.tools.model.SvServiceSelectionModel;
import com.microfocus.application.automation.tools.pipelineSteps.SvExecution;
import com.microfocus.application.automation.tools.run.SvExportBuilder;
import com.microfocus.application.automation.tools.sv.pipeline.AbstractSvStep;
import com.microfocus.application.automation.tools.sv.pipeline.AbstractSvStepDescriptor;
import hudson.Extension;
import hudson.util.FormValidation;
import jenkins.tasks.SimpleBuildStep;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class SvExportStep
extends AbstractSvStep {
    private final String targetDirectory;
    private final boolean cleanTargetDirectory;
    private final SvServiceSelectionModel serviceSelection;
    private final boolean switchToStandByFirst;
    private final boolean archive;

    @DataBoundConstructor
    public SvExportStep(String serverName, boolean force, String targetDirectory, boolean cleanTargetDirectory, SvServiceSelectionModel serviceSelection, boolean switchToStandByFirst, boolean archive) {
        super(serverName, force);
        this.targetDirectory = targetDirectory;
        this.cleanTargetDirectory = cleanTargetDirectory;
        this.serviceSelection = serviceSelection;
        this.switchToStandByFirst = switchToStandByFirst;
        this.archive = archive;
    }

    public String getTargetDirectory() {
        return this.targetDirectory;
    }

    public boolean isCleanTargetDirectory() {
        return this.cleanTargetDirectory;
    }

    public SvServiceSelectionModel getServiceSelection() {
        return this.serviceSelection;
    }

    public boolean isSwitchToStandByFirst() {
        return this.switchToStandByFirst;
    }

    public boolean isArchive() {
        return this.archive;
    }

    @Override
    public SimpleBuildStep getBuilder() {
        return new SvExportBuilder(this.serverName, this.force, this.targetDirectory, this.cleanTargetDirectory, this.serviceSelection, this.switchToStandByFirst, this.archive);
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractSvStepDescriptor<SvExportBuilder.DescriptorImpl> {
        public DescriptorImpl() {
            super(SvExecution.class, "svExportStep", new SvExportBuilder.DescriptorImpl());
        }

        public FormValidation doCheckTargetDirectory(@QueryParameter String targetDirectory) {
            return ((SvExportBuilder.DescriptorImpl)this.builderDescriptor).doCheckTargetDirectory(targetDirectory);
        }
    }
}

