/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.pipelineSteps;

import com.microfocus.application.automation.tools.pipelineSteps.SvExecution;
import com.microfocus.application.automation.tools.run.SvDeployBuilder;
import com.microfocus.application.automation.tools.sv.pipeline.AbstractSvStep;
import com.microfocus.application.automation.tools.sv.pipeline.AbstractSvStepDescriptor;
import hudson.Extension;
import hudson.util.FormValidation;
import jenkins.tasks.SimpleBuildStep;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class SvDeployStep
extends AbstractSvStep {
    private final String service;
    private final String projectPath;
    private final String projectPassword;
    private final boolean firstAgentFallback;

    @DataBoundConstructor
    public SvDeployStep(String serverName, boolean force, String service, String projectPath, String projectPassword, boolean firstAgentFallback) {
        super(serverName, force);
        this.service = service;
        this.projectPath = projectPath;
        this.projectPassword = projectPassword;
        this.firstAgentFallback = firstAgentFallback;
    }

    public String getService() {
        return this.service;
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public String getProjectPassword() {
        return this.projectPassword;
    }

    public boolean isFirstAgentFallback() {
        return this.firstAgentFallback;
    }

    @Override
    public SimpleBuildStep getBuilder() {
        return new SvDeployBuilder(this.serverName, this.force, this.service, this.projectPath, this.projectPassword, this.firstAgentFallback);
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractSvStepDescriptor<SvDeployBuilder.DescriptorImpl> {
        public DescriptorImpl() {
            super(SvExecution.class, "svDeployStep", new SvDeployBuilder.DescriptorImpl());
        }

        public FormValidation doCheckProjectPath(@QueryParameter String projectPath) {
            return ((SvDeployBuilder.DescriptorImpl)this.builderDescriptor).doCheckProjectPath(projectPath);
        }

        public FormValidation doCheckService(@QueryParameter String service) {
            return ((SvDeployBuilder.DescriptorImpl)this.builderDescriptor).doCheckService(service);
        }
    }
}

