/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.tests.xml;

import com.ctc.wstx.stax.WstxInputFactory;
import hudson.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.XMLEvent;

public abstract class AbstractXmlIterator<E> {
    private InputStream is;
    protected XMLEventReader reader;
    private LinkedList<E> queue;
    private boolean closed;

    public AbstractXmlIterator(InputStream is) throws XMLStreamException {
        this.is = is;
        this.reader = AbstractXmlIterator.createXmlInputFactory().createXMLEventReader(is);
        this.queue = new LinkedList();
    }

    public XMLEvent peek() throws XMLStreamException {
        return this.reader.peek();
    }

    public boolean hasNext() throws XMLStreamException, IOException, InterruptedException {
        while (this.queue.isEmpty() && !this.closed) {
            if (this.reader.hasNext()) {
                this.onEvent(this.reader.nextEvent());
                continue;
            }
            try {
                this.reader.close();
            }
            catch (XMLStreamException xMLStreamException) {
                // empty catch block
            }
            IOUtils.closeQuietly((InputStream)this.is);
            this.closed = true;
        }
        return !this.queue.isEmpty();
    }

    public E next() throws XMLStreamException, IOException, InterruptedException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.queue.removeFirst();
    }

    protected abstract void onEvent(XMLEvent var1) throws XMLStreamException, IOException, InterruptedException;

    protected void addItem(E item) {
        this.queue.add(item);
    }

    protected String readNextValue() throws XMLStreamException {
        XMLEvent nextEvent = this.reader.nextEvent();
        if (nextEvent instanceof EndElement) {
            return "";
        }
        return ((Characters)nextEvent).getData();
    }

    protected String peekNextValue() throws XMLStreamException {
        XMLEvent event = this.reader.peek();
        if (event instanceof EndElement) {
            return "";
        }
        return ((Characters)event).getData();
    }

    private static XMLInputFactory createXmlInputFactory() {
        WstxInputFactory xmlFactory = new WstxInputFactory();
        xmlFactory.setProperty("javax.xml.stream.supportDTD", false);
        xmlFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        return xmlFactory;
    }
}

