/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.tests.junit;

import com.hp.octane.integrations.testresults.XmlWritableTestResult;
import com.hp.octane.integrations.uft.ufttestresults.schema.UftResultIterationData;
import com.hp.octane.integrations.uft.ufttestresults.schema.UftResultStepData;
import com.hp.octane.integrations.uft.ufttestresults.schema.UftResultStepParameter;
import com.hp.octane.integrations.utils.SdkStringUtils;
import com.microfocus.application.automation.tools.octane.configuration.SDKBasedLoggerProvider;
import com.microfocus.application.automation.tools.octane.tests.HPRunnerType;
import com.microfocus.application.automation.tools.octane.tests.junit.TestError;
import com.microfocus.application.automation.tools.octane.tests.junit.TestResultStatus;
import java.io.Serializable;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Logger;

public final class JUnitTestResult
implements Serializable,
XmlWritableTestResult {
    private static Logger logger = SDKBasedLoggerProvider.getLogger(JUnitTestResult.class);
    private static final int DEFAULT_STRING_SIZE = 255;
    private final String moduleName;
    private final String packageName;
    private final String className;
    private final String testName;
    private final String description;
    private TestResultStatus result;
    private long duration;
    private final long started;
    private TestError testError;
    private final String externalReportUrl;
    private final HPRunnerType runnerType;
    private final String externalRunId;
    private final List<UftResultIterationData> uftResultData;
    private final boolean octaneSupportsSteps;

    public JUnitTestResult(String moduleName, String packageName, String className, String testName, TestResultStatus result, long duration, long started, TestError testError, String externalReportUrl, String description, HPRunnerType runnerType, String externalRunId, List<UftResultIterationData> uftResultData, boolean octaneSupportsSteps) {
        this.moduleName = this.restrictSize(moduleName, 255);
        this.packageName = this.restrictSize(packageName, 255);
        this.className = this.restrictSize(className, 255);
        this.testName = StringUtils.isEmpty((String)testName) ? "[noName]" : this.restrictSize(testName, 255);
        this.result = result;
        this.duration = duration;
        this.started = started;
        this.testError = testError;
        this.externalReportUrl = externalReportUrl;
        this.description = description;
        this.runnerType = runnerType;
        this.externalRunId = externalRunId;
        this.uftResultData = uftResultData;
        this.octaneSupportsSteps = octaneSupportsSteps;
    }

    private String restrictSize(String value, int size) {
        String result = value;
        if (value != null && value.length() > size) {
            result = value.substring(0, size);
        }
        return result;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getTestName() {
        return this.testName;
    }

    public void setResult(TestResultStatus result) {
        this.result = result;
    }

    public TestResultStatus getResult() {
        return this.result;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getStarted() {
        return this.started;
    }

    public void setTestError(TestError testError) {
        this.testError = testError;
    }

    public TestError getTestError() {
        return this.testError;
    }

    public String getExternalReportUrl() {
        return this.externalReportUrl;
    }

    public List<UftResultIterationData> getUftResultData() {
        return this.uftResultData;
    }

    public void writeXmlElement(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("test_run");
        writer.writeAttribute("module", this.moduleName);
        writer.writeAttribute("package", this.packageName);
        writer.writeAttribute("class", this.className);
        writer.writeAttribute("name", this.testName);
        writer.writeAttribute("duration", String.valueOf(this.duration));
        writer.writeAttribute("status", this.result.toPrettyName());
        writer.writeAttribute("started", String.valueOf(this.started));
        if (this.externalReportUrl != null && !this.externalReportUrl.isEmpty()) {
            writer.writeAttribute("external_report_url", this.externalReportUrl);
        }
        if (this.externalRunId != null && !this.externalRunId.isEmpty()) {
            writer.writeAttribute("external_run_id", this.externalRunId);
        }
        if (HPRunnerType.UFT_MBT.equals((Object)this.runnerType)) {
            writer.writeAttribute("run_type", "MBT");
        }
        if (this.result.equals((Object)TestResultStatus.FAILED) && this.testError != null) {
            writer.writeStartElement("error");
            writer.writeAttribute("type", String.valueOf(this.testError.getErrorType()));
            writer.writeAttribute("message", String.valueOf(this.testError.getErrorMsg()));
            writer.writeCharacters(this.testError.getStackTraceStr());
            writer.writeEndElement();
        } else if (this.testError != null && !SdkStringUtils.isEmpty((String)this.testError.getErrorMsg())) {
            writer.writeStartElement("error");
            writer.writeAttribute("message", String.valueOf(this.testError.getErrorMsg()));
            writer.writeEndElement();
        }
        if (this.description != null && !this.description.isEmpty()) {
            writer.writeStartElement("description");
            writer.writeCharacters(this.description);
            writer.writeEndElement();
        }
        if (this.octaneSupportsSteps && this.uftResultData != null) {
            try {
                for (int i = 0; i < this.uftResultData.size(); ++i) {
                    writer.writeStartElement("steps");
                    writer.writeAttribute("iteration", String.valueOf(i + 1));
                    List steps = this.uftResultData.get(i).getSteps();
                    for (int j = 0; j < steps.size(); ++j) {
                        UftResultStepParameter parameter;
                        int k;
                        UftResultStepData uftResultStepData = (UftResultStepData)steps.get(j);
                        writer.writeStartElement("step");
                        writer.writeAttribute("name", String.valueOf(uftResultStepData.getParents().get(uftResultStepData.getParents().size() - 1)));
                        writer.writeAttribute("duration", String.valueOf(uftResultStepData.getDuration()));
                        writer.writeAttribute("status", uftResultStepData.getResult());
                        String errorMessage = uftResultStepData.getMessage();
                        if (StringUtils.isNotBlank((String)errorMessage)) {
                            writer.writeStartElement("error_message");
                            writer.writeCharacters(errorMessage);
                            writer.writeEndElement();
                        }
                        if (uftResultStepData.getInputParameters() != null && !uftResultStepData.getInputParameters().isEmpty()) {
                            writer.writeStartElement("input_parameters");
                            for (k = 0; k < uftResultStepData.getInputParameters().size(); ++k) {
                                parameter = (UftResultStepParameter)uftResultStepData.getInputParameters().get(k);
                                writer.writeStartElement("parameter");
                                writer.writeAttribute("name", parameter.getName());
                                writer.writeAttribute("value", parameter.getValue());
                                writer.writeAttribute("type", parameter.getType());
                                writer.writeEndElement();
                            }
                            writer.writeEndElement();
                        }
                        if (uftResultStepData.getOutputParameters() != null && !uftResultStepData.getOutputParameters().isEmpty()) {
                            writer.writeStartElement("output_parameters");
                            for (k = 0; k < uftResultStepData.getOutputParameters().size(); ++k) {
                                parameter = (UftResultStepParameter)uftResultStepData.getOutputParameters().get(k);
                                writer.writeStartElement("parameter");
                                writer.writeAttribute("name", parameter.getName());
                                writer.writeAttribute("value", parameter.getValue());
                                writer.writeAttribute("type", parameter.getType());
                                writer.writeEndElement();
                            }
                            writer.writeEndElement();
                        }
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
            }
            catch (Exception e) {
                logger.error("Failed to write Steps elements", (Throwable)e);
            }
        }
        writer.writeEndElement();
    }
}

