/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.tests.detection;

import com.microfocus.application.automation.tools.octane.tests.build.BuildHandlerUtils;
import com.microfocus.application.automation.tools.octane.tests.detection.ResultFields;
import com.microfocus.application.automation.tools.octane.tests.detection.ResultFieldsDetectionExtension;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.maven.MavenBuild;
import hudson.maven.MavenModuleSetBuild;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.remoting.VirtualChannel;
import hudson.tasks.junit.JUnitResultArchiver;
import hudson.tasks.test.AbstractTestResultAction;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.jenkinsci.remoting.Role;
import org.jenkinsci.remoting.RoleChecker;
import org.jenkinsci.remoting.RoleSensitive;

@Extension(optional=true)
public class TestNGExtension
extends ResultFieldsDetectionExtension {
    private static final String TESTNG = "TestNG";
    private static final String TESTNG_RESULT_FILE = "testng-results.xml";
    private static final List<String> supportedReportFileLocations = Arrays.asList("target/surefire-reports/testng-results.xml", "target/failsafe-reports/testng-results.xml");

    public ResultFields detect(Run build) throws IOException, InterruptedException {
        MavenBuild mavenBuild;
        if (!(build instanceof AbstractBuild)) {
            return null;
        }
        List publishers = ((AbstractBuild)build).getProject().getPublishersList().toList();
        for (Object publisher : publishers) {
            if (!"hudson.tasks.junit.JUnitResultArchiver".equals(publisher.getClass().getName())) continue;
            JUnitResultArchiver junit = (JUnitResultArchiver)publisher;
            String testResultsPattern = junit.getTestResults();
            if (!((Boolean)BuildHandlerUtils.getWorkspace(build).act((FilePath.FileCallable)new TestNgResultsFileFinder(testResultsPattern))).booleanValue()) continue;
            return new ResultFields(TESTNG, null, null);
        }
        if ("hudson.maven.MavenBuild".equals(build.getClass().getName()) && this.findTestNgResultsFile(mavenBuild = (MavenBuild)build)) {
            return new ResultFields(TESTNG, null, null);
        }
        if ("hudson.maven.MavenModuleSetBuild".equals(build.getClass().getName())) {
            Map moduleLastBuilds = ((MavenModuleSetBuild)build).getModuleLastBuilds();
            for (MavenBuild mavenBuild2 : moduleLastBuilds.values()) {
                if (!this.findTestNgResultsFile(mavenBuild2)) continue;
                return new ResultFields(TESTNG, null, null);
            }
        }
        return null;
    }

    boolean findTestNgResultsFile(MavenBuild mavenBuild) throws IOException, InterruptedException {
        AbstractTestResultAction action = (AbstractTestResultAction)mavenBuild.getAction(AbstractTestResultAction.class);
        return action != null && (Boolean)mavenBuild.getWorkspace().act((FilePath.FileCallable)new TestNgResultsFileMavenFinder()) != false;
    }

    public static class TestNgResultsFileFinder
    implements FilePath.FileCallable<Boolean> {
        private String testResultsPattern;

        public TestNgResultsFileFinder(String testResultsPattern) {
            this.testResultsPattern = testResultsPattern;
        }

        public Boolean invoke(File workspace, VirtualChannel virtualChannel) throws IOException, InterruptedException {
            FileSet fs = Util.createFileSet((File)workspace, (String)this.testResultsPattern);
            DirectoryScanner ds = fs.getDirectoryScanner();
            String[] includedFiles = ds.getIncludedFiles();
            File baseDir = ds.getBasedir();
            if (includedFiles.length > 0 && this.findTestNgResultsFile(baseDir, includedFiles)) {
                return true;
            }
            return false;
        }

        public void checkRoles(RoleChecker roleChecker) throws SecurityException {
            roleChecker.check((RoleSensitive)this, Role.UNKNOWN);
        }

        boolean findTestNgResultsFile(File baseDir, String[] includedFiles) throws IOException, InterruptedException {
            LinkedHashSet<FilePath> directoryCache = new LinkedHashSet<FilePath>();
            for (String path : includedFiles) {
                FilePath file = new FilePath(baseDir).child(path);
                if (!file.exists() || directoryCache.contains(file.getParent())) continue;
                directoryCache.add(file.getParent());
                FilePath testNgResulsFile = new FilePath(file.getParent(), TestNGExtension.TESTNG_RESULT_FILE);
                if (!testNgResulsFile.exists()) continue;
                return true;
            }
            return false;
        }
    }

    public static class TestNgResultsFileMavenFinder
    implements FilePath.FileCallable<Boolean> {
        public Boolean invoke(File workspace, VirtualChannel virtualChannel) {
            for (String locationInWorkspace : supportedReportFileLocations) {
                File reportFile = new File(workspace, locationInWorkspace);
                if (!reportFile.exists()) continue;
                return true;
            }
            return false;
        }

        public void checkRoles(RoleChecker roleChecker) throws SecurityException {
            roleChecker.check((RoleSensitive)this, Role.UNKNOWN);
        }
    }
}

