/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.pullrequests;

import com.hp.octane.integrations.dto.scm.PullRequest;
import com.hp.octane.integrations.dto.scm.SCMCommit;
import com.microfocus.application.automation.tools.octane.GitFetchUtils;
import com.microfocus.application.automation.tools.octane.Messages;
import hudson.model.Action;
import hudson.model.Run;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.CheckForNull;

public class PullRequestBuildAction
implements Action {
    private final Run<?, ?> build;
    private final List<PullRequest> pullRequests;
    private final long minUpdateTime;
    private final String sourceBranchFilter;
    private final String targetBranchFilter;
    private final String repositoryUrl;
    private final Long index;
    private SimpleDateFormat dateFormat = null;

    @CheckForNull
    public String getIconFileName() {
        return "notepad.png";
    }

    public PullRequestBuildAction(Run<?, ?> build, List<PullRequest> pullRequests, String repositoryUrl, long minUpdateTime, String sourceBranchFilter, String targetBranchFilter, long index) {
        this.build = build;
        this.index = index;
        this.pullRequests = pullRequests;
        this.minUpdateTime = minUpdateTime;
        this.sourceBranchFilter = sourceBranchFilter;
        this.targetBranchFilter = targetBranchFilter;
        this.repositoryUrl = repositoryUrl;
    }

    @CheckForNull
    public String getDisplayName() {
        return Messages.PullRequestActionConfigurationLabel();
    }

    @CheckForNull
    public String getUrlName() {
        return "pull-request-report" + (String)(this.index == null || this.index.equals(0L) ? "" : "-" + this.index);
    }

    public List<PullRequest> getPullRequests() {
        return this.pullRequests;
    }

    public final Run<?, ?> getBuild() {
        return this.build;
    }

    public String getFormattedDate(long longTime) {
        if (this.dateFormat == null) {
            this.dateFormat = GitFetchUtils.generateDateFormat();
        }
        return this.dateFormat.format(new Date(longTime));
    }

    public String getTopCommits(PullRequest p) {
        StringBuilder sb = new StringBuilder();
        int counter = 0;
        int max_detailed_count = 10;
        int max_commit_message_size = 50;
        for (SCMCommit commit : p.getCommits()) {
            sb.append(commit.getComment(), 0, Math.min(max_commit_message_size, commit.getComment().length()));
            if (commit.getComment().length() > max_commit_message_size) {
                sb.append("...");
            }
            sb.append("\n");
            if (++counter < max_detailed_count) continue;
            sb.append("And other " + (p.getCommits().size() - max_detailed_count) + " commits");
            break;
        }
        return sb.toString();
    }

    public long getMinUpdateTime() {
        return this.minUpdateTime;
    }

    public String getSourceBranchFilter() {
        return this.sourceBranchFilter;
    }

    public String getTargetBranchFilter() {
        return this.targetBranchFilter;
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }
}

