/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.model.processors.parameters;

import com.hp.octane.integrations.dto.DTOFactory;
import com.hp.octane.integrations.dto.parameters.CIParameter;
import com.hp.octane.integrations.dto.parameters.CIParameterType;
import com.microfocus.application.automation.tools.octane.configuration.SDKBasedLoggerProvider;
import com.microfocus.application.automation.tools.octane.model.ModelFactory;
import com.microfocus.application.automation.tools.octane.model.processors.parameters.AbstractParametersProcessor;
import com.microfocus.application.automation.tools.octane.model.processors.parameters.ActiveChoiceParameterProcessor;
import com.microfocus.application.automation.tools.octane.model.processors.parameters.ExtendedChoiceParameterProcessor;
import com.microfocus.application.automation.tools.octane.model.processors.parameters.InherentParameterProcessor;
import com.microfocus.application.automation.tools.octane.model.processors.parameters.NodeLabelParameterProcessor;
import com.microfocus.application.automation.tools.octane.model.processors.parameters.RandomStringParameterProcessor;
import com.microfocus.application.automation.tools.octane.model.processors.parameters.UnsupportedParameterProcessor;
import hudson.matrix.Axis;
import hudson.matrix.AxisList;
import hudson.matrix.Combination;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixProject;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.PasswordParameterDefinition;
import hudson.model.Run;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;

public enum ParameterProcessors {
    EXTENDED("com.cwctravel.hudson.plugins.extended_choice_parameter.ExtendedChoiceParameterDefinition", ExtendedChoiceParameterProcessor.class),
    INHERENT("hudson.model", InherentParameterProcessor.class),
    NODE_LABEL("org.jvnet.jenkins.plugins.nodelabelparameter", NodeLabelParameterProcessor.class),
    RANDOM_STRING("hudson.plugins.random_string_parameter.RandomStringParameterDefinition", RandomStringParameterProcessor.class),
    ACTIVE_CHOICE("org.biouno.unochoice", ActiveChoiceParameterProcessor.class);

    private static final Logger logger;
    private static final DTOFactory dtoFactory;
    private String targetPluginClassName;
    private Class<? extends AbstractParametersProcessor> processorClass;

    private ParameterProcessors(String targetPluginClassName, Class<? extends AbstractParametersProcessor> processorClass) {
        this.targetPluginClassName = targetPluginClassName;
        this.processorClass = processorClass;
    }

    public static List<CIParameter> getConfigs(Job job) {
        ArrayList<CIParameter> result = new ArrayList<CIParameter>();
        if (job.getProperty(ParametersDefinitionProperty.class) != null) {
            List paramDefinitions = ((ParametersDefinitionProperty)job.getProperty(ParametersDefinitionProperty.class)).getParameterDefinitions();
            for (int i = 0; paramDefinitions != null && i < paramDefinitions.size(); ++i) {
                ParameterDefinition pd = (ParameterDefinition)paramDefinitions.get(i);
                if (pd instanceof PasswordParameterDefinition) continue;
                String className = pd.getClass().getName();
                AbstractParametersProcessor processor = ParameterProcessors.getAppropriate(className);
                result.add(processor.createParameterConfig(pd));
            }
        }
        if (job instanceof MatrixProject) {
            AxisList axisList = ((MatrixProject)job).getAxes();
            for (Axis axis : axisList) {
                result.add(ModelFactory.createParameterConfig(axis.getName(), CIParameterType.AXIS, new ArrayList<Object>(axis.getValues())));
            }
        }
        return result;
    }

    public static List<CIParameter> getInstances(Run run) {
        ArrayList<CIParameter> result = new ArrayList<CIParameter>();
        try {
            Job job = run.getParent();
            ParametersAction parametersAction = (ParametersAction)run.getAction(ParametersAction.class);
            Map<Object, Object> parametersValues = parametersAction != null ? parametersAction.getAllParameters().stream().collect(Collectors.toMap(ParameterValue::getName, Function.identity(), (v1, v2) -> v1)) : new HashMap();
            if (job instanceof MatrixConfiguration) {
                Combination combination = ((MatrixConfiguration)job).getCombination();
                for (Map.Entry entry : combination.entrySet()) {
                    CIParameter tmp = ((CIParameter)dtoFactory.newDTO(CIParameter.class)).setType(CIParameterType.AXIS).setName((String)entry.getKey()).setValue(entry.getValue());
                    result.add(tmp);
                }
            }
            if (job.getProperty(ParametersDefinitionProperty.class) != null) {
                List paramDefinitions = ((ParametersDefinitionProperty)job.getProperty(ParametersDefinitionProperty.class)).getParameterDefinitions();
                for (ParameterDefinition parameterDefinition : paramDefinitions) {
                    String className = parameterDefinition.getClass().getName();
                    ParameterValue pv = (ParameterValue)parametersValues.remove(parameterDefinition.getName());
                    try {
                        AbstractParametersProcessor processor = ParameterProcessors.getAppropriate(className);
                        result.add(processor.createParameterInstance(parameterDefinition, pv));
                    }
                    catch (Exception e) {
                        logger.error("failed to process instance of parameter or type '" + className + "', adding as unsupported", (Throwable)e);
                        result.add(new UnsupportedParameterProcessor().createParameterInstance(parameterDefinition, pv));
                    }
                }
            }
            for (ParameterValue parameterValue : parametersValues.values()) {
                if (parameterValue.getValue() == null) continue;
                CIParameter param = ((CIParameter)dtoFactory.newDTO(CIParameter.class)).setType(CIParameterType.STRING).setName(parameterValue.getName()).setValue(parameterValue.getValue());
                result.add(param);
            }
        }
        catch (Exception e) {
            logger.error("failed to process parameters of " + String.valueOf(run), (Throwable)e);
        }
        return result;
    }

    public static List<CIParameter> getInstances(ParametersAction parametersAction) {
        ArrayList<CIParameter> result = new ArrayList<CIParameter>();
        try {
            Map parametersValues = parametersAction.getAllParameters().stream().collect(Collectors.toMap(ParameterValue::getName, Function.identity(), (v1, v2) -> v1));
            for (ParameterValue notDefinedParameter : parametersValues.values()) {
                if (notDefinedParameter.getValue() == null) continue;
                CIParameter param = ((CIParameter)dtoFactory.newDTO(CIParameter.class)).setType(CIParameterType.STRING).setName(notDefinedParameter.getName()).setValue(notDefinedParameter.getValue());
                result.add(param);
            }
        }
        catch (Exception e) {
            logger.error("failed to process parameters :" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private static AbstractParametersProcessor getAppropriate(String className) {
        for (ParameterProcessors p : ParameterProcessors.values()) {
            if (!className.startsWith(p.targetPluginClassName)) continue;
            try {
                return p.processorClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException ie) {
                logger.error("failed to instantiate instance of parameters processor of type " + className, (Throwable)ie);
            }
        }
        return new UnsupportedParameterProcessor();
    }

    static {
        logger = SDKBasedLoggerProvider.getLogger(ParameterProcessors.class);
        dtoFactory = DTOFactory.getInstance();
    }
}

