/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.model.processors.builders;

import com.microfocus.application.automation.tools.octane.configuration.SDKBasedLoggerProvider;
import com.microfocus.application.automation.tools.octane.model.ModelFactory;
import com.microfocus.application.automation.tools.octane.model.processors.builders.AbstractBuilderProcessor;
import com.tikal.jenkins.plugins.multijob.MultiJobBuilder;
import com.tikal.jenkins.plugins.multijob.PhaseJobsConfig;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.Job;
import hudson.tasks.Builder;
import java.util.ArrayList;
import java.util.Set;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Logger;

class MultiJobBuilderProcessor
extends AbstractBuilderProcessor {
    private static final Logger logger = SDKBasedLoggerProvider.getLogger(MultiJobBuilderProcessor.class);

    MultiJobBuilderProcessor(Builder builder, Job job, Set<Job> processedJobs) {
        MultiJobBuilder b = (MultiJobBuilder)builder;
        this.phases = new ArrayList();
        ArrayList<AbstractProject> items = new ArrayList<AbstractProject>();
        for (PhaseJobsConfig config : b.getPhaseJobs()) {
            if (StringUtils.isEmpty((String)config.getJobName())) continue;
            Item item = Jenkins.get().getItemByFullName(config.getJobName());
            if (item == null) {
                logger.debug(job.getFullName() + "' contains phase job  '" + config.getJobName() + "' that is not found.");
                continue;
            }
            if (item instanceof AbstractProject) {
                AbstractProject tmpProject = (AbstractProject)item;
                if (processedJobs.contains(tmpProject)) {
                    logger.warn(String.format("encountered circular reference from %s to %s", job.getFullName(), tmpProject.getFullName()));
                    continue;
                }
                items.add(tmpProject);
                continue;
            }
            logger.warn(job.getFullName() + "' contains phase job '" + config.getJobName() + "' that is not AbstractProject");
        }
        this.phases.add(ModelFactory.createStructurePhase(b.getPhaseName(), true, items, processedJobs));
    }
}

