/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.executor.scmmanager;

import com.cloudbees.hudson.plugins.folder.Folder;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.hp.octane.integrations.dto.connectivity.OctaneResponse;
import com.hp.octane.integrations.dto.executor.TestConnectivityInfo;
import com.hp.octane.integrations.dto.scm.SCMRepository;
import com.hp.octane.integrations.dto.scm.SCMType;
import com.microfocus.application.automation.tools.octane.configuration.SDKBasedLoggerProvider;
import com.microfocus.application.automation.tools.octane.executor.scmmanager.ScmPluginHandler;
import hudson.EnvVars;
import hudson.model.AbstractProject;
import hudson.model.FreeStyleProject;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.TaskListener;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.GitTool;
import hudson.plugins.git.UserRemoteConfig;
import hudson.plugins.git.extensions.impl.RelativeTargetDirectory;
import hudson.scm.SCM;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Logger;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;

public class GitPluginHandler
implements ScmPluginHandler {
    private static final Logger logger = SDKBasedLoggerProvider.getLogger(GitPluginHandler.class);

    @Override
    public void setScmRepositoryInJob(SCMRepository scmRepository, String scmRepositoryCredentialsId, FreeStyleProject proj, boolean executorJob) throws IOException {
        List branches;
        List<UserRemoteConfig> repoLists = Collections.singletonList(new UserRemoteConfig(scmRepository.getUrl(), null, null, scmRepositoryCredentialsId));
        List<RelativeTargetDirectory> extensions = null;
        if (executorJob) {
            String folder = this.buildRepoFolder(proj);
            String repoName = this.buildRepoName(scmRepository.getUrl());
            String relativeCheckOut = folder + repoName;
            RelativeTargetDirectory targetDirectory = new RelativeTargetDirectory(relativeCheckOut);
            extensions = Collections.singletonList(targetDirectory);
        }
        String branch = "*/master";
        if (proj.getScm() != null && proj.getScm() instanceof GitSCM && (branches = ((GitSCM)proj.getScm()).getBranches()).size() > 0) {
            boolean emptyBrName;
            String existingBrName = ((BranchSpec)branches.get(0)).getName();
            boolean bl = emptyBrName = existingBrName == null || existingBrName.isEmpty() || existingBrName.equals("**");
            if (!emptyBrName) {
                branch = existingBrName;
            }
        }
        GitSCM scm = new GitSCM(repoLists, Collections.singletonList(new BranchSpec(branch)), Boolean.valueOf(false), Collections.emptyList(), null, null, extensions);
        proj.setScm((SCM)scm);
    }

    private String buildRepoFolder(FreeStyleProject proj) {
        Object pathPrefix = "";
        ItemGroup parent = proj.getParent();
        while (Jenkins.get() != null && !parent.equals((Object)Jenkins.get())) {
            pathPrefix = (String)pathPrefix + "..\\";
            if (!(parent instanceof Folder)) break;
            parent = ((Folder)parent).getParent();
        }
        return (String)pathPrefix + "..\\..\\_test_sources\\";
    }

    private String buildRepoName(String scmRepoUrl) {
        Object temp = scmRepoUrl.replaceAll("[<>:\"/\\|?*]", "_").trim();
        String GIT_SUFFIX = ".git";
        String HTTP_PREFIX = "http_";
        String HTTPS_PREFIX = "https_";
        String GIT_PREFIX = "git@";
        if (((String)temp).toLowerCase().endsWith(GIT_SUFFIX)) {
            temp = ((String)temp).substring(0, ((String)temp).length() - GIT_SUFFIX.length());
        }
        if (((String)temp).toLowerCase().startsWith(GIT_PREFIX)) {
            temp = ((String)temp).substring(GIT_PREFIX.length());
        } else if (((String)temp).toLowerCase().startsWith(HTTPS_PREFIX)) {
            temp = ((String)temp).substring(HTTPS_PREFIX.length());
        } else if (((String)temp).toLowerCase().startsWith(HTTP_PREFIX)) {
            temp = ((String)temp).substring(HTTP_PREFIX.length());
        }
        temp = StringUtils.strip((String)temp, (String)"_");
        int CHECK_SIZE = 40;
        int SPLIT_SIZE = CHECK_SIZE - 4;
        if (((String)temp).length() > CHECK_SIZE) {
            String split1 = ((String)temp).substring(0, ((String)temp).length() - SPLIT_SIZE);
            String split2 = ((String)temp).substring(((String)temp).length() - SPLIT_SIZE);
            temp = "_" + Math.abs(split1.hashCode() % 1000) + split2;
        }
        return temp;
    }

    @Override
    public String getSharedCheckOutDirectory(Job j) {
        SCM scm = ((AbstractProject)j).getScm();
        GitSCM gitScm = (GitSCM)scm;
        RelativeTargetDirectory sharedCheckOutDirectory = (RelativeTargetDirectory)gitScm.getExtensions().get(RelativeTargetDirectory.class);
        if (sharedCheckOutDirectory != null) {
            return sharedCheckOutDirectory.getRelativeTargetDir();
        }
        return null;
    }

    @Override
    public void checkRepositoryConnectivity(TestConnectivityInfo testConnectivityInfo, StandardCredentials credentials, OctaneResponse result) {
        try {
            EnvVars environment = new EnvVars(System.getenv());
            GitClient git = Git.with((TaskListener)TaskListener.NULL, (EnvVars)environment).using(GitTool.getDefaultInstallation().getGitExe()).getClient();
            git.addDefaultCredentials(credentials);
            git.getHeadRev(testConnectivityInfo.getScmRepository().getUrl(), "HEAD");
            result.setStatus(200);
        }
        catch (IOException | InterruptedException e) {
            logger.error("Failed to connect to git : " + e.getMessage());
            result.setStatus(500);
            result.setBody(e.getMessage());
        }
        catch (GitException e) {
            logger.error("Failed to execute getHeadRev : " + e.getMessage());
            result.setStatus(404);
            result.setBody(e.getMessage());
        }
    }

    @Override
    public String getScmRepositoryUrl(SCM scm) {
        return ((UserRemoteConfig)((GitSCM)scm).getUserRemoteConfigs().get(0)).getUrl();
    }

    @Override
    public String getScmRepositoryCredentialsId(SCM scm) {
        return ((UserRemoteConfig)((GitSCM)scm).getUserRemoteConfigs().get(0)).getCredentialsId();
    }

    @Override
    public SCMType getScmType() {
        return SCMType.GIT;
    }

    @Override
    public String tryExtractUrlShortName(String url) {
        String patternStr = "^.*[/:](.*/.*)$";
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(url);
        if (matcher.find() && matcher.groupCount() == 1) {
            return matcher.group(1);
        }
        return url;
    }
}

