/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.executor;

import com.hp.octane.integrations.utils.CIPluginSDKUtils;
import com.microfocus.application.automation.tools.octane.configuration.SDKBasedLoggerProvider;
import com.microfocus.application.automation.tools.octane.executor.UftConstants;
import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.model.ParameterDefinition;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Queue;
import java.io.IOException;
import java.util.List;
import jenkins.model.Jenkins;
import org.apache.logging.log4j.Logger;

public class UftJobRecognizer {
    private static Logger logger = SDKBasedLoggerProvider.getLogger(UftJobRecognizer.class);

    public static boolean isExecutorJob(FreeStyleProject job) {
        return job.getName().startsWith("UFT-test-execution-job-Test-Runner-ID") || job.getName().startsWith(UftConstants.UFT_EXECUTION_JOB_MIDDLE_NAME_WITH_TEST_RUNNERS_NEW) || job.getName().startsWith(UftConstants.MBT_EXECUTION_JOB_MIDDLE_NAME_WITH_TEST_RUNNERS_NEW);
    }

    public static boolean isDiscoveryJob(FreeStyleProject job) {
        return job.getName().startsWith("UFT-test-discovery-job-Test-Runner-ID") || job.getName().startsWith(UftConstants.UFT_DISCOVERY_JOB_MIDDLE_NAME_WITH_TEST_RUNNERS_NEW) || job.getName().startsWith(UftConstants.MBT_DISCOVERY_JOB_MIDDLE_NAME_WITH_TEST_RUNNERS_NEW);
    }

    public static String getExecutorId(FreeStyleProject job) {
        ParametersDefinitionProperty parameters = (ParametersDefinitionProperty)job.getProperty(ParametersDefinitionProperty.class);
        ParameterDefinition pd = parameters.getParameterDefinition("Test Runner ID");
        if (pd != null) {
            return (String)pd.getDefaultParameterValue().getValue();
        }
        return null;
    }

    public static String getExecutorLogicalName(FreeStyleProject job) {
        ParametersDefinitionProperty parameters = (ParametersDefinitionProperty)job.getProperty(ParametersDefinitionProperty.class);
        ParameterDefinition pd = parameters.getParameterDefinition("Test Runner logical name");
        if (pd != null) {
            return (String)pd.getDefaultParameterValue().getValue();
        }
        return null;
    }

    public static void deleteExecutionJobByExecutorIfNeverExecuted(String executorToDelete) {
        List jobs = Jenkins.getInstanceOrNull().getAllItems(FreeStyleProject.class);
        for (FreeStyleProject proj : jobs) {
            if (!UftJobRecognizer.isExecutorJob(proj) || !UftJobRecognizer.isJobMatchExecutor(executorToDelete, proj).booleanValue() || proj.getLastBuild() != null || proj.isBuilding() || proj.isInQueue()) continue;
            try {
                logger.warn(String.format("Job '%s' is going to be deleted since matching executor in Octane was deleted and this job was never executed and has no history.", proj.getName()));
                proj.delete();
            }
            catch (IOException | InterruptedException e) {
                logger.error("Failed to delete job  " + proj.getName() + " : " + e.getMessage());
            }
        }
    }

    private static Boolean isJobMatchExecutor(String executorToFind, FreeStyleProject proj) {
        String executorId = UftJobRecognizer.getExecutorId(proj);
        String executorLogicalName = UftJobRecognizer.getExecutorLogicalName(proj);
        return executorId != null && executorId.equals(executorToFind) || executorLogicalName != null && executorLogicalName.equals(executorToFind);
    }

    public static void deleteDiscoveryJobByExecutor(String executorToDelete) {
        List jobs = Jenkins.getInstanceOrNull().getAllItems(FreeStyleProject.class);
        for (FreeStyleProject proj : jobs) {
            if (!UftJobRecognizer.isDiscoveryJob(proj) || !UftJobRecognizer.isJobMatchExecutor(executorToDelete, proj).booleanValue()) continue;
            if (proj.isBuilding()) {
                ((FreeStyleBuild)proj.getLastBuild()).getExecutor().interrupt();
                CIPluginSDKUtils.doWait((long)10000L);
            } else if (proj.isInQueue()) {
                Jenkins.getInstanceOrNull().getQueue().cancel((Queue.Task)proj);
                CIPluginSDKUtils.doWait((long)10000L);
            }
            try {
                logger.warn(String.format("Job '%s' is going to be deleted since matching executor in Octane was deleted", proj.getName()));
                proj.delete();
            }
            catch (Exception e) {
                logger.error("Failed to delete job  " + proj.getName() + " : " + e.getMessage());
            }
        }
    }
}

