/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.executor;

import com.hp.octane.integrations.dto.executor.impl.TestingToolType;
import com.hp.octane.integrations.dto.scm.SCMType;
import com.hp.octane.integrations.uft.UftTestDiscoveryUtils;
import com.hp.octane.integrations.uft.items.UftTestDiscoveryResult;
import com.microfocus.application.automation.tools.octane.executor.UFTTestDetectionService;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.remoting.VirtualChannel;
import hudson.scm.ChangeLogSet;
import hudson.scm.EditType;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.lang.reflect.FieldUtils;
import org.jenkinsci.remoting.RoleChecker;

public class UFTTestDetectionCallable
extends MasterToSlaveFileCallable<UftTestDiscoveryResult> {
    private String configurationId;
    private String workspaceId;
    private String scmRepositoryId;
    private BuildListener buildListener;
    private TestingToolType testingToolType;
    private String testRunnerId;
    private boolean fullScan = false;
    private ScmChangesWrapper scmChangesWrapper;

    public UFTTestDetectionCallable(AbstractBuild<?, ?> build, String configurationId, String workspaceId, String scmRepositoryId, BuildListener buildListener, TestingToolType testingToolType) {
        this.configurationId = configurationId;
        this.workspaceId = workspaceId;
        this.scmRepositoryId = scmRepositoryId;
        this.buildListener = buildListener;
        this.testingToolType = testingToolType == null || TestingToolType.UNKNOWN.equals((Object)testingToolType) ? TestingToolType.UFT : testingToolType;
        this.extractParameterValues(build);
        this.wrapScmChanges(build);
    }

    private void extractParameterValues(AbstractBuild<?, ?> build) {
        ParametersAction parameterAction = (ParametersAction)build.getAction(ParametersAction.class);
        if (parameterAction != null) {
            ParameterValue parameterValue;
            ParameterValue testRunnerParameter = parameterAction.getParameter("Test Runner ID");
            if (testRunnerParameter != null && testRunnerParameter.getValue() instanceof String) {
                this.testRunnerId = (String)testRunnerParameter.getValue();
            }
            if ((parameterValue = parameterAction.getParameter("Full sync")) != null && parameterValue.getValue() != null) {
                this.fullScan = Boolean.parseBoolean(parameterValue.getValue().toString());
            }
            if (!this.fullScan) {
                this.fullScan = build.getId().equals("1");
            }
        }
    }

    private void wrapScmChanges(AbstractBuild<?, ?> build) {
        ChangeLogSet buildChangeSet = build.getChangeSet();
        switch (buildChangeSet.getClass().getName()) {
            case "hudson.plugins.git.GitChangeSetList": {
                this.scmChangesWrapper = new ScmChangesWrapper(SCMType.GIT);
                break;
            }
            case "hudson.scm.SubversionChangeLogSet": {
                this.scmChangesWrapper = new ScmChangesWrapper(SCMType.SVN);
                break;
            }
        }
        if (this.scmChangesWrapper != null) {
            Object[] changeSetItems = build.getChangeSet().getItems();
            for (int i = 0; i < changeSetItems.length; ++i) {
                ChangeLogSet.Entry changeSet = (ChangeLogSet.Entry)changeSetItems[i];
                for (ChangeLogSet.AffectedFile affectedFileChange : changeSet.getAffectedFiles()) {
                    ScmChangeEditTypeWrapper editType;
                    if (affectedFileChange.getEditType().equals(EditType.ADD)) {
                        editType = ScmChangeEditTypeWrapper.ADD;
                    } else if (affectedFileChange.getEditType().equals(EditType.DELETE)) {
                        editType = ScmChangeEditTypeWrapper.DELETE;
                    } else if (affectedFileChange.getEditType().equals(EditType.EDIT)) {
                        editType = ScmChangeEditTypeWrapper.EDIT;
                    } else {
                        throw new IllegalArgumentException("Not expected value : " + String.valueOf(affectedFileChange.getEditType()));
                    }
                    ScmChangeAffectedFileWrapper fileWrapper = new ScmChangeAffectedFileWrapper(affectedFileChange.getPath(), editType);
                    if (this.scmChangesWrapper.getScmType().equals((Object)SCMType.GIT)) {
                        fileWrapper.setGitDst(UFTTestDetectionCallable.getGitDestination(affectedFileChange));
                        fileWrapper.setGitSrc(UFTTestDetectionCallable.getGitSource(affectedFileChange));
                    } else if (this.scmChangesWrapper.getScmType().equals((Object)SCMType.SVN)) {
                        fileWrapper.setSvnDirType(UFTTestDetectionCallable.isSvnDir(affectedFileChange));
                    }
                    if (!fileWrapper.isSvnDirType() && !UftTestDiscoveryUtils.isTestMainFilePath((String)fileWrapper.getPath()) && (!TestingToolType.UFT.equals((Object)this.testingToolType) || !UftTestDiscoveryUtils.isUftDataTableFile((String)fileWrapper.getPath())) && (!TestingToolType.MBT.equals((Object)this.testingToolType) || !UftTestDiscoveryUtils.isUftActionFile((String)fileWrapper.getPath()))) continue;
                    this.scmChangesWrapper.getAffectedFiles().add(fileWrapper);
                }
            }
        }
    }

    public UftTestDiscoveryResult invoke(File file, VirtualChannel virtualChannel) {
        UftTestDiscoveryResult results = UFTTestDetectionService.startScanning(file, this.buildListener, this.configurationId, this.workspaceId, this.scmRepositoryId, this.testRunnerId, this.scmChangesWrapper, this.fullScan, this.testingToolType);
        return results;
    }

    public void checkRoles(RoleChecker roleChecker) throws SecurityException {
    }

    private static boolean isSvnDir(ChangeLogSet.AffectedFile path) {
        try {
            String value = (String)FieldUtils.readDeclaredField((Object)path, (String)"kind", (boolean)true);
            return "dir".equals(value);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String getGitDestination(ChangeLogSet.AffectedFile path) {
        try {
            return (String)FieldUtils.readDeclaredField((Object)path, (String)"dst", (boolean)true);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String getGitSource(ChangeLogSet.AffectedFile path) {
        try {
            return (String)FieldUtils.readDeclaredField((Object)path, (String)"src", (boolean)true);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static class ScmChangesWrapper
    implements Serializable {
        private SCMType scmType;
        private List<ScmChangeAffectedFileWrapper> affectedFiles = new ArrayList<ScmChangeAffectedFileWrapper>();

        public ScmChangesWrapper(SCMType scmType) {
            this.scmType = scmType;
        }

        public SCMType getScmType() {
            return this.scmType;
        }

        public List<ScmChangeAffectedFileWrapper> getAffectedFiles() {
            return this.affectedFiles;
        }
    }

    public static enum ScmChangeEditTypeWrapper implements Serializable
    {
        ADD,
        EDIT,
        DELETE;

    }

    public static class ScmChangeAffectedFileWrapper
    implements Serializable {
        private String path;
        private ScmChangeEditTypeWrapper editType;
        private String gitSrc;
        private String gitDst;
        private boolean svnDirType;

        public ScmChangeAffectedFileWrapper(String path, ScmChangeEditTypeWrapper editType) {
            this.path = path;
            this.editType = editType;
        }

        public String getPath() {
            return this.path;
        }

        public ScmChangeEditTypeWrapper getEditType() {
            return this.editType;
        }

        public String getGitDst() {
            return this.gitDst;
        }

        public String getGitSrc() {
            return this.gitSrc;
        }

        public boolean isSvnDirType() {
            return this.svnDirType;
        }

        public void setGitSrc(String gitSrc) {
            this.gitSrc = gitSrc;
        }

        public void setGitDst(String gitDst) {
            this.gitDst = gitDst;
        }

        public void setSvnDirType(boolean svnDirType) {
            this.svnDirType = svnDirType;
        }
    }
}

