/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.executor;

import antlr.ANTLRException;
import com.cloudbees.hudson.plugins.folder.Folder;
import com.hp.octane.integrations.OctaneClient;
import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.dto.executor.DiscoveryInfo;
import com.hp.octane.integrations.dto.executor.impl.TestingToolType;
import com.hp.octane.integrations.dto.scm.SCMRepository;
import com.hp.octane.integrations.executor.TestsToRunFramework;
import com.hp.octane.integrations.services.configurationparameters.UftTestRunnerFolderParameter;
import com.microfocus.application.automation.tools.model.ResultsPublisherModel;
import com.microfocus.application.automation.tools.octane.actions.UFTTestDetectionPublisher;
import com.microfocus.application.automation.tools.octane.configuration.SDKBasedLoggerProvider;
import com.microfocus.application.automation.tools.octane.executor.UftConstants;
import com.microfocus.application.automation.tools.octane.executor.scmmanager.ScmPluginFactory;
import com.microfocus.application.automation.tools.octane.executor.scmmanager.ScmPluginHandler;
import com.microfocus.application.automation.tools.octane.model.processors.projects.JobProcessorFactory;
import com.microfocus.application.automation.tools.octane.testrunner.TestsToRunConverterBuilder;
import com.microfocus.application.automation.tools.results.RunResultRecorder;
import com.microfocus.application.automation.tools.run.RunFromCodelessBuilder;
import com.microfocus.application.automation.tools.run.RunFromFileBuilder;
import hudson.model.Action;
import hudson.model.BooleanParameterDefinition;
import hudson.model.BooleanParameterValue;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.ChoiceParameterDefinition;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.FreeStyleProject;
import hudson.model.Item;
import hudson.model.JobProperty;
import hudson.model.Label;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.StringParameterDefinition;
import hudson.model.StringParameterValue;
import hudson.tasks.BuildWrapper;
import hudson.triggers.SCMTrigger;
import hudson.triggers.Trigger;
import hudson.util.DescribableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Logger;
import org.kohsuke.stapler.StaplerRequest2;

public class TestExecutionJobCreatorService {
    private static final Logger logger = SDKBasedLoggerProvider.getLogger(TestExecutionJobCreatorService.class);

    private static void setScmRepository(SCMRepository scmRepository, String scmRepositoryCredentialsId, FreeStyleProject proj, boolean executorJob) {
        ScmPluginHandler scmPluginHandler = ScmPluginFactory.getScmHandler(scmRepository.getType());
        try {
            scmPluginHandler.setScmRepositoryInJob(scmRepository, scmRepositoryCredentialsId, proj, executorJob);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to set SCM repository : " + e.getMessage());
        }
    }

    public static void runTestDiscovery(DiscoveryInfo discoveryInfo) {
        FreeStyleProject proj = TestExecutionJobCreatorService.createDiscoveryJob(discoveryInfo);
        if (proj != null) {
            ArrayList<Object> paramList = new ArrayList<Object>();
            BooleanParameterValue fullScanParam = new BooleanParameterValue("Full sync", discoveryInfo.isForceFullDiscovery());
            paramList.add(fullScanParam);
            ParametersDefinitionProperty parameters = (ParametersDefinitionProperty)proj.getProperty(ParametersDefinitionProperty.class);
            if (parameters.getParameterDefinitionNames().contains("Test Runner ID")) {
                StringParameterValue testRunnerIdParam = new StringParameterValue("Test Runner ID", discoveryInfo.getExecutorId());
                paramList.add(testRunnerIdParam);
            }
            ParametersAction paramAction = new ParametersAction(paramList);
            Cause.UserIdCause cause = new Cause.UserIdCause();
            CauseAction causeAction = new CauseAction((Cause)cause);
            proj.scheduleBuild2(0, new Action[]{paramAction, causeAction});
        }
    }

    private static Folder getParentFolder(String configurationId) {
        OctaneClient octaneClient = OctaneSDK.getClientByInstanceId((String)configurationId);
        UftTestRunnerFolderParameter uftFolderParameter = (UftTestRunnerFolderParameter)octaneClient.getConfigurationService().getConfiguration().getParameter("UFT_TEST_RUNNER_FOLDER");
        if (uftFolderParameter != null) {
            Item item = Jenkins.getInstanceOrNull().getItemByFullName(uftFolderParameter.getFolder());
            String errorMsg = null;
            if (item == null) {
                errorMsg = "UFT_TEST_RUNNER_FOLDER parameter is defined with '" + uftFolderParameter.getFolder() + "', the folder is not found. Validate that folder exist and jenkins user has READ permission on the folder.";
            }
            if (item != null && !JobProcessorFactory.isFolder(item)) {
                errorMsg = "UFT_TEST_RUNNER_FOLDER parameter is defined with '" + uftFolderParameter.getFolder() + "', the item is " + item.getClass().getName() + " , but expected to be a folder.";
            }
            if (errorMsg != null) {
                logger.error(errorMsg);
                throw new IllegalArgumentException(errorMsg);
            }
            return (Folder)item;
        }
        return null;
    }

    private static FreeStyleProject createProject(String configurationId, String name) throws IOException {
        Folder folder = TestExecutionJobCreatorService.getParentFolder(configurationId);
        FreeStyleProject proj = folder == null ? (FreeStyleProject)Jenkins.getInstanceOrNull().createProject(FreeStyleProject.class, name) : (FreeStyleProject)folder.createProject(FreeStyleProject.class, name);
        return proj;
    }

    private static FreeStyleProject createDiscoveryJob(DiscoveryInfo discoveryInfo) {
        try {
            String discoveryJobPrefix = TestingToolType.UFT.equals((Object)discoveryInfo.getTestingToolType()) ? UftConstants.UFT_DISCOVERY_JOB_MIDDLE_NAME_WITH_TEST_RUNNERS_NEW : UftConstants.MBT_DISCOVERY_JOB_MIDDLE_NAME_WITH_TEST_RUNNERS_NEW;
            String discoveryJobName = String.format("%s-%s-%s", discoveryJobPrefix, discoveryInfo.getExecutorId(), discoveryInfo.getExecutorLogicalName().substring(0, 5));
            FreeStyleProject proj = TestExecutionJobCreatorService.createProject(discoveryInfo.getConfigurationId(), discoveryJobName);
            proj.setDescription(String.format("This job was created by the OpenText Application Automation Tools plugin for discovery of %s tests. It is associated with Software Delivery Management test runner #%s.", discoveryInfo.getTestingToolType().toString(), discoveryInfo.getExecutorId()));
            TestExecutionJobCreatorService.setScmRepository(discoveryInfo.getScmRepository(), discoveryInfo.getScmRepositoryCredentialsId(), proj, false);
            TestExecutionJobCreatorService.addConstantParameter(proj, "Test Runner ID", discoveryInfo.getExecutorId(), "Software Delivery Management test runner ID");
            TestExecutionJobCreatorService.addConstantParameter(proj, "Test Runner logical name", discoveryInfo.getExecutorLogicalName(), "Software Delivery Management test runner logical name");
            TestExecutionJobCreatorService.addBooleanParameter(proj, "Full sync", false, "Specify whether to synchronize the set of tests on Software Delivery Management with the whole SCM repository or to update the set of tests on Software Delivery Management based on the latest commits.");
            SCMTrigger scmTrigger = new SCMTrigger("H/2 * * * *");
            proj.addTrigger((Trigger)scmTrigger);
            TestExecutionJobCreatorService.delayPollingStart(proj, scmTrigger);
            TestExecutionJobCreatorService.addDiscoveryAssignedNode(proj);
            TestExecutionJobCreatorService.addTimestamper(proj);
            TestExecutionJobCreatorService.addUFTTestDetectionPublisherIfNeeded((List)proj.getPublishersList(), discoveryInfo);
            return proj;
        }
        catch (ANTLRException | IOException e) {
            logger.error("Failed to  create DiscoveryJob for test runner: " + e.getMessage());
            return null;
        }
    }

    private static void addUFTTestDetectionPublisherIfNeeded(List publishers, DiscoveryInfo discoveryInfo) {
        UFTTestDetectionPublisher uftTestDetectionPublisher = null;
        for (Object publisher : publishers) {
            if (!(publisher instanceof UFTTestDetectionPublisher)) continue;
            uftTestDetectionPublisher = (UFTTestDetectionPublisher)((Object)publisher);
        }
        if (uftTestDetectionPublisher == null) {
            uftTestDetectionPublisher = new UFTTestDetectionPublisher(discoveryInfo.getConfigurationId(), discoveryInfo.getWorkspaceId(), discoveryInfo.getScmRepositoryId());
            if (TestingToolType.MBT.equals((Object)discoveryInfo.getTestingToolType())) {
                uftTestDetectionPublisher.setTestingToolType(TestingToolType.MBT);
            }
            publishers.add(uftTestDetectionPublisher);
        }
    }

    private static void addTimestamper(FreeStyleProject proj) {
        try {
            BuildWrapper wrapper;
            Descriptor wrapperDescriptor = Jenkins.getInstanceOrNull().getBuildWrapper("TimestamperBuildWrapper");
            if (wrapperDescriptor != null && (wrapper = (BuildWrapper)proj.getBuildWrappersList().get(wrapperDescriptor)) == null) {
                wrapper = (BuildWrapper)wrapperDescriptor.newInstance((StaplerRequest2)null, null);
                proj.getBuildWrappersList().add((Object)wrapper);
            }
        }
        catch (Descriptor.FormException e) {
            logger.error("Failed to  addTimestamper : " + e.getMessage());
        }
    }

    private static void delayPollingStart(final FreeStyleProject proj, final SCMTrigger scmTrigger) {
        long delayStartPolling = 300000L;
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                scmTrigger.start((Item)proj, false);
            }
        }, delayStartPolling);
    }

    private static ParametersDefinitionProperty getParametersDefinitions(FreeStyleProject proj) throws IOException {
        ParametersDefinitionProperty parameters = (ParametersDefinitionProperty)proj.getProperty(ParametersDefinitionProperty.class);
        if (parameters == null) {
            parameters = new ParametersDefinitionProperty(new ArrayList());
            proj.addProperty((JobProperty)parameters);
        }
        return parameters;
    }

    private static void addConstantParameter(FreeStyleProject proj, String parameterName, String parameterValue, String desc) throws IOException {
        ParametersDefinitionProperty parameters = TestExecutionJobCreatorService.getParametersDefinitions(proj);
        if (parameters.getParameterDefinition(parameterName) == null) {
            ChoiceParameterDefinition param = new ChoiceParameterDefinition(parameterName, new String[]{parameterValue}, desc);
            parameters.getParameterDefinitions().add(param);
        }
    }

    private static void addStringParameter(FreeStyleProject proj, String parameterName, String defaultValue, String desc) throws IOException {
        ParametersDefinitionProperty parameters = TestExecutionJobCreatorService.getParametersDefinitions(proj);
        if (parameters.getParameterDefinition(parameterName) == null) {
            StringParameterDefinition param = new StringParameterDefinition(parameterName, defaultValue, desc);
            parameters.getParameterDefinitions().add(param);
        }
    }

    private static void addBooleanParameter(FreeStyleProject proj, String parameterName, Boolean defaultValue, String desc) throws IOException {
        ParametersDefinitionProperty parameters = TestExecutionJobCreatorService.getParametersDefinitions(proj);
        if (parameters.getParameterDefinition(parameterName) == null) {
            BooleanParameterDefinition param = new BooleanParameterDefinition(parameterName, defaultValue.booleanValue(), desc);
            parameters.getParameterDefinitions().add(param);
        }
    }

    private static void addDiscoveryAssignedNode(FreeStyleProject proj) {
        try {
            Label joinedLabel = Label.parseExpression((String)(String.valueOf(Jenkins.getInstanceOrNull().getSelfLabel()) + "||" + String.valueOf(Jenkins.getInstanceOrNull().getSelfLabel())));
            proj.setAssignedLabel(joinedLabel);
        }
        catch (ANTLRException | IOException e) {
            logger.error("Failed to  set add DiscoveryAssignedNode : " + e.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void addExecutionAssignedNode(FreeStyleProject proj) {
        Computer[] computers = Jenkins.getInstanceOrNull().getComputers();
        HashSet<Object> labels = new HashSet<Object>();
        String assigned = proj.getAssignedLabelString();
        if (assigned != null) {
            String[] stringArray;
            String[] stringArray2 = stringArray = StringUtils.split((String)assigned, (String)"||");
            int n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                String item = stringArray2[i];
                labels.add(item.trim());
            }
        }
        try {
            for (Computer computer : computers) {
                Object label;
                if (computer instanceof Jenkins.MasterComputer || !((String)(label = String.valueOf(computer.getNode().getSelfLabel()))).toLowerCase().contains("uft")) continue;
                label = ((String)label).trim();
                Pattern p = Pattern.compile("[^\\w]");
                Matcher m = p.matcher((CharSequence)label);
                if (m.find()) {
                    label = "\"" + (String)label + "\"";
                }
                labels.add(label);
            }
            if (!labels.isEmpty()) {
                void var4_8;
                boolean parenthesesRequired;
                String string = StringUtils.join(labels, (String)"||");
                boolean bl = parenthesesRequired = labels.stream().filter(l -> l.startsWith("\"")).count() > 1L;
                if (parenthesesRequired) {
                    String string2 = "(" + string + ")";
                }
                proj.setAssignedLabel(Label.parseExpression((String)var4_8));
            }
        }
        catch (ANTLRException | IOException throwable) {
            logger.error("Failed to  set addExecutionAssignedNode : " + throwable.getMessage());
        }
    }

    public static FreeStyleProject createExecutor(DiscoveryInfo discoveryInfo) {
        try {
            TestingToolType testingToolType = discoveryInfo.getTestingToolType();
            String exeJobPrefix = TestingToolType.UFT.equals((Object)testingToolType) ? UftConstants.UFT_EXECUTION_JOB_MIDDLE_NAME_WITH_TEST_RUNNERS_NEW : UftConstants.MBT_EXECUTION_JOB_MIDDLE_NAME_WITH_TEST_RUNNERS_NEW;
            String projectName = String.format("%s-%s-%s", exeJobPrefix, discoveryInfo.getExecutorId(), discoveryInfo.getExecutorLogicalName().substring(0, 5));
            FreeStyleProject proj = TestExecutionJobCreatorService.createProject(discoveryInfo.getConfigurationId(), projectName);
            proj.setDescription(String.format("This job was created by the OpenText Application Automation Tools plugin for running UFT tests. It is associated with Software Delivery Management test runner #%s.", discoveryInfo.getExecutorId()));
            TestExecutionJobCreatorService.setScmRepository(discoveryInfo.getScmRepository(), discoveryInfo.getScmRepositoryCredentialsId(), proj, true);
            TestExecutionJobCreatorService.addStringParameter(proj, "testsToRun", "", "Tests to run");
            TestExecutionJobCreatorService.addStringParameter(proj, "testsToRunCheckoutDirectory", "${WORKSPACE}\\${CHECKOUT_SUBDIR}", "Shared UFT directory");
            TestExecutionJobCreatorService.addConstantParameter(proj, "Test Runner ID", discoveryInfo.getExecutorId(), "Software Delivery Management test runner ID");
            TestExecutionJobCreatorService.addConstantParameter(proj, "Test Runner logical name", discoveryInfo.getExecutorLogicalName(), "Software Delivery Management test runner logical name");
            TestExecutionJobCreatorService.addStringParameter(proj, "suiteId", "", "Software Delivery Management test suite ID");
            TestExecutionJobCreatorService.addStringParameter(proj, "suiteRunId", "", "The ID of the Software Delivery Management test suite run to associate with the test run results.");
            TestExecutionJobCreatorService.addExecutionAssignedNode(proj);
            TestExecutionJobCreatorService.addTimestamper(proj);
            TestExecutionJobCreatorService.addConcurrentBuildFlag(proj);
            TestsToRunFramework framework = TestingToolType.UFT.equals((Object)testingToolType) ? TestsToRunFramework.MF_UFT : TestsToRunFramework.MF_MBT;
            TestsToRunConverterBuilder converterBuilder = new TestsToRunConverterBuilder(framework.value());
            RunFromFileBuilder uftRunner = new RunFromFileBuilder("${testsToRunConverted}");
            boolean isMbt = testingToolType.equals((Object)TestingToolType.MBT);
            proj.getBuildersList().add((Object)converterBuilder);
            proj.getBuildersList().add((Object)uftRunner);
            if (isMbt) {
                proj.getBuildersList().add((Object)new RunFromCodelessBuilder());
            }
            RunResultRecorder runResultRecorder = null;
            DescribableList publishers = proj.getPublishersList();
            for (Object publisher : publishers) {
                if (!(publisher instanceof RunResultRecorder)) continue;
                runResultRecorder = (RunResultRecorder)publisher;
            }
            if (runResultRecorder == null) {
                runResultRecorder = new RunResultRecorder(ResultsPublisherModel.alwaysArchiveResults.getValue());
                publishers.add(runResultRecorder);
            }
            return proj;
        }
        catch (IOException e) {
            logger.error("Failed to create executor job : " + e.getMessage());
            return null;
        }
    }

    private static void addConcurrentBuildFlag(FreeStyleProject proj) throws IOException {
        proj.setConcurrentBuild(true);
    }
}

