/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.events;

import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.dto.scm.SCMData;
import com.microfocus.application.automation.tools.octane.model.processors.scm.SCMProcessors;
import com.microfocus.application.automation.tools.octane.model.processors.scm.SCMUtils;
import com.microfocus.application.automation.tools.octane.tests.build.BuildHandlerUtils;
import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.SCMListener;
import hudson.scm.ChangeLogSet;
import hudson.scm.SCM;

@Extension
public class SCMListenerOctaneImpl
extends SCMListener {
    public void onChangeLogParsed(Run<?, ?> run, SCM scm, TaskListener listener, ChangeLogSet<?> changelog) throws Exception {
        if (!OctaneSDK.hasClients()) {
            return;
        }
        super.onChangeLogParsed(run, scm, listener, changelog);
        String jobCiId = BuildHandlerUtils.getJobCiId(run);
        String buildCiId = BuildHandlerUtils.getBuildCiId(run);
        SCMData scmData = SCMUtils.extractSCMData(run, scm, SCMProcessors.getAppropriate(scm.getClass().getName()));
        if (scmData != null) {
            String parents = BuildHandlerUtils.getRootJobCiIds(run);
            SCMUtils.persistSCMData(run, jobCiId, buildCiId, scmData);
            OctaneSDK.getClients().forEach(octaneClient -> octaneClient.getSCMDataService().enqueueSCMData(jobCiId, buildCiId, scmData, parents));
        }
    }
}

