/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.configuration;

import com.microfocus.application.automation.tools.octane.configuration.SDKBasedLoggerProvider;
import hudson.model.Action;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.logging.log4j.Logger;

public class ReflectionUtils {
    private static final Logger logger = SDKBasedLoggerProvider.getLogger(ReflectionUtils.class);

    public static <T> T getFieldValue(Object someObject, String fieldName) {
        for (Field field : someObject.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            if (!field.getName().equals(fieldName)) continue;
            Object value = null;
            try {
                value = field.get(someObject);
            }
            catch (IllegalAccessException e) {
                logger.error("Failed to getFieldValue", (Throwable)e);
            }
            if (value == null) continue;
            return (T)value;
        }
        return null;
    }

    public static Object invokeMethodByName(Action action, String methodName, Object ... args) throws InvocationTargetException, IllegalAccessException {
        Method method = ReflectionUtils.getMethodByName(action, methodName);
        return method.invoke((Object)action, args);
    }

    public static Method getMethodByName(Action action, String methodName) {
        Method method = Arrays.stream(action.getClass().getDeclaredMethods()).filter(m -> m.getName().equals(methodName)).findFirst().orElse(null);
        return method;
    }
}

