/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.actions.cucumber;

import com.microfocus.application.automation.tools.octane.Messages;
import hudson.FilePath;
import hudson.Util;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import jenkins.MasterToSlaveFileCallable;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;

public class CucumberResultsService {
    public static final String GHERKIN_NGA_RESULTS_XML = "OctaneGherkinResults.xml";
    public static final String GHERKIN_NGA_RESULTS = "OctaneGherkinResults";
    public static final String DEFAULT_GLOB = "**/*OctaneGherkinResults.xml";
    private static TaskListener listener;

    public static String getGherkinResultFileName(int index) {
        return GHERKIN_NGA_RESULTS + index + ".xml";
    }

    public static String[] getCucumberResultFiles(FilePath workspace, String glob) throws IOException, InterruptedException {
        if (glob == null || glob.isEmpty()) {
            glob = DEFAULT_GLOB;
            CucumberResultsService.log(Messages.CucumberResultsActionEmptyConfiguration(), glob);
        }
        CucumberResultsService.log("Looking for files that match the pattern %s in root directory %s", glob, workspace.getName());
        return (String[])workspace.act((FilePath.FileCallable)new ResultFilesCallable(glob));
    }

    public static void copyResultFile(File resultFile, File destinationFolder, FilePath workspace) throws IOException, InterruptedException {
        File existingReportFile;
        int existingResultIndex = -1;
        CucumberResultsService.log("Copying %s to %s", resultFile.getPath(), destinationFolder.getPath());
        while ((existingReportFile = new File(destinationFolder, CucumberResultsService.getGherkinResultFileName(++existingResultIndex))).exists()) {
        }
        CucumberResultsService.log("New file name on destination will be %s", existingReportFile.getPath());
        byte[] content = (byte[])workspace.act((FilePath.FileCallable)new FileContentCallable(resultFile));
        CucumberResultsService.log("Got result file content", new String[0]);
        CucumberResultsService.validateContent(content);
        File target = existingReportFile;
        try (FileOutputStream os = new FileOutputStream(target);){
            os.write(content);
        }
        CucumberResultsService.log("Result file copied to %s", target.getPath());
    }

    private static void validateContent(byte[] content) {
        String contentStr = new String(content, 0, Math.min(content.length, 2000));
        if (!contentStr.contains("<features")) {
            throw new IllegalArgumentException("The file is not Octane Gherkin results file");
        }
    }

    public static void log(String message, String ... stringFormatArgs) {
        if (listener != null) {
            listener.getLogger().println(String.format("%s: %s", Messages.CucumberReporterName(), String.format(message, stringFormatArgs)));
        }
    }

    public static void setListener(TaskListener l) {
        listener = l;
    }

    private static final class ResultFilesCallable
    extends MasterToSlaveFileCallable<String[]> {
        private final String glob;

        private ResultFilesCallable(String glob) {
            this.glob = glob;
        }

        public String[] invoke(File rootDir, VirtualChannel channel) throws IOException {
            FileSet fs = Util.createFileSet((File)rootDir, (String)this.glob);
            DirectoryScanner ds = fs.getDirectoryScanner();
            return ds.getIncludedFiles();
        }
    }

    private static final class FileContentCallable
    extends MasterToSlaveFileCallable<byte[]> {
        private final File file;

        private FileContentCallable(File file) {
            this.file = file;
        }

        public byte[] invoke(File rootDir, VirtualChannel channel) throws IOException {
            return Files.readAllBytes(this.file.toPath());
        }
    }
}

