/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.actions;

import com.hp.octane.integrations.uft.items.AutomatedTest;
import com.hp.octane.integrations.uft.items.OctaneStatus;
import com.hp.octane.integrations.uft.items.SupportsOctaneStatus;
import com.hp.octane.integrations.uft.items.UftTestAction;
import com.hp.octane.integrations.uft.items.UftTestDiscoveryResult;
import com.hp.octane.integrations.uft.items.UftTestParameter;
import com.microfocus.application.automation.tools.octane.Messages;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Run;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class UFTActionDetectionBuildAction
implements Action {
    private AbstractBuild<?, ?> build;
    private UftTestDiscoveryResult results;
    private List<UftTestAction> actions;
    private Map<String, List<UftTestParameter>> actionToParametersMap;
    private List<UftTestParameter> parameters;

    public UFTActionDetectionBuildAction(AbstractBuild<?, ?> build, UftTestDiscoveryResult results) {
        this.build = build;
        this.setResults(results);
    }

    private List<? extends SupportsOctaneStatus> getItemsWithStatus(List<? extends SupportsOctaneStatus> entities, OctaneStatus status) {
        return entities.stream().filter(item -> status.equals((Object)item.getOctaneStatus())).collect(Collectors.toList());
    }

    private List<UftTestAction> flattenActions(UftTestDiscoveryResult results) {
        return results.getAllTests().stream().map(AutomatedTest::getActions).flatMap(Collection::stream).filter(action -> !action.getOctaneStatus().equals((Object)OctaneStatus.NONE)).collect(Collectors.toList());
    }

    private List<UftTestParameter> flattenParameters(List<UftTestAction> actions) {
        return actions.stream().map(UftTestAction::getParameters).flatMap(Collection::stream).filter(parameter -> !parameter.getOctaneStatus().equals((Object)OctaneStatus.NONE)).collect(Collectors.toList());
    }

    private Map<String, List<UftTestParameter>> setActionToParametersMap() {
        return this.actions.stream().filter(action -> CollectionUtils.isNotEmpty((Collection)action.getParameters())).collect(Collectors.toMap(UftTestAction::getRepositoryPath, UftTestAction::getParameters));
    }

    public String getIconFileName() {
        return "notepad.png";
    }

    public String getDisplayName() {
        return Messages.UFTActionDetectionBuildActionConfigurationLabel();
    }

    public String getUrlName() {
        return "uft_report";
    }

    public final Run<?, ?> getBuild() {
        return this.build;
    }

    public UftTestDiscoveryResult getResults() {
        return this.results;
    }

    public void setResults(UftTestDiscoveryResult results) {
        this.results = results;
        this.init(results);
    }

    public List<UftTestAction> getActions() {
        return this.actions;
    }

    public void setActions(List<UftTestAction> actions) {
        this.actions = actions;
    }

    public boolean getHasNewActions() {
        return this.getNewActions().size() > 0;
    }

    public List<UftTestAction> getNewActions() {
        return this.getItemsWithStatus(this.actions, OctaneStatus.NEW);
    }

    public boolean getHasDeletedActions() {
        return this.getDeletedActions().size() > 0;
    }

    public List<UftTestAction> getDeletedActions() {
        return this.getItemsWithStatus(this.actions, OctaneStatus.DELETED);
    }

    public boolean getHasUpdatedActions() {
        return this.getUpdatedActions().size() > 0;
    }

    public List<UftTestAction> getUpdatedActions() {
        return this.getItemsWithStatus(this.actions, OctaneStatus.MODIFIED);
    }

    public boolean getHasNewParameters() {
        return this.getNewParameters().size() > 0;
    }

    public List<UftTestParameter> getNewParameters() {
        return this.getItemsWithStatus(this.parameters, OctaneStatus.NEW);
    }

    public boolean getHasDeletedParameters() {
        return this.getDeletedParameters().size() > 0;
    }

    public List<UftTestParameter> getDeletedParameters() {
        return this.getItemsWithStatus(this.parameters, OctaneStatus.DELETED);
    }

    public boolean getHasUpdatedParameters() {
        return this.getUpdatedParameters().size() > 0;
    }

    public List<UftTestParameter> getUpdatedParameters() {
        return this.getItemsWithStatus(this.parameters, OctaneStatus.MODIFIED);
    }

    public boolean getHasQuotedPaths() {
        return this.results.isHasQuotedPaths();
    }

    public Map<String, List<UftTestParameter>> getActionToParametersMap() {
        return this.actionToParametersMap;
    }

    private void init(UftTestDiscoveryResult results) {
        boolean isEmptyResults;
        boolean bl = isEmptyResults = results == null;
        if (isEmptyResults) {
            this.results = new UftTestDiscoveryResult();
            this.actions = Collections.emptyList();
            this.actionToParametersMap = Collections.emptyMap();
            this.parameters = Collections.emptyList();
        } else {
            this.actions = this.flattenActions(results);
            this.actionToParametersMap = this.setActionToParametersMap();
            this.parameters = this.flattenParameters(this.actions);
        }
    }
}

