/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.actions;

import com.hp.octane.integrations.OctaneClient;
import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.dto.general.CIServerInfo;
import com.hp.octane.integrations.services.configuration.ConfigurationService;
import com.microfocus.application.automation.tools.octane.CIJenkinsServicesImpl;
import hudson.Extension;
import hudson.model.RootAction;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.http.entity.ContentType;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@Extension
public class PluginActions
implements RootAction {
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String API = "/nga/api/v1";
    private static final String STATUS_REQUEST = "/nga/api/v1/status";
    private static final String REENQUEUE_EVENT_REQUEST = "/nga/api/v1/reenqueue";
    private static final String CLEAR_JOB_LIST_CACHE = "/nga/api/v1/clear-job-list-cache";
    private static final String CLEAR_OCTANE_ROOTS_CACHE = "/nga/api/v1/clear-octane-roots-cache";
    private static final String OCTANE_ROOTS_CACHE = "/nga/api/v1/octane-roots-cache";
    private static final String INSTANCE_ID_PARAM = "instanceId";
    private final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "nga";
    }

    public void doDynamic(StaplerRequest req, StaplerResponse res) throws IOException {
        Jenkins.get().checkPermission(Jenkins.READ);
        res.setHeader(CONTENT_TYPE, ContentType.TEXT_PLAIN.getMimeType());
        res.setStatus(200);
        if (req.getRequestURI().toLowerCase().contains(STATUS_REQUEST)) {
            JSONObject result = this.getStatusResult(req.getParameterMap());
            res.setHeader(CONTENT_TYPE, ContentType.APPLICATION_JSON.getMimeType());
            res.getWriter().write(result.toString());
        } else if (req.getRequestURI().toLowerCase().contains(REENQUEUE_EVENT_REQUEST)) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            this.reEnqueueEvent(req.getParameterMap());
            res.getWriter().write("resent");
        } else if (req.getRequestURI().toLowerCase().contains(CLEAR_JOB_LIST_CACHE)) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            this.resetJobListCache();
            res.getWriter().write("done");
        } else if (req.getRequestURI().toLowerCase().contains(CLEAR_OCTANE_ROOTS_CACHE)) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            this.resetOctaneRootsCache();
            res.getWriter().write("done");
        } else if (req.getRequestURI().toLowerCase().contains(OCTANE_ROOTS_CACHE)) {
            JSONObject result = this.readOctaneRootsCache();
            res.getWriter().write(result.toString());
        } else {
            res.setStatus(404);
            res.getWriter().write("");
        }
    }

    private JSONObject getStatusResult(Map<String, String[]> parameterMap) {
        JSONObject sdkJson = new JSONObject();
        sdkJson.put("sdkVersion", (Object)OctaneSDK.SDK_VERSION);
        JSONObject pluginJson = new JSONObject();
        pluginJson.put("version", (Object)com.microfocus.application.automation.tools.octane.configuration.ConfigurationService.getPluginVersion());
        JSONObject serverInfoJson = new JSONObject();
        CIServerInfo serverInfo = CIJenkinsServicesImpl.getJenkinsServerInfo();
        serverInfoJson.put("type", (Object)serverInfo.getType());
        serverInfoJson.put("version", (Object)serverInfo.getVersion());
        serverInfoJson.put("url", (Object)serverInfo.getUrl());
        serverInfoJson.put("currentTime", (Object)this.format.format(new Date()));
        JSONObject result = new JSONObject();
        result.put("sdk", (Object)sdkJson);
        result.put("plugin", (Object)pluginJson);
        result.put("server", (Object)serverInfoJson);
        if (parameterMap.containsKey("metrics")) {
            JSONObject allMetricsJson = new JSONObject();
            OctaneSDK.getClients().forEach(client -> {
                JSONObject confJson = new JSONObject();
                this.addMetrics(client.getMetrics(), "client", confJson);
                this.addMetrics(client.getBridgeService().getMetrics(), "taskPollingService", confJson);
                this.addMetrics(client.getEventsService().getMetrics(), "eventsService", confJson);
                this.addMetrics(client.getTestsService().getMetrics(), "testsService", confJson);
                this.addMetrics(client.getLogsService().getMetrics(), "buildLogsService", confJson);
                this.addMetrics(client.getVulnerabilitiesService().getMetrics(), "vulnerabilitiesService", confJson);
                this.addMetrics(client.getSonarService().getMetrics(), "sonarService", confJson);
                this.addMetrics(client.getCoverageService().getMetrics(), "coverageService", confJson);
                this.addMetrics(client.getSCMDataService().getMetrics(), "scmDataService", confJson);
                this.addMetrics(client.getTasksProcessor().getMetrics(), "tasksProcessor", confJson);
                this.addMetrics(client.getConfigurationService().getMetrics(), "configurationService", confJson);
                this.addMetrics(client.getRestService().obtainOctaneRestClient().getMetrics(), "restClient", confJson);
                allMetricsJson.put(client.getConfigurationService().getConfiguration().getLocationForLog(), (Object)confJson);
            });
            result.put("metrics", (Object)allMetricsJson);
        }
        return result;
    }

    private void addMetrics(Map<String, Object> metrics, String metricsGroup, JSONObject confJson) {
        JSONObject metricsJson = new JSONObject();
        metrics.entrySet().forEach(e -> {
            String value = e.getValue() instanceof Date ? this.format.format(e.getValue()) : e.getValue().toString();
            metricsJson.put((String)e.getKey(), (Object)value);
        });
        confJson.put(metricsGroup, (Object)metricsJson);
    }

    private void resetJobListCache() {
        OctaneSDK.getClients().stream().forEach(oc -> oc.getTasksProcessor().resetJobListCache());
    }

    private void resetOctaneRootsCache() {
        OctaneSDK.getClients().stream().forEach(oc -> oc.getConfigurationService().resetOctaneRootsCache());
    }

    private JSONObject readOctaneRootsCache() {
        JSONObject result = new JSONObject();
        OctaneSDK.getClients().forEach(client -> {
            ConfigurationService cs = client.getConfigurationService();
            result.put(cs.getConfiguration().getLocationForLog(), (Object)cs.getOctaneRootsCacheCollection());
        });
        return result;
    }

    private void reEnqueueEvent(Map<String, String[]> parameterMap) {
        if (!parameterMap.containsKey(INSTANCE_ID_PARAM)) {
            throw new IllegalArgumentException("instanceId parameter is missing");
        }
        if (!parameterMap.containsKey("eventType")) {
            throw new IllegalArgumentException("eventType parameter is missing");
        }
        if (!parameterMap.containsKey("jobId")) {
            throw new IllegalArgumentException("jobId parameter is missing");
        }
        if (!parameterMap.containsKey("buildId")) {
            throw new IllegalArgumentException("buildId parameter is missing");
        }
        String instanceId = parameterMap.get(INSTANCE_ID_PARAM)[0];
        String eventType = parameterMap.get("eventType")[0];
        String jobId = parameterMap.get("jobId")[0];
        String buildId = parameterMap.get("buildId")[0];
        String rootId = null;
        if (parameterMap.containsKey("rootId")) {
            rootId = parameterMap.get("rootId")[0];
        }
        OctaneClient octaneClient = OctaneSDK.getClientByInstanceId((String)instanceId);
        if ("tests".equals(eventType.toLowerCase())) {
            octaneClient.getTestsService().enqueuePushTestsResult(jobId, buildId, rootId);
        } else if ("commits".equals(eventType.toLowerCase())) {
            octaneClient.getSCMDataService().enqueueSCMData(jobId, buildId, null, null);
        }
    }
}

