/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.actions;

import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.dto.coverage.CoverageReportType;
import com.microfocus.application.automation.tools.octane.Messages;
import com.microfocus.application.automation.tools.octane.actions.coverage.CoveragePublisherAction;
import com.microfocus.application.automation.tools.octane.tests.build.BuildHandlerUtils;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class CoveragePublisher
extends Recorder
implements SimpleBuildStep {
    private final String jacocoPathPattern;
    private final String lcovPathPattern;

    @DataBoundConstructor
    public CoveragePublisher(String jacocoPathPattern, String lcovPathPattern) {
        this.jacocoPathPattern = jacocoPathPattern == null || jacocoPathPattern.isEmpty() ? "**/target/site/*/jacoco.xml" : jacocoPathPattern;
        this.lcovPathPattern = lcovPathPattern == null || lcovPathPattern.isEmpty() ? "**/coverage/lcov.info" : lcovPathPattern;
    }

    public String getJacocoPathPattern() {
        return this.jacocoPathPattern;
    }

    public String getLcovPathPattern() {
        return this.lcovPathPattern;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath filePath, @Nonnull Launcher launcher, @Nonnull TaskListener taskListener) throws InterruptedException, IOException {
        boolean isSuccessful = this.perform(run, taskListener);
        if (!isSuccessful) {
            run.setResult(Result.FAILURE);
        }
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        return this.perform((Run)build, (TaskListener)listener);
    }

    public boolean perform(Run build, TaskListener listener) {
        CoveragePublisherAction action = new CoveragePublisherAction(build, listener);
        build.addAction((Action)action);
        List<String> jacocoReportFileNames = action.copyCoverageReportsToBuildFolder(this.jacocoPathPattern, "jacoco.xml");
        List<String> lcovReportFileNames = action.copyCoverageReportsToBuildFolder(this.lcovPathPattern, "lcov.info");
        boolean copyReportsToBuildFolderStatus = this.enqueueReports(build, jacocoReportFileNames, CoverageReportType.JACOCOXML) || this.enqueueReports(build, lcovReportFileNames, CoverageReportType.LCOV);
        return copyReportsToBuildFolderStatus;
    }

    private boolean enqueueReports(Run build, List<String> reportFileNames, CoverageReportType coverageReportType) {
        if (!reportFileNames.isEmpty()) {
            String parents = BuildHandlerUtils.getRootJobCiIds(build);
            OctaneSDK.getClients().forEach(octaneClient -> {
                for (String reportFileName : reportFileNames) {
                    octaneClient.getCoverageService().enqueuePushCoverage(BuildHandlerUtils.getJobCiId(build), String.valueOf(build.getNumber()), coverageReportType, reportFileName, parents);
                }
            });
            return true;
        }
        return false;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @Symbol(value={"publishCodeCoverage"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Software Delivery Management code coverage publisher";
        }

        public FormValidation doCheckJacocoPathPattern(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException {
            if (value == null || value.isEmpty()) {
                return FormValidation.warning((String)Messages.CoverageResultsActionEmptyConfigurationWarning(), (Object[])new Object[]{"**/target/site/*/jacoco.xml"});
            }
            if (project == null) {
                return FormValidation.ok();
            }
            return FilePath.validateFileMask((FilePath)project.getSomeWorkspace(), (String)value);
        }

        public FormValidation doCheckLcovPathPattern(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException, ServletException {
            if (value == null || value.isEmpty()) {
                return FormValidation.warning((String)Messages.CoverageResultsActionEmptyConfigurationWarning(), (Object[])new Object[]{"**/coverage/lcov.info"});
            }
            if (project == null) {
                return FormValidation.ok();
            }
            return FilePath.validateFileMask((FilePath)project.getSomeWorkspace(), (String)value);
        }
    }
}

