/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.hp.octane.integrations.services.pullrequestsandbranches.PullRequestAndBranchService;
import com.hp.octane.integrations.services.pullrequestsandbranches.factory.FetchHandler;
import com.hp.octane.integrations.services.pullrequestsandbranches.factory.RepoTemplates;
import com.hp.octane.integrations.services.pullrequestsandbranches.rest.authentication.AuthenticationStrategy;
import com.hp.octane.integrations.services.pullrequestsandbranches.rest.authentication.BasicAuthenticationStrategy;
import com.hp.octane.integrations.services.pullrequestsandbranches.rest.authentication.NoCredentialsStrategy;
import com.hp.octane.integrations.services.pullrequestsandbranches.rest.authentication.PATStrategy;
import hudson.model.Run;
import hudson.model.User;
import hudson.util.Secret;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import java.util.function.Consumer;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

public class GitFetchUtils {
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm";

    private GitFetchUtils() {
    }

    public static SimpleDateFormat generateDateFormat() {
        SimpleDateFormat temp = new SimpleDateFormat(DATE_TIME_FORMAT);
        TimeZone utc = TimeZone.getTimeZone("UTC");
        temp.setTimeZone(utc);
        return temp;
    }

    public static String getUserIdForCommit(String email, String login) {
        User user;
        if (login != null && (user = User.get((String)login, (boolean)false, Collections.emptyMap())) != null) {
            return user.getId();
        }
        if (email != null && email.contains("@")) {
            String[] emailParts = email.split("@");
            return emailParts[0];
        }
        return login;
    }

    public static StandardCredentials getCredentialsById(String credentialsId, Run<?, ?> run, PrintStream logger) {
        StandardCredentials credentials = null;
        if (!StringUtils.isEmpty((String)credentialsId) && (credentials = (StandardCredentials)CredentialsProvider.findCredentialById((String)credentialsId, StandardCredentials.class, run, (List)URIRequirementBuilder.create().build())) == null) {
            logger.println("Can not find credentials with the credentialsId:" + credentialsId);
        }
        return credentials;
    }

    public static AuthenticationStrategy getAuthenticationStrategy(StandardCredentials credentials) {
        NoCredentialsStrategy authenticationStrategy;
        if (credentials == null) {
            authenticationStrategy = new NoCredentialsStrategy();
        } else if (credentials instanceof StringCredentials) {
            Secret secret = ((StringCredentials)credentials).getSecret();
            authenticationStrategy = new PATStrategy(secret.getPlainText());
        } else if (credentials instanceof StandardUsernamePasswordCredentials) {
            StandardUsernamePasswordCredentials cr = (StandardUsernamePasswordCredentials)credentials;
            authenticationStrategy = new BasicAuthenticationStrategy(cr.getUsername(), cr.getPassword().getPlainText());
        } else {
            throw new IllegalArgumentException("Credentials type is not supported : " + credentials.getClass().getCanonicalName());
        }
        return authenticationStrategy;
    }

    public static String getCredentialsPassword(StandardCredentials credentials) {
        if (credentials == null) {
            return "";
        }
        if (credentials instanceof StringCredentials) {
            return ((StringCredentials)credentials).getSecret().getPlainText();
        }
        if (credentials instanceof StandardUsernamePasswordCredentials) {
            return ((StandardUsernamePasswordCredentials)credentials).getPassword().getPlainText();
        }
        return "";
    }

    public static void updateRepoTemplates(PullRequestAndBranchService pullRequestAndBranchService, FetchHandler fetcherHandler, String repoHttpUrlForTemplates, String repoUrlForOctane, Long workspaceId, Consumer<String> logConsumer) {
        try {
            RepoTemplates repoTemplates = fetcherHandler.buildRepoTemplates(repoHttpUrlForTemplates);
            if (pullRequestAndBranchService.updateRepoTemplates(repoUrlForOctane, workspaceId, repoTemplates)) {
                logConsumer.accept("Repo template are updated successfully in Software Delivery Management");
            }
        }
        catch (Exception e) {
            logConsumer.accept("Failed to update repo templates : " + e.getMessage());
        }
    }
}

