/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.model;

import com.microfocus.application.automation.tools.model.SvDataModelSelection;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class SvPerformanceModelSelection
extends AbstractDescribableImpl<SvPerformanceModelSelection>
implements Serializable {
    protected final SelectionType selectionType;
    protected final String performanceModel;

    @DataBoundConstructor
    public SvPerformanceModelSelection(SelectionType selectionType, String performanceModel) {
        this.selectionType = selectionType;
        this.performanceModel = StringUtils.trim((String)performanceModel);
    }

    public SelectionType getSelectionType() {
        return this.selectionType;
    }

    public String getPerformanceModel() {
        return StringUtils.isNotBlank((String)this.performanceModel) ? this.performanceModel : null;
    }

    public boolean isSelected(String type) {
        return SelectionType.valueOf(type) == this.selectionType;
    }

    public boolean isNoneSelected() {
        return this.selectionType == SelectionType.NONE;
    }

    public boolean isDefaultSelected() {
        return this.selectionType == SelectionType.DEFAULT;
    }

    public String toString() {
        switch (this.selectionType.ordinal()) {
            case 0: {
                return this.performanceModel;
            }
            case 1: {
                return "<none>";
            }
            case 2: {
                return "<offline>";
            }
        }
        return "<default>";
    }

    public String getSelectedModelName() {
        switch (this.selectionType.ordinal()) {
            case 0: {
                SvDataModelSelection.validateField(DescriptorImpl.doCheckPerformanceModelImpl(this.performanceModel));
                return this.performanceModel;
            }
            case 2: {
                return "Offline";
            }
        }
        return null;
    }

    public static enum SelectionType {
        BY_NAME,
        NONE,
        OFFLINE,
        DEFAULT;

    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<SvPerformanceModelSelection> {
        @Nonnull
        public String getDisplayName() {
            return "Performance Model Selection";
        }

        public FormValidation doCheckPerformanceModel(@QueryParameter String performanceModel) {
            return DescriptorImpl.doCheckPerformanceModelImpl(performanceModel);
        }

        private static FormValidation doCheckPerformanceModelImpl(@QueryParameter String performanceModel) {
            if (StringUtils.isBlank((String)performanceModel)) {
                return FormValidation.error((String)"Performance model cannot be empty if 'Specific' model is selected");
            }
            return FormValidation.ok();
        }
    }
}

