/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.model;

import com.microfocus.application.automation.tools.model.CdaDetails;
import com.microfocus.application.automation.tools.model.EnumDescription;
import com.microfocus.application.automation.tools.model.SecretContainer;
import com.microfocus.application.automation.tools.model.SecretContainerImpl;
import java.util.Arrays;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

public class SseModel {
    public static final String TEST_SET = "TEST_SET";
    public static final String BVS = "BVS";
    public static final String PC = "PC";
    public static final String COLLATE = "Collate";
    public static final String COLLATE_ANALYZE = "CollateAndAnalyze";
    public static final String DO_NOTHING = "DoNothing";
    private final String _almServerName;
    private String _almServerUrl;
    private final String _almUserName;
    private final SecretContainer _almPassword;
    private final String _almDomain;
    private final String _clientType;
    private final String _almProject;
    private final String _timeslotDuration;
    private final String _description;
    private final String _runType;
    private final String _almEntityId;
    private final String _postRunAction;
    private final String _environmentConfigurationId;
    private final CdaDetails _cdaDetails;
    private static final EnumDescription _runTypeTestSet = new EnumDescription("TEST_SET", "Test Set");
    private static final EnumDescription _runTypeBVS = new EnumDescription("BVS", "Build Verification Suite");
    private static final List<EnumDescription> _runTypes = Arrays.asList(_runTypeTestSet, _runTypeBVS);
    private static final EnumDescription _postRunActionCollate = new EnumDescription("Collate", "Collate");
    private static final EnumDescription _postRunActionCollateAnalyze = new EnumDescription("CollateAndAnalyze", "CollateAndAnalyze");
    private static final EnumDescription _postRunActionDoNothing = new EnumDescription("DoNothing", "DoNothing");
    private static final List<EnumDescription> _postRunActions = Arrays.asList(_postRunActionCollate, _postRunActionCollateAnalyze, _postRunActionDoNothing);

    @DataBoundConstructor
    public SseModel(String almServerName, String almUserName, String almPassword, String almDomain, String clientType, String almProject, String runType, String almEntityId, String timeslotDuration, String description, String postRunAction, String environmentConfigurationId, CdaDetails cdaDetails) {
        this._almServerName = almServerName;
        this._almDomain = almDomain;
        this._clientType = clientType;
        this._almProject = almProject;
        this._timeslotDuration = timeslotDuration;
        this._almEntityId = almEntityId;
        this._almUserName = almUserName;
        this._almPassword = this.setPassword(almPassword);
        this._runType = runType;
        this._description = description;
        this._postRunAction = postRunAction;
        this._environmentConfigurationId = environmentConfigurationId;
        this._cdaDetails = cdaDetails;
    }

    protected SecretContainer setPassword(String almPassword) {
        SecretContainerImpl secretContainer = new SecretContainerImpl();
        secretContainer.initialize(almPassword);
        return secretContainer;
    }

    public String getAlmServerName() {
        return this._almServerName;
    }

    public String getAlmServerUrl() {
        return this._almServerUrl;
    }

    public void setAlmServerUrl(String almServerUrl) {
        this._almServerUrl = almServerUrl;
    }

    public String getAlmUserName() {
        return this._almUserName;
    }

    public String getAlmPassword() {
        return this._almPassword.toString();
    }

    public String getAlmDomain() {
        return this._almDomain;
    }

    public String getClientType() {
        return this._clientType;
    }

    public String getAlmProject() {
        return this._almProject;
    }

    public String getTimeslotDuration() {
        return this._timeslotDuration;
    }

    public String getAlmEntityId() {
        return this._almEntityId;
    }

    public String getRunType() {
        return this._runType;
    }

    public String getDescription() {
        return this._description;
    }

    public String getEnvironmentConfigurationId() {
        return this._environmentConfigurationId;
    }

    public static List<EnumDescription> getRunTypes() {
        return _runTypes;
    }

    public static List<EnumDescription> getPostRunActions() {
        return _postRunActions;
    }

    public CdaDetails getCdaDetails() {
        return this._cdaDetails;
    }

    public String getPostRunAction() {
        return this._postRunAction;
    }
}

