/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.model;

import com.microfocus.application.automation.tools.model.FileSystemTestModel;
import com.microfocus.application.automation.tools.model.ParallelRunnerEnvironmentModel;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.kohsuke.stapler.DataBoundConstructor;

public class FileSystemTestSetModel
extends AbstractDescribableImpl<FileSystemTestSetModel> {
    private List<FileSystemTestModel> fileSystemTestSet;

    @DataBoundConstructor
    public FileSystemTestSetModel(List<FileSystemTestModel> fileSystemTestSet) {
        this.fileSystemTestSet = fileSystemTestSet;
    }

    public List<FileSystemTestModel> getFileSystemTestSet() {
        return this.fileSystemTestSet;
    }

    private void removeFsTests(Properties props) {
        int current = 1;
        String key = "Test";
        while (props.containsKey(key + current)) {
            props.remove(key + current);
            ++current;
        }
    }

    public void addTestSetProperties(Properties props, EnvVars envVars) {
        props.put("parallelRunnerMode", "true");
        this.removeFsTests(props);
        int testNumber = 1;
        for (FileSystemTestModel testModel : this.fileSystemTestSet) {
            List<String> tests = testModel.parseTests(envVars);
            List<ParallelRunnerEnvironmentModel> environmentModels = testModel.getParallelRunnerEnvironments();
            for (String test : tests) {
                test = test.trim();
                props.put("Test" + testNumber, test);
                int envNumber = 1;
                for (ParallelRunnerEnvironmentModel environment : environmentModels) {
                    props.put("ParallelTest" + testNumber + "Env" + envNumber, environment.getEnvironment());
                    ++envNumber;
                }
                ++testNumber;
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<FileSystemTestSetModel> {
        @Nonnull
        public String getDisplayName() {
            return "File System test set model";
        }
    }
}

