/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.model;

import com.microfocus.application.automation.tools.model.ParallelRunnerEnvironmentModel;
import com.microfocus.application.automation.tools.sse.common.StringUtils;
import com.microfocus.application.automation.tools.uft.utils.UftToolUtils;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import org.kohsuke.stapler.DataBoundConstructor;

public class FileSystemTestModel
extends AbstractDescribableImpl<FileSystemTestModel> {
    private String tests;
    private List<ParallelRunnerEnvironmentModel> parallelRunnerEnvironments;

    @DataBoundConstructor
    public FileSystemTestModel(String tests, List<ParallelRunnerEnvironmentModel> parallelRunnerEnvironments) {
        this.tests = tests;
        this.parallelRunnerEnvironments = parallelRunnerEnvironments;
    }

    public String getTests() {
        if (this.tests == null) {
            this.tests = "\n";
        } else if (!this.tests.contains("\n")) {
            this.tests = this.tests + "\n";
        }
        return this.tests;
    }

    private void setTestsWithNewLine(String tests) {
        this.tests = tests.trim();
        if (!this.tests.contains("\n")) {
            this.tests = this.tests + "\n";
        }
    }

    public List<ParallelRunnerEnvironmentModel> getParallelRunnerEnvironments() {
        return this.parallelRunnerEnvironments;
    }

    public List<String> parseTests(EnvVars envVars) {
        String expandedFsTests = envVars.expand(this.tests);
        List<String> result = new ArrayList<String>();
        if (StringUtils.isNullOrEmpty(this.tests)) {
            return result;
        }
        if (UftToolUtils.isMtbxContent(expandedFsTests)) {
            result.add(expandedFsTests);
        } else {
            result = Arrays.asList(expandedFsTests.replaceAll("\r", "").split("\n"));
        }
        return result;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<FileSystemTestModel> {
        @Nonnull
        public String getDisplayName() {
            return "File system test model";
        }
    }
}

