/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.model;

import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class AutEnvironmentParameterModel
extends AbstractDescribableImpl<AutEnvironmentParameterModel> {
    private final String name;
    private final String value;
    private final String paramType;
    private final boolean shouldGetOnlyFirstValueFromJson;
    private String resolvedValue;
    public static final List<String> parametersTypes = Arrays.asList(AutEnvironmentParameterType.USER_DEFINED.value(), AutEnvironmentParameterType.ENVIRONMENT.value(), AutEnvironmentParameterType.EXTERNAL.value());

    @DataBoundConstructor
    public AutEnvironmentParameterModel(String name, String value, String paramType, boolean shouldGetOnlyFirstValueFromJson) {
        this.name = name;
        this.value = value;
        this.paramType = paramType;
        this.shouldGetOnlyFirstValueFromJson = shouldGetOnlyFirstValueFromJson;
    }

    public boolean isShouldGetOnlyFirstValueFromJson() {
        return this.shouldGetOnlyFirstValueFromJson;
    }

    public String getParamType() {
        return this.paramType;
    }

    public String getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getResolvedValue() {
        return this.resolvedValue;
    }

    public void setResolvedValue(String resolvedValue) {
        this.resolvedValue = resolvedValue;
    }

    public static enum AutEnvironmentParameterType {
        UNDEFINED(""),
        ENVIRONMENT("Environment"),
        EXTERNAL("From JSON"),
        USER_DEFINED("Manual");

        private String value;

        private AutEnvironmentParameterType(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public static AutEnvironmentParameterType get(String val) {
            for (AutEnvironmentParameterType parameterType : AutEnvironmentParameterType.values()) {
                if (!val.equals(parameterType.value())) continue;
                return parameterType;
            }
            return UNDEFINED;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<AutEnvironmentParameterModel> {
        public String getDisplayName() {
            return "AUT Parameter";
        }

        public List<String> getParametersTypes() {
            return parametersTypes;
        }

        public FormValidation doCheckName(@QueryParameter String value) {
            FormValidation ret = FormValidation.ok();
            if (StringUtils.isBlank((String)value)) {
                ret = FormValidation.error((String)"Parameter name must be set");
            }
            return ret;
        }

        public FormValidation doCheckValue(@QueryParameter String value) {
            FormValidation ret = FormValidation.ok();
            if (StringUtils.isBlank((String)value)) {
                ret = FormValidation.warning((String)"You didn't assign any value to this parameter");
            }
            return ret;
        }

        public String getRandomName(@QueryParameter String prefix) {
            return prefix + String.valueOf(UUID.randomUUID());
        }
    }
}

