/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.model;

import com.microfocus.application.automation.tools.JenkinsUtils;
import com.microfocus.application.automation.tools.model.AlmServerSettingsModel;
import com.microfocus.application.automation.tools.model.AutEnvironmentParameterModel;
import com.microfocus.application.automation.tools.model.SecretContainer;
import com.microfocus.application.automation.tools.model.SecretContainerImpl;
import com.microfocus.application.automation.tools.settings.AlmServerSettingsGlobalConfiguration;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class AutEnvironmentModel
extends AbstractDescribableImpl<AutEnvironmentModel> {
    private final String almServerName;
    private String almServerUrl;
    private final String almUserName;
    private final SecretContainer almPassword;
    private final String almDomain;
    private final String almProject;
    private final String clientType;
    private final String autEnvironmentId;
    private final boolean useExistingAutEnvConf;
    private final String existingAutEnvConfId;
    private final boolean createNewAutEnvConf;
    private final String newAutEnvConfName;
    private List<AutEnvironmentParameterModel> autEnvironmentParameters;
    private final String pathToJsonFile;
    private final String outputParameter;

    @DataBoundConstructor
    public AutEnvironmentModel(String almServerName, String almUserName, String almPassword, String almDomain, String almProject, String clientType, String autEnvironmentId, boolean useExistingAutEnvConf, String existingAutEnvConfId, boolean createNewAutEnvConf, String newAutEnvConfName, List<AutEnvironmentParameterModel> autEnvironmentParameters, String pathToJsonFile, String outputParameter) {
        this.almServerName = almServerName;
        this.almUserName = almUserName;
        this.almPassword = this.setPassword(almPassword);
        this.almDomain = almDomain;
        this.almProject = almProject;
        this.clientType = clientType;
        this.autEnvironmentId = autEnvironmentId;
        this.useExistingAutEnvConf = useExistingAutEnvConf;
        this.existingAutEnvConfId = existingAutEnvConfId;
        this.createNewAutEnvConf = createNewAutEnvConf;
        this.newAutEnvConfName = newAutEnvConfName;
        this.autEnvironmentParameters = autEnvironmentParameters;
        this.pathToJsonFile = pathToJsonFile;
        this.outputParameter = outputParameter;
    }

    protected SecretContainer setPassword(String almPassword) {
        SecretContainerImpl secretContainer = new SecretContainerImpl();
        secretContainer.initialize(almPassword);
        return secretContainer;
    }

    public String getPathToJsonFile() {
        return this.pathToJsonFile;
    }

    public boolean isCreateNewAutEnvConf() {
        return this.createNewAutEnvConf;
    }

    public boolean isUseExistingAutEnvConf() {
        return this.useExistingAutEnvConf;
    }

    public String getAlmServerName() {
        return this.almServerName;
    }

    public String getAlmServerUrl() {
        return this.almServerUrl;
    }

    public void setAlmServerUrl(String almServerUrl) {
        this.almServerUrl = almServerUrl;
    }

    public String getAlmUserName() {
        return this.almUserName;
    }

    public String getAlmPassword() {
        return this.almPassword.toString();
    }

    public String getAlmDomain() {
        return this.almDomain;
    }

    public String getAlmProject() {
        return this.almProject;
    }

    public String getClientType() {
        return this.clientType;
    }

    public String getOutputParameter() {
        return this.outputParameter;
    }

    public String getAutEnvironmentId() {
        return this.autEnvironmentId;
    }

    public String getExistingAutEnvConfId() {
        return this.existingAutEnvConfId;
    }

    public String getNewAutEnvConfName() {
        return this.newAutEnvConfName;
    }

    public List<AutEnvironmentParameterModel> getAutEnvironmentParameters() {
        return this.autEnvironmentParameters;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<AutEnvironmentModel> {
        public String getDisplayName() {
            return "UFT ALM AUT Environment Preparation Model";
        }

        public AlmServerSettingsModel[] getAlmServers() {
            return AlmServerSettingsGlobalConfiguration.getInstance().getInstallations();
        }

        public FormValidation doCheckAlmUserName(@QueryParameter String value) {
            return this.generalCheckWithError(value, "User name must be set");
        }

        public FormValidation doCheckAlmDomain(@QueryParameter String value) {
            return this.generalCheckWithError(value, "Domain must be set");
        }

        public FormValidation doCheckAlmProject(@QueryParameter String value) {
            return this.generalCheckWithError(value, "Project must be set");
        }

        public FormValidation doCheckAutEnvironmentId(@QueryParameter String value) {
            return this.generalCheckWithError(value, "AUT Environment ID must be set");
        }

        public FormValidation doCheckAlmPassword(@QueryParameter String value) {
            FormValidation ret = FormValidation.ok();
            if (StringUtils.isBlank((String)value)) {
                ret = FormValidation.warning((String)"Password for ALM server is empty");
            }
            return ret;
        }

        public FormValidation doCheckOutputParameter(@QueryParameter String value) {
            FormValidation ret = FormValidation.ok();
            if (StringUtils.isBlank((String)value)) {
                ret = FormValidation.warning((String)"AUT Environment Configuration ID isn't assigned to any environment variable");
            }
            return ret;
        }

        private FormValidation generalCheckWithError(String value, String errorMessage) {
            FormValidation ret = FormValidation.ok();
            if (StringUtils.isBlank((String)value)) {
                ret = FormValidation.error((String)errorMessage);
            }
            return ret;
        }

        public boolean getHasConfigurePermission() {
            return JenkinsUtils.hasItemConfigurePermission();
        }
    }
}

