/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.mc;

import java.util.regex.Pattern;
import net.minidev.json.JSONObject;
import org.apache.commons.lang.StringUtils;

public class Oauth2TokenUtil {
    private static String client;
    private static String secret;
    private static String tenant;

    private Oauth2TokenUtil() {
    }

    public static boolean isValid(String auth2) {
        String[] a;
        String strCleaned = Oauth2TokenUtil.removeQuotes(auth2.trim());
        if (StringUtils.isBlank((String)strCleaned)) {
            return false;
        }
        for (String s : a = strCleaned.split(Pattern.quote(";"))) {
            if (StringUtils.isEmpty((String)s) || Oauth2TokenUtil.extractField(s.trim())) continue;
            return false;
        }
        return true;
    }

    private static String removeQuotes(String str) {
        if (str.endsWith("\"") && str.startsWith("\"") && str.length() > 1) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    private static boolean extractField(String str) {
        int pos = str.indexOf(61);
        if (pos < 0) {
            return false;
        }
        String key = str.substring(0, pos).trim();
        String value = str.substring(pos + 1).trim();
        if ("client".equalsIgnoreCase(key)) {
            client = value;
        } else if ("secret".equalsIgnoreCase(key)) {
            secret = value;
        } else if ("tenant".equalsIgnoreCase(key)) {
            tenant = value;
        } else {
            return false;
        }
        return true;
    }

    public static JSONObject getJSONObject() {
        JSONObject sendObject = new JSONObject();
        sendObject.put((Object)"client", (Object)client);
        sendObject.put((Object)"secret", (Object)secret);
        sendObject.put((Object)"tenant", (Object)tenant);
        return sendObject;
    }
}

