/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.commonResultUpload.uploader;

import com.microfocus.application.automation.tools.commonResultUpload.uploader.StepBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class UploaderHelper {
    private String stepMessage;
    private String regEx;
    private Map<String, String> stepStatus;

    public UploaderHelper(String stepMessage, String regEx, Map<String, String> stepStatus) {
        this.stepMessage = stepMessage;
        this.regEx = regEx;
        this.stepStatus = stepStatus;
    }

    public List<StepBean> parseMessage() {
        LinkedHashMap<String, String> stepToActualValue = new LinkedHashMap<String, String>();
        HashMap<String, String> stepToStatus = new HashMap<String, String>();
        Pattern pattern = Pattern.compile(this.regEx, 8);
        Matcher matcher = pattern.matcher(this.stepMessage);
        while (matcher.find()) {
            String status = matcher.group(1);
            String step = matcher.group(2);
            if (StringUtils.isEmpty((String)status) || StringUtils.isEmpty((String)step)) {
                throw new RuntimeException("Invalid inputs. Can't determine step or step status.");
            }
            String actualValue = matcher.group(3);
            if (StringUtils.isEmpty((String)actualValue)) {
                actualValue = "";
            }
            stepToActualValue.put(step, actualValue);
            stepToStatus.put(step, UploaderHelper.parseStepStatus(status, this.stepStatus));
        }
        return this.buildStepBeans(stepToActualValue, stepToStatus);
    }

    private List<StepBean> buildStepBeans(Map<String, String> stepToActualValue, Map<String, String> stepToStatus) {
        if (stepToActualValue == null || stepToActualValue.isEmpty() || stepToStatus == null || stepToStatus.isEmpty()) {
            return null;
        }
        ArrayList<StepBean> stepBeans = new ArrayList<StepBean>();
        int order = 1;
        for (Map.Entry<String, String> entry : stepToActualValue.entrySet()) {
            StepBean stepBean = new StepBean();
            stepBean.setStepName(entry.getKey());
            stepBean.setStatus(stepToStatus.get(entry.getKey()));
            stepBean.setOrder(order++);
            stepBean.setActualValue(entry.getValue());
            stepBeans.add(stepBean);
        }
        return stepBeans;
    }

    private static String parseStepStatus(String status, Map<String, String> stepStatus) {
        if (StringUtils.isEmpty((String)stepStatus.get(status))) {
            throw new RuntimeException("Can't find relevant step status mapping:->" + status);
        }
        return stepStatus.get(status);
    }
}

