/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.commonResultUpload.uploader;

import com.microfocus.application.automation.tools.commonResultUpload.CommonUploadLogger;
import com.microfocus.application.automation.tools.commonResultUpload.service.CriteriaTranslator;
import com.microfocus.application.automation.tools.commonResultUpload.service.CustomizationService;
import com.microfocus.application.automation.tools.commonResultUpload.service.FolderService;
import com.microfocus.application.automation.tools.commonResultUpload.service.RestService;
import com.microfocus.application.automation.tools.commonResultUpload.service.VersionControlService;
import com.microfocus.application.automation.tools.commonResultUpload.uploader.TestInstanceUploader;
import com.microfocus.application.automation.tools.commonResultUpload.xmlreader.model.XmlResultEntity;
import com.microfocus.application.automation.tools.results.service.AlmRestTool;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class TestUploader {
    public static final String TEST_REST_PREFIX = "tests";
    private static final String TEST_FOLDERS_REST_PREFIX = "test-folders";
    public static final String[] NO_VERSION_TESTS = new String[]{"ALT-SCENARIO", "LEANFT-TEST", "LR-SCENARIO", "QAINSPECT-TEST"};
    private static final String VC_VERSION_NUMBER = "vc-version-number";
    private static final String SUB_TYPE_ID = "subtype-id";
    private static final int triedTimes = 30;
    private Map<String, String> params;
    private CommonUploadLogger logger;
    private RestService restService;
    private FolderService folderService;
    private CustomizationService customizationService;
    private TestInstanceUploader testInstanceUploader;
    private VersionControlService versionControlService;

    public TestUploader(CommonUploadLogger logger, Map<String, String> params, RestService restService, FolderService folderService, TestInstanceUploader testInstanceUploader, CustomizationService customizationService, VersionControlService versionControlService) {
        this.logger = logger;
        this.params = params;
        this.restService = restService;
        this.folderService = folderService;
        this.testInstanceUploader = testInstanceUploader;
        this.customizationService = customizationService;
        this.versionControlService = versionControlService;
    }

    public void upload(Map<String, String> testset, List<XmlResultEntity> xmlResultEntities) {
        this.logger.info("Test upload start.");
        for (XmlResultEntity xmlResultEntity : xmlResultEntities) {
            Map<String, String> test = xmlResultEntity.getValueMap();
            Map<String, String> newTest = null;
            String attachment = test.get("attachment");
            test.remove("attachment");
            boolean isNew = false;
            boolean isUpdate = false;
            if (!StringUtils.isEmpty((String)this.params.get("almTestFolder"))) {
                Map<String, String> folder = this.folderService.createOrFindPath(TEST_FOLDERS_REST_PREFIX, "2", this.params.get("almTestFolder"));
                if (folder == null) continue;
                Map<String, String> existsTest = this.folderService.findEntityInFolder(folder, test, TEST_REST_PREFIX, TEST_FOLDERS_REST_PREFIX, new String[]{"id", "name", SUB_TYPE_ID, VC_VERSION_NUMBER});
                if (existsTest != null) {
                    Map<String, String> runFieldsMap;
                    if (xmlResultEntity.getSubEntities().size() > 0 && (runFieldsMap = xmlResultEntity.getSubEntities().get(0).getValueMap()) != null && runFieldsMap.containsKey("stepMessage")) {
                        if (this.params.get("updateDesSteps").equals("true")) {
                            isUpdate = true;
                        } else {
                            test.put("parent-id", folder.get("id"));
                            newTest = this.createNewTest(test);
                            isNew = true;
                        }
                    }
                    if (!isNew) {
                        existsTest.putAll(test);
                        newTest = this.restService.update(TEST_REST_PREFIX, existsTest);
                    }
                } else {
                    this.logger.log("Test not found by criteria:");
                    for (Map.Entry<String, String> entry : test.entrySet()) {
                        if (!entry.getKey().equals("name") && !entry.getKey().startsWith("q|")) continue;
                        this.logger.log("----" + entry.getKey() + "=" + entry.getValue());
                    }
                    test.put("parent-id", folder.get("id"));
                    if (this.params.get("createNewTest").equals("true")) {
                        newTest = this.restService.create(TEST_REST_PREFIX, test);
                        isNew = true;
                    } else {
                        newTest = null;
                        this.logger.log("Test not found and not created: " + test.toString());
                    }
                }
            } else {
                test.put("parent-id", "0");
                if (this.params.get("createNewTest").equals("true")) {
                    newTest = this.restService.create(TEST_REST_PREFIX, test);
                    isNew = true;
                } else {
                    newTest = null;
                    this.logger.log("Test not found and not created: " + test.toString());
                }
            }
            if (newTest == null) continue;
            this.getVersionNumberForVC(newTest);
            test.putAll(newTest);
            this.testInstanceUploader.upload(testset, xmlResultEntity, attachment, isNew || isUpdate);
        }
    }

    private Map<String, String> createNewTest(Map<String, String> test) {
        Map<String, String> newTest = null;
        String testName = test.get("name");
        for (int i = 0; i < 30; ++i) {
            String query = String.format("fields=id,name&query={parent-id[%s];name[%s]}", test.get("parent-id"), AlmRestTool.getEncodedString(testName));
            List<Map<String, String>> tests = this.restService.get(null, TEST_REST_PREFIX, query);
            if (tests == null || tests.size() <= 0) {
                test.put("name", testName);
                newTest = this.restService.create(TEST_REST_PREFIX, test);
                break;
            }
            this.logger.log("Test[" + testName + "] already exists.");
            testName = this.buildNewTestName(testName);
        }
        return newTest;
    }

    private String buildNewTestName(String testName) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        Date currentDate = new Date();
        String formattedDate = formatter.format(currentDate);
        String suffixPattern = "_Copy_(\\d+)_" + formattedDate + "$";
        Pattern pattern = Pattern.compile(suffixPattern);
        Matcher matcher = pattern.matcher((CharSequence)testName);
        if (matcher.find()) {
            int index = Integer.parseInt(matcher.group(1)) + 1;
            String newSuffix = "_Copy_" + index + "_" + formattedDate;
            testName = ((String)testName).replace(matcher.group(0), newSuffix);
        } else {
            testName = (String)testName + "_Copy_0_" + formattedDate;
        }
        return testName;
    }

    private void getVersionNumberForVC(Map<String, String> newTest) {
        for (String noVersionTest : NO_VERSION_TESTS) {
            if (!newTest.get(SUB_TYPE_ID).equals(noVersionTest)) continue;
            return;
        }
        boolean versioningEnabled = this.customizationService.isVersioningEnabled("test");
        if (versioningEnabled && StringUtils.isEmpty((String)newTest.get(VC_VERSION_NUMBER))) {
            this.versionControlService.refreshEntityVersion(TEST_REST_PREFIX, newTest.get("id"));
            newTest.putAll(this.restService.get(newTest.get("id"), TEST_REST_PREFIX, CriteriaTranslator.getCriteriaString(new String[]{"id", "name", SUB_TYPE_ID, VC_VERSION_NUMBER}, newTest)).get(0));
        }
    }
}

