/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.commonResultUpload.service;

import com.microfocus.application.automation.tools.commonResultUpload.CommonUploadLogger;
import com.microfocus.application.automation.tools.commonResultUpload.service.CustomizationService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class UDFTranslator {
    public static final String UDF_PREFIX = "udf|";
    private CommonUploadLogger logger;
    private CustomizationService customizationService;

    public UDFTranslator(CustomizationService customizationService, CommonUploadLogger logger) {
        this.customizationService = customizationService;
        this.logger = logger;
    }

    public void translate(String restPrefix, Map<String, String> valueMap) {
        switch (restPrefix) {
            case "test-sets": {
                this.transUDFNames("test-set", valueMap);
                break;
            }
            case "tests": {
                this.transUDFNames("test", valueMap);
                break;
            }
            case "runs": {
                this.transUDFNames("run", valueMap);
                break;
            }
        }
    }

    private void transUDFNames(String entityName, Map<String, String> entityMap) {
        ArrayList<String> tobeRemoved = new ArrayList<String>();
        HashMap<String, String> tobeAdded = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : entityMap.entrySet()) {
            String name = entry.getKey();
            if (!name.startsWith(UDF_PREFIX)) continue;
            String label = name.substring(name.indexOf(UDF_PREFIX) + UDF_PREFIX.length());
            String realName = this.customizationService.getUDFNameByLabel(entityName, label);
            if (StringUtils.isNotEmpty((String)realName)) {
                tobeAdded.put(realName, entityMap.get(name));
                tobeRemoved.add(name);
                continue;
            }
            this.logger.error(String.format("No user defined field with label [%s] was found.", label));
        }
        entityMap.putAll(tobeAdded);
        for (String item : tobeRemoved) {
            entityMap.remove(item);
        }
    }
}

