/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.util;

import org.apache.commons.lang3.StringUtils;
import org.htmlunit.WebClient;
import org.htmlunit.WebResponse;
import org.htmlunit.WebWindow;
import org.htmlunit.corejs.javascript.ContextFactory;
import org.htmlunit.corejs.javascript.tools.debugger.Main;
import org.htmlunit.corejs.javascript.tools.debugger.ScopeProvider;
import org.htmlunit.corejs.javascript.tools.debugger.SourceProvider;
import org.htmlunit.javascript.HtmlUnitContextFactory;

public final class WebClientUtils {
    private WebClientUtils() {
    }

    public static void attachVisualDebugger(WebClient client) {
        HtmlUnitContextFactory cf = client.getJavaScriptEngine().getContextFactory();
        Main main = Main.mainEmbedded((ContextFactory)cf, (ScopeProvider)null, (String)"HtmlUnit JavaScript Debugger");
        main.getDebugFrame().setExtendedState(6);
        SourceProvider sourceProvider = script -> {
            String sourceName = script.getSourceName();
            if (sourceName.endsWith("(eval)") || sourceName.endsWith("(Function)")) {
                return null;
            }
            if (sourceName.startsWith("script in ")) {
                sourceName = StringUtils.substringBetween((String)sourceName, (String)"script in ", (String)" from");
                for (WebWindow ww : client.getWebWindows()) {
                    WebResponse wr = ww.getEnclosedPage().getWebResponse();
                    if (!sourceName.equals(wr.getWebRequest().getUrl().toString())) continue;
                    return wr.getContentAsString();
                }
            }
            return null;
        };
        main.setSourceProvider(sourceProvider);
    }
}

