/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.FormEncodingType;
import org.htmlunit.WebRequest;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.ES6Iterator;
import org.htmlunit.corejs.javascript.EcmaError;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.IdScriptableObject;
import org.htmlunit.corejs.javascript.IteratorLikeIterable;
import org.htmlunit.corejs.javascript.NativeObject;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.Symbol;
import org.htmlunit.corejs.javascript.SymbolKey;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSymbol;
import org.htmlunit.javascript.host.URL;
import org.htmlunit.util.NameValuePair;
import org.htmlunit.util.UrlUtils;

@JsxClass
public class URLSearchParams
extends HtmlUnitScriptable {
    private static final Log LOG = LogFactory.getLog(URLSearchParams.class);
    public static final String URL_SEARCH_PARMS_TAG = "URLSearchParams";
    private URL url_;

    public URLSearchParams() {
    }

    URLSearchParams(URL url) {
        this.url_ = url;
    }

    @JsxConstructor
    public void jsConstructor(Object params) {
        this.url_ = new URL();
        this.url_.jsConstructor("http://www.htmlunit.org", "");
        if (params == null || JavaScriptEngine.isUndefined(params)) {
            return;
        }
        try {
            this.url_.setSearch(URLSearchParams.resolveParams(params));
        }
        catch (EcmaError e) {
            throw JavaScriptEngine.typeError("Failed to construct 'URLSearchParams': " + e.getErrorMessage());
        }
        catch (MalformedURLException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static List<NameValuePair> resolveParams(Object params) {
        if (params instanceof Scriptable && ScriptableObject.hasProperty((Scriptable)((Scriptable)params), (Symbol)SymbolKey.ITERATOR)) {
            Context cx = Context.getCurrentContext();
            Scriptable paramsScriptable = (Scriptable)params;
            ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
            try (IteratorLikeIterable itr = URLSearchParams.buildIteratorLikeIterable(cx, paramsScriptable);){
                for (Object nameValue : itr) {
                    if (!(nameValue instanceof Scriptable)) {
                        throw JavaScriptEngine.typeError("The provided value cannot be converted to a sequence.");
                    }
                    if (!ScriptableObject.hasProperty((Scriptable)((Scriptable)nameValue), (Symbol)SymbolKey.ITERATOR)) {
                        throw JavaScriptEngine.typeError("The object must have a callable @@iterator property.");
                    }
                    IteratorLikeIterable nameValueItr = URLSearchParams.buildIteratorLikeIterable(cx, (Scriptable)nameValue);
                    Throwable throwable = null;
                    try {
                        Object value;
                        IteratorLikeIterable.Itr nameValueIterator = nameValueItr.iterator();
                        Object name = nameValueIterator.hasNext() ? nameValueIterator.next() : Scriptable.NOT_FOUND;
                        Object object = value = nameValueIterator.hasNext() ? nameValueIterator.next() : Scriptable.NOT_FOUND;
                        if (name == Scriptable.NOT_FOUND || value == Scriptable.NOT_FOUND || nameValueIterator.hasNext()) {
                            throw JavaScriptEngine.typeError("Sequence initializer must only contain pair elements.");
                        }
                        nameValuePairs.add(new NameValuePair(JavaScriptEngine.toString(name), JavaScriptEngine.toString(value)));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (nameValueItr == null) continue;
                        if (throwable != null) {
                            try {
                                nameValueItr.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        nameValueItr.close();
                    }
                }
            }
            return nameValuePairs;
        }
        if (params instanceof NativeObject) {
            ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
            for (Map.Entry keyValuePair : ((NativeObject)params).entrySet()) {
                nameValuePairs.add(new NameValuePair(JavaScriptEngine.toString(keyValuePair.getKey()), JavaScriptEngine.toString(keyValuePair.getValue())));
            }
            return nameValuePairs;
        }
        return URLSearchParams.splitQuery(JavaScriptEngine.toString(params));
    }

    private List<NameValuePair> splitQuery() {
        return URLSearchParams.splitQuery(this.url_.getSearch());
    }

    private static List<NameValuePair> splitQuery(String params) {
        String[] parts;
        ArrayList<NameValuePair> splitted = new ArrayList<NameValuePair>();
        if (StringUtils.isEmpty((CharSequence)(params = StringUtils.stripStart((String)params, (String)"?")))) {
            return splitted;
        }
        for (String part : parts = StringUtils.split((String)params, (char)'&')) {
            NameValuePair pair = URLSearchParams.splitQueryParameter(part);
            splitted.add(new NameValuePair(UrlUtils.decode(pair.getName()), UrlUtils.decode(pair.getValue())));
        }
        return splitted;
    }

    private static NameValuePair splitQueryParameter(String singleParam) {
        int idx = singleParam.indexOf(61);
        if (idx > -1) {
            String key = singleParam.substring(0, idx);
            String value = null;
            if (idx < singleParam.length()) {
                value = singleParam.substring(idx + 1);
            }
            return new NameValuePair(key, value);
        }
        String value = "";
        return new NameValuePair(singleParam, "");
    }

    private static IteratorLikeIterable buildIteratorLikeIterable(Context cx, Scriptable iterable) {
        Object iterator = ScriptRuntime.callIterator((Object)iterable, (Context)cx, (Scriptable)iterable.getParentScope());
        return new IteratorLikeIterable(cx, iterable.getParentScope(), iterator);
    }

    @JsxFunction
    public void append(String name, String value) {
        String search = this.url_.getSearch();
        List<Object> pairs = search == null || search.isEmpty() ? new ArrayList(1) : URLSearchParams.splitQuery(search);
        pairs.add(new NameValuePair(name, value));
        try {
            this.url_.setSearch(pairs);
        }
        catch (MalformedURLException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @JsxFunction
    public void delete(String name) {
        List<NameValuePair> splitted = this.splitQuery();
        splitted.removeIf(entry -> entry.getName().equals(name));
        if (splitted.size() == 0) {
            try {
                this.url_.setSearch((String)null);
            }
            catch (MalformedURLException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            return;
        }
        try {
            this.url_.setSearch(splitted);
        }
        catch (MalformedURLException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @JsxFunction
    public String get(String name) {
        List<NameValuePair> splitted = this.splitQuery();
        for (NameValuePair param : splitted) {
            if (!param.getName().equals(name)) continue;
            return param.getValue();
        }
        return null;
    }

    @JsxFunction
    public Scriptable getAll(String name) {
        List<NameValuePair> splitted = this.splitQuery();
        ArrayList<String> result = new ArrayList<String>(splitted.size());
        for (NameValuePair param : splitted) {
            if (!param.getName().equals(name)) continue;
            result.add(param.getValue());
        }
        return JavaScriptEngine.newArray((Scriptable)URLSearchParams.getWindow((Scriptable)this), result.toArray());
    }

    @JsxFunction
    public void set(String name, String value) {
        List<NameValuePair> splitted = this.splitQuery();
        boolean change = true;
        ListIterator<NameValuePair> iter = splitted.listIterator();
        while (iter.hasNext()) {
            NameValuePair entry = iter.next();
            if (!entry.getName().equals(name)) continue;
            if (change) {
                iter.set(new NameValuePair(name, value));
                change = false;
                continue;
            }
            iter.remove();
        }
        if (change) {
            splitted.add(new NameValuePair(name, value));
        }
        try {
            this.url_.setSearch(splitted);
        }
        catch (MalformedURLException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @JsxFunction
    public boolean has(String name) {
        List<NameValuePair> splitted = this.splitQuery();
        for (NameValuePair param : splitted) {
            if (!param.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @JsxFunction
    public void forEach(Object callback) {
        if (!(callback instanceof Function)) {
            throw JavaScriptEngine.typeError("Foreach callback '" + JavaScriptEngine.toString(callback) + "' is not a function");
        }
        Function fun = (Function)callback;
        String currentSearch = null;
        List<NameValuePair> params = null;
        int i = 0;
        while (true) {
            String search;
            if (!(search = this.url_.getSearch()).equals(currentSearch)) {
                params = URLSearchParams.splitQuery(search);
                currentSearch = search;
            }
            if (i >= params.size()) break;
            NameValuePair param = params.get(i);
            fun.call(Context.getCurrentContext(), this.getParentScope(), (Scriptable)this, new Object[]{param.getValue(), param.getName(), this});
            ++i;
        }
    }

    @JsxFunction
    @JsxSymbol(symbolName="iterator")
    public Object entries() {
        List<NameValuePair> splitted = this.splitQuery();
        return new NativeParamsIterator(this.getParentScope(), "URLSearchParams Iterator", NativeParamsIterator.Type.BOTH, splitted.iterator());
    }

    @JsxFunction
    public Object keys() {
        List<NameValuePair> splitted = this.splitQuery();
        return new NativeParamsIterator(this.getParentScope(), "URLSearchParams Iterator", NativeParamsIterator.Type.KEYS, splitted.iterator());
    }

    @JsxFunction
    public Object values() {
        List<NameValuePair> splitted = this.splitQuery();
        return new NativeParamsIterator(this.getParentScope(), "URLSearchParams Iterator", NativeParamsIterator.Type.VALUES, splitted.iterator());
    }

    @JsxGetter
    public int getSize() {
        List<NameValuePair> splitted = this.splitQuery();
        return splitted.size();
    }

    @JsxFunction(functionName="toString")
    public String jsToString() {
        StringBuilder newSearch = new StringBuilder();
        for (NameValuePair nameValuePair : URLSearchParams.splitQuery(this.url_.getSearch())) {
            if (newSearch.length() > 0) {
                newSearch.append('&');
            }
            newSearch.append(UrlUtils.encodeQueryPart(nameValuePair.getName())).append('=').append(UrlUtils.encodeQueryPart(nameValuePair.getValue()));
        }
        return newSearch.toString();
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        return this.jsToString();
    }

    public void fillRequest(WebRequest webRequest) {
        webRequest.setRequestBody(null);
        webRequest.setEncodingType(FormEncodingType.URL_ENCODED);
        List<NameValuePair> splitted = this.splitQuery();
        if (splitted.size() > 0) {
            ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
            for (NameValuePair entry : splitted) {
                params.add(new NameValuePair(entry.getName(), entry.getValue()));
            }
            webRequest.setRequestParameters(params);
        }
    }

    public static final class NativeParamsIterator
    extends ES6Iterator {
        private final Type type_;
        private final String className_;
        private final transient Iterator<NameValuePair> iterator_;

        public static void init(ScriptableObject scope, String className) {
            ES6Iterator.init((ScriptableObject)scope, (boolean)false, (IdScriptableObject)new NativeParamsIterator(className), (String)URLSearchParams.URL_SEARCH_PARMS_TAG);
        }

        public NativeParamsIterator(String className) {
            this.iterator_ = Collections.emptyIterator();
            this.type_ = Type.BOTH;
            this.className_ = className;
        }

        public NativeParamsIterator(Scriptable scope, String className, Type type, Iterator<NameValuePair> iterator) {
            super(scope, URLSearchParams.URL_SEARCH_PARMS_TAG);
            this.iterator_ = iterator;
            this.type_ = type;
            this.className_ = className;
        }

        public String getClassName() {
            return this.className_;
        }

        protected boolean isDone(Context cx, Scriptable scope) {
            return !this.iterator_.hasNext();
        }

        protected Object nextValue(Context cx, Scriptable scope) {
            NameValuePair e = this.iterator_.next();
            switch (this.type_) {
                case KEYS: {
                    return e.getName();
                }
                case VALUES: {
                    return e.getValue();
                }
                case BOTH: {
                    return cx.newArray(scope, new Object[]{e.getName(), e.getValue()});
                }
            }
            throw new AssertionError();
        }

        static enum Type {
            KEYS,
            VALUES,
            BOTH;

        }
    }
}

