/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.css;

import java.util.regex.Pattern;
import org.apache.commons.lang3.math.NumberUtils;
import org.htmlunit.css.ComputedCssStyleDeclaration;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.HtmlCanvas;
import org.htmlunit.html.HtmlHtml;

public final class CssPixelValueConverter {
    private static final Pattern TO_FLOAT_PATTERN = Pattern.compile("(\\d+(?:\\.\\d+)?).*");

    private CssPixelValueConverter() {
    }

    public static int pixelValue(DomElement element, CssValue value) {
        ComputedCssStyleDeclaration style = element.getPage().getEnclosingWindow().getComputedStyle(element, null);
        String s = value.get(style);
        return CssPixelValueConverter.pixelValue(element, s, value, false);
    }

    public static String pixelString(DomElement element, CssValue value) {
        ComputedCssStyleDeclaration style = element.getPage().getEnclosingWindow().getComputedStyle(element, null);
        String styleValue = value.get(style);
        if (styleValue.endsWith("px")) {
            return styleValue;
        }
        return CssPixelValueConverter.pixelValue(element, styleValue, value, false) + "px";
    }

    public static int pixelValue(String value) {
        float i = NumberUtils.toFloat((String)TO_FLOAT_PATTERN.matcher(value).replaceAll("$1"), (float)0.0f);
        if (value.length() < 2) {
            return Math.round(i);
        }
        if (value.endsWith("px")) {
            return Math.round(i);
        }
        if (value.endsWith("em")) {
            i *= 16.0f;
        } else if (value.endsWith("%")) {
            i = i * 16.0f / 100.0f;
        } else if (value.endsWith("ex")) {
            i *= 10.0f;
        } else if (value.endsWith("in")) {
            i *= 150.0f;
        } else if (value.endsWith("cm")) {
            i *= 50.0f;
        } else if (value.endsWith("mm")) {
            i *= 5.0f;
        } else if (value.endsWith("pt")) {
            i *= 2.0f;
        } else if (value.endsWith("pc")) {
            i *= 24.0f;
        }
        return Math.round(i);
    }

    private static int pixelValue(DomElement element, String styleValue, CssValue value, boolean percentMode) {
        if (styleValue.endsWith("%") || styleValue.isEmpty() && element instanceof HtmlHtml) {
            int absoluteValue;
            float i = NumberUtils.toFloat((String)TO_FLOAT_PATTERN.matcher(styleValue).replaceAll("$1"), (float)100.0f);
            DomNode parent = element.getParentNode();
            if (parent instanceof DomElement) {
                DomElement parentElem = (DomElement)parent;
                ComputedCssStyleDeclaration style = parentElem.getPage().getEnclosingWindow().getComputedStyle(parentElem, null);
                String parentStyleValue = value.get(style);
                absoluteValue = CssPixelValueConverter.pixelValue((DomElement)parent, parentStyleValue, value, true);
            } else {
                absoluteValue = value.getWindowDefaultValue();
            }
            return Math.round(i / 100.0f * (float)absoluteValue);
        }
        if ("auto".equals(styleValue)) {
            return value.getDefaultValue();
        }
        if (styleValue.isEmpty()) {
            if (element instanceof HtmlCanvas) {
                return value.getWindowDefaultValue();
            }
            if (percentMode) {
                DomNode parent = element.getParentNode();
                if (parent == null || parent instanceof HtmlHtml) {
                    return value.getWindowDefaultValue();
                }
                DomElement parentElem = (DomElement)parent;
                ComputedCssStyleDeclaration style = parentElem.getPage().getEnclosingWindow().getComputedStyle(parentElem, null);
                String parentStyleValue = value.get(style);
                return CssPixelValueConverter.pixelValue(parentElem, parentStyleValue, value, true);
            }
            return 0;
        }
        return CssPixelValueConverter.pixelValue(styleValue);
    }

    public static abstract class CssValue {
        private final int defaultValue_;
        private final int windowDefaultValue_;

        public CssValue(int defaultValue, int windowDefaultValue) {
            this.defaultValue_ = defaultValue;
            this.windowDefaultValue_ = windowDefaultValue;
        }

        public int getDefaultValue() {
            return this.defaultValue_;
        }

        public int getWindowDefaultValue() {
            return this.windowDefaultValue_;
        }

        public abstract String get(ComputedCssStyleDeclaration var1);
    }
}

