/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.service;

import com.microfocus.sv.svconfigurator.core.IService;
import com.microfocus.sv.svconfigurator.core.impl.ServiceDataDecorator;
import com.microfocus.sv.svconfigurator.core.impl.datasource.InMemoryProjectElementDataSource;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommandExecutorException;
import com.microfocus.sv.svconfigurator.core.impl.exception.SVCParseException;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.AgentConfigurations;
import com.microfocus.sv.svconfigurator.processor.utils.ServiceAgentsInfo;
import com.microfocus.sv.svconfigurator.service.AgentByNameRemappingServiceUpdater;
import com.microfocus.sv.svconfigurator.service.AgentFallbackServiceUpdater;
import com.microfocus.sv.svconfigurator.service.AgentRemappingServiceUpdater;
import com.microfocus.sv.svconfigurator.service.ServiceAgentUpdater;
import com.microfocus.sv.svconfigurator.service.ServiceAmendingService;
import com.microfocus.sv.svconfigurator.service.ValidateAndSetNameServiceUpdater;
import com.microfocus.sv.svconfigurator.util.XmlUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;

public class ServiceAmendingServiceImpl
implements ServiceAmendingService {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceAmendingServiceImpl.class);
    private AgentConfigurations agentConfigurations;
    private Map<String, ServiceAgentsInfo> agentInfoMap;
    private List<IService> services;

    public ServiceAmendingServiceImpl(AgentConfigurations agentConfigurations, List<IService> services) throws CommandExecutorException {
        this.agentConfigurations = agentConfigurations;
        this.services = services;
        this.agentInfoMap = ServiceAmendingServiceImpl.createAgentInfoMap(services);
    }

    private static Map<String, ServiceAgentsInfo> createAgentInfoMap(List<IService> services) throws CommandExecutorException {
        HashMap<String, ServiceAgentsInfo> agentInfoMap = new HashMap<String, ServiceAgentsInfo>();
        for (IService svc : services) {
            try {
                agentInfoMap.put(svc.getId(), new ServiceAgentsInfo(svc));
            }
            catch (Exception e) {
                throw new CommandExecutorException(String.format("Failed to parse agent references of service %s [%s]", svc.getName(), svc.getId()));
            }
        }
        return agentInfoMap;
    }

    @Override
    public void agentFallback() throws CommandExecutorException {
        this.amendServiceAgents(this.services, new AgentFallbackServiceUpdater(this.agentConfigurations));
    }

    @Override
    public void remapAgents(Map<String, String> agentRemapping) throws CommandExecutorException {
        this.amendServiceAgents(this.services, new AgentRemappingServiceUpdater(this.agentConfigurations, agentRemapping));
    }

    @Override
    public void remapAgentsByNames() throws CommandExecutorException {
        this.amendServiceAgents(this.services, new AgentByNameRemappingServiceUpdater(this.agentConfigurations));
    }

    @Override
    public void verifyAndSetNames() throws CommandExecutorException {
        this.amendServiceAgents(this.services, new ValidateAndSetNameServiceUpdater(this.agentConfigurations));
    }

    private void amendServiceAgents(List<IService> services, ServiceAgentUpdater serviceAgentUpdater) throws CommandExecutorException {
        for (IService svc : services) {
            ServiceAgentsInfo agentsInfo = this.agentInfoMap.get(svc.getId());
            for (ServiceAgentsInfo.AgentRef agentRef : agentsInfo.getAgentRefs().values()) {
                try {
                    String newId = serviceAgentUpdater.getMappedServerAgentId(agentsInfo.getAgentType(), agentRef.getId(), agentRef.getName());
                    if (newId == null) continue;
                    agentRef.setId(newId);
                    String newName = serviceAgentUpdater.getServerAgentName(agentsInfo.getAgentType(), newId);
                    if (newName == null) continue;
                    agentRef.setName(newName);
                }
                catch (CommandExecutorException e) {
                    throw new CommandExecutorException(String.format("Failed to process service '%s' [id: %s]. Detail: %s", svc.getName(), svc.getId(), e.getMessage()), e);
                }
            }
        }
    }

    public List<IService> applyAgentChanges() throws CommandExecutorException {
        ArrayList<IService> res = new ArrayList<IService>(this.services.size());
        for (IService svc : this.services) {
            ServiceAgentsInfo agentsInfo = this.agentInfoMap.get(svc.getId());
            if (!agentsInfo.isModified()) {
                res.add(svc);
                continue;
            }
            try {
                Document doc = XmlUtils.createDoc(svc.getData());
                doc.getDocumentElement().normalize();
                for (Map.Entry<String, ServiceAgentsInfo.AgentRef> entry : agentsInfo.getAgentRefs().entrySet()) {
                    NamedNodeMap agentAttributes = doc.getElementsByTagNameNS("http://hp.com/SOAQ/ServiceVirtualization/2010/", entry.getKey()).item(0).getAttributes();
                    this.setAttribute(doc, agentAttributes, "ref", entry.getValue().getId());
                    this.setAttribute(doc, agentAttributes, "name", entry.getValue().getName());
                }
                IService updatedSvc = this.createModifiedService(svc, doc);
                res.add(updatedSvc);
            }
            catch (Exception e) {
                throw new CommandExecutorException(String.format("Failed to parse serialize service %s [%s]", svc.getName(), svc.getId()));
            }
        }
        return res;
    }

    private IService createModifiedService(IService svc, Document doc) throws TransformerException, IOException, SVCParseException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        transformer.transform(new DOMSource(doc), new StreamResult(os));
        byte[] data = os.toByteArray();
        return new ServiceDataDecorator(svc, new InMemoryProjectElementDataSource(data));
    }

    private void setAttribute(Document doc, NamedNodeMap agentAttributes, String attrName, String attrValue) {
        Attr attr = doc.createAttribute(attrName);
        attr.setNodeValue(attrValue);
        agentAttributes.setNamedItem(attr);
    }
}

