/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.serverclient.impl;

import com.microfocus.sv.svconfigurator.Global;
import com.microfocus.sv.svconfigurator.core.IContentFile;
import com.microfocus.sv.svconfigurator.core.IDataModel;
import com.microfocus.sv.svconfigurator.core.IDataSet;
import com.microfocus.sv.svconfigurator.core.ILoggedServiceCallList;
import com.microfocus.sv.svconfigurator.core.IPerfModel;
import com.microfocus.sv.svconfigurator.core.IProject;
import com.microfocus.sv.svconfigurator.core.IService;
import com.microfocus.sv.svconfigurator.core.IServiceDescription;
import com.microfocus.sv.svconfigurator.core.impl.DataModel;
import com.microfocus.sv.svconfigurator.core.impl.OfflinePerfModel;
import com.microfocus.sv.svconfigurator.core.impl.PerfModel;
import com.microfocus.sv.svconfigurator.core.impl.Service;
import com.microfocus.sv.svconfigurator.core.impl.datasource.InexistingProjectElementDataSource;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommandExecutorException;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommunicatorException;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.AgentConfigurations;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.ServiceAnalysis;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.ServiceRuntimeConfiguration;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.ServiceRuntimeReport;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.VirtualServiceLoggingConfiguration;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.atom.ElemModelListAtom;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.atom.ServiceListAtom;
import com.microfocus.sv.svconfigurator.core.impl.processor.ElementStatus;
import com.microfocus.sv.svconfigurator.serverclient.ICommandExecutor;
import com.microfocus.sv.svconfigurator.serverclient.IServerManagementEndpointClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandExecutor
implements ICommandExecutor {
    public static final String PROP_WAIT_MS = "svconf_wait_ms";
    private static final int RETRY_INTERVAL_MS = 250;
    private static final Logger LOG = LoggerFactory.getLogger(CommandExecutor.class);
    private static int WAIT_MILISECONDS = 30000;
    private IServerManagementEndpointClient smeClient;
    private boolean force = false;

    public CommandExecutor(IServerManagementEndpointClient smeClient) throws CommunicatorException {
        this.smeClient = smeClient;
    }

    @Override
    public void deployProject(IProject project) throws CommunicatorException, CommandExecutorException {
        for (IService svc : project.getServices()) {
            this.deployService(svc, project.getProjectPassword(), false);
        }
        LOG.info(project + " successfully deployed.");
    }

    @Override
    public void deployService(IService svc, String projectPassword) throws CommunicatorException, CommandExecutorException {
        this.deployService(svc, projectPassword, false);
    }

    @Override
    public void deployService(IService svc, String projectPassword, boolean importLoggedMessages) throws CommunicatorException, CommandExecutorException {
        ElementStatus svcStat = this.smeClient.getServiceStatus(svc);
        if (ElementStatus.NOT_PRESENT.equals((Object)svcStat)) {
            this.smeClient.deployService(svc, projectPassword);
        } else {
            this.changeServiceDeploymentState(svc, ServiceRuntimeConfiguration.DeploymentState.DOWN);
            this.smeClient.updateService(svc, projectPassword);
        }
        this.smeClient.getServiceStatus(svc);
        if (importLoggedMessages) {
            this.smeClient.resetLoggedMessagesForService(svc.getId());
            ArrayList<ILoggedServiceCallList> sorted = new ArrayList<ILoggedServiceCallList>(svc.getLoggedServiceCallLists());
            Collections.sort(sorted, new Comparator<ILoggedServiceCallList>(){

                @Override
                public int compare(ILoggedServiceCallList l1, ILoggedServiceCallList l2) {
                    return l1.getName().compareTo(l2.getName());
                }
            });
            for (ILoggedServiceCallList serviceCallList : sorted) {
                this.smeClient.importLoggedMessages(serviceCallList);
            }
        }
        for (IDataModel dm : svc.getDataModels()) {
            ElementStatus dmStat = this.smeClient.getDataModelStatus(dm);
            if (ElementStatus.NOT_PRESENT.equals((Object)dmStat)) {
                this.smeClient.deployDataModel(dm, projectPassword);
            } else {
                this.smeClient.updateDataModel(dm, projectPassword);
            }
            this.smeClient.getDataModelStatus(dm);
            for (IDataSet ds : dm.getDataSets()) {
                ElementStatus dsStat = this.smeClient.getDataSetStatus(ds);
                if (ElementStatus.NOT_PRESENT.equals((Object)dsStat)) {
                    this.smeClient.deployDataSet(ds, projectPassword);
                } else {
                    long version = this.smeClient.getDataSetHashCode(ds);
                    if (version != ds.getDataHashCode()) {
                        this.smeClient.updateDataSet(ds, projectPassword);
                    }
                }
                this.smeClient.getDataSetStatus(ds);
            }
        }
        for (IPerfModel pm : svc.getPerfModels()) {
            ElementStatus pmStat = this.smeClient.getPerfModelStatus(pm);
            if (ElementStatus.NOT_PRESENT.equals((Object)pmStat)) {
                this.smeClient.deployPerfModel(pm, projectPassword);
            } else {
                this.smeClient.updatePerfModel(pm, projectPassword);
            }
            this.smeClient.getPerfModelStatus(pm);
        }
        for (IServiceDescription sd : svc.getDescriptions()) {
            ElementStatus sdStat = this.smeClient.getServiceDescriptionStatus(sd, svc);
            if (ElementStatus.NOT_PRESENT.equals((Object)sdStat)) {
                this.smeClient.deployServiceDescription(sd, svc, projectPassword);
            } else {
                this.smeClient.updateServiceDescription(sd, svc, projectPassword);
            }
            this.smeClient.getServiceDescriptionStatus(sd, svc);
        }
        for (IContentFile cf : svc.getContentFiles()) {
            ElementStatus cfStat = this.smeClient.getContentFileStatus(cf, svc);
            if (ElementStatus.NOT_PRESENT.equals((Object)cfStat)) {
                this.smeClient.deployContentFile(cf, projectPassword, svc);
            } else {
                this.smeClient.updateContentFile(cf, projectPassword, svc);
            }
            this.smeClient.getContentFileStatus(cf, svc);
        }
        this.smeClient.getServiceRuntimeConfiguration(svc);
        this.changeServiceDeploymentState(svc, ServiceRuntimeConfiguration.DeploymentState.READY);
        LOG.info(svc + " successfully deployed.");
    }

    @Override
    public void undeploy(IProject project) throws CommunicatorException, CommandExecutorException {
        for (IService svc : project.getServices()) {
            this.undeployService(svc);
        }
        LOG.info(project + " successfully undeployed.");
    }

    @Override
    public void undeployService(IService svc) throws CommunicatorException, CommandExecutorException {
        ElementStatus s = this.smeClient.getServiceStatus(svc);
        if (s.equals((Object)ElementStatus.PRESENT)) {
            ServiceRuntimeConfiguration conf = this.smeClient.getServiceRuntimeConfiguration(svc);
            this.verifyLock(conf);
            this.smeClient.undeployService(svc.getId());
            long start = System.currentTimeMillis();
            while (System.currentTimeMillis() - start < (long)WAIT_MILISECONDS) {
                ElementStatus stat = this.smeClient.getServiceStatus(svc);
                if (!ElementStatus.NOT_PRESENT.equals((Object)stat)) continue;
                LOG.info(svc + " successfully undeployed.");
                return;
            }
            throw new CommandExecutorException("Service did not undeployed in " + WAIT_MILISECONDS + " milliseconds.");
        }
    }

    @Override
    public IService findService(String svcIdent, IProject proj) throws CommunicatorException, CommandExecutorException {
        Collection<IService> svcs = this.findServices(svcIdent, proj);
        if (svcs.isEmpty()) {
            throw new CommandExecutorException("Desired service '" + svcIdent + "' was not found on the server.");
        }
        if (svcs.size() > 1) {
            throw new CommandExecutorException("There was found more than one service with the specified identification. Please, specify its ID or provide a project to search in.");
        }
        IService svc = svcs.iterator().next();
        for (IDataModel dm : this.findDataModels(svc)) {
            svc.addDataModel(dm);
        }
        for (IPerfModel pm : this.findPerfModels(svc)) {
            svc.addPerfModel(pm);
        }
        return svc;
    }

    @Override
    public Collection<IService> findServices(String svcIdent, IProject proj) throws CommunicatorException {
        ServiceListAtom atom = this.getServiceList(proj == null ? null : proj.getId());
        ArrayList<IService> svcs = new ArrayList<IService>(atom.getEntries().size());
        for (ServiceListAtom.ServiceEntry se : atom.getEntries()) {
            if (!svcIdent.equals(se.getTitle()) && !svcIdent.equals(se.getId())) continue;
            svcs.add(new Service(se.getId(), se.getTitle(), new InexistingProjectElementDataSource(), null, null, se.getRuntimeIssuesParsed(), "true".equalsIgnoreCase(se.getNonExistentRealService())));
        }
        return svcs;
    }

    @Override
    public Collection<IDataModel> findDataModels(IService svc) throws CommunicatorException {
        ElemModelListAtom a = this.smeClient.getSvcDataModelAtom(svc);
        ArrayList<IDataModel> dms = new ArrayList<IDataModel>(a.getEntries().size());
        for (ElemModelListAtom.ElemModelEntry e : a.getEntries()) {
            dms.add(new DataModel(e.getId(), e.getTitle(), new InexistingProjectElementDataSource(), null, null));
        }
        return dms;
    }

    @Override
    public Collection<IPerfModel> findPerfModels(IService svc) throws CommunicatorException {
        ElemModelListAtom a = this.smeClient.getSvcPerfModelAtom(svc);
        ArrayList<IPerfModel> dms = new ArrayList<IPerfModel>(a.getEntries().size());
        for (ElemModelListAtom.ElemModelEntry e : a.getEntries()) {
            if (e.getIsOffline().booleanValue()) {
                dms.add(new OfflinePerfModel(e.getId(), e.getTitle(), new InexistingProjectElementDataSource(), null, null));
                continue;
            }
            dms.add(new PerfModel(e.getId(), e.getTitle(), new InexistingProjectElementDataSource(), null, null));
        }
        return dms;
    }

    @Override
    public void lockService(IService svc, String clientId) throws CommunicatorException, CommandExecutorException {
        ServiceRuntimeConfiguration conf = this.smeClient.getServiceRuntimeConfiguration(svc);
        conf.setClientId(null);
        this.smeClient.setServiceRuntimeConfiguration(svc, conf);
        if (clientId != null) {
            conf.setClientId(clientId);
            this.smeClient.setServiceRuntimeConfiguration(svc, conf);
        }
    }

    @Override
    public void changeVirtualServiceLoggingConfiguration(IService svc, boolean isEnabled) throws CommunicatorException, CommandExecutorException {
        VirtualServiceLoggingConfiguration value = new VirtualServiceLoggingConfiguration(svc.getId(), isEnabled);
        this.smeClient.setVirtualServiceLoggingConfiguration(svc, value);
    }

    @Override
    public void setServiceRuntime(IService svc, ServiceRuntimeConfiguration runtConf) throws CommunicatorException, CommandExecutorException {
        this.validateServiceRuntime(runtConf);
        ServiceRuntimeConfiguration conf = this.smeClient.getServiceRuntimeConfiguration(svc);
        this.verifyLock(conf);
        if (conf.getRuntimeMode().equals((Object)ServiceRuntimeConfiguration.RuntimeMode.LEARNING) && conf.getDeploymentState().equals((Object)ServiceRuntimeConfiguration.DeploymentState.READY)) {
            this.stopLearningAnalysis(svc);
        }
        String clientId = Global.getClientId(this);
        runtConf.setServiceId(conf.getServiceId());
        runtConf.setId(conf.getId());
        runtConf.setClientId(clientId);
        conf.setClientId(clientId);
        LOG.debug("Changing the {} mode to {}", (Object)svc, (Object)runtConf);
        if (!runtConf.equals(conf)) {
            conf.setDeploymentState(ServiceRuntimeConfiguration.DeploymentState.DOWN);
            this.smeClient.setServiceRuntimeConfiguration(svc, conf);
            ServiceRuntimeConfiguration resConf = this.waitForServiceRuntimeChange(svc);
            if (!ServiceRuntimeConfiguration.DeploymentState.DOWN.equals((Object)resConf.getDeploymentState())) {
                throw new CommandExecutorException("Service should take down but it's mode is " + (Object)((Object)resConf.getDeploymentState()) + ". " + this.getDeploymentErrorInfo(resConf));
            }
            this.smeClient.setServiceRuntimeConfiguration(svc, runtConf);
            resConf = this.waitForServiceRuntimeChange(svc);
            if (!ServiceRuntimeConfiguration.DeploymentState.READY.equals((Object)resConf.getDeploymentState())) {
                this.lockService(svc, null);
                throw new CommandExecutorException("Service should get ready but it's mode is " + (Object)((Object)resConf.getDeploymentState()) + ". " + this.getDeploymentErrorInfo(resConf));
            }
            if (!this.isSimulatingFromUserPerspective(runtConf) && runtConf.getRuntimeMode() != ServiceRuntimeConfiguration.RuntimeMode.LEARNING) {
                this.lockService(svc, null);
            }
            LOG.info(svc + " runtime mode is changed to " + (Object)((Object)runtConf.getDisplayRuntimeMode()));
        } else {
            LOG.info(svc + " has already mode " + (Object)((Object)runtConf.getDisplayRuntimeMode()));
        }
    }

    @Override
    public void hotSwapServiceRuntime(IService svc, ServiceRuntimeConfiguration runtConf) throws CommunicatorException, CommandExecutorException {
        this.validateServiceRuntime(runtConf);
        ServiceRuntimeConfiguration conf = this.smeClient.getServiceRuntimeConfiguration(svc);
        this.verifyLock(conf);
        runtConf.setServiceId(conf.getServiceId());
        runtConf.setId(conf.getId());
        runtConf.setClientId(Global.getClientId(this));
        LOG.debug("Changing the {} mode to {}", (Object)svc, (Object)runtConf);
        if (!runtConf.equals(conf)) {
            this.smeClient.setServiceRuntimeConfiguration(svc, runtConf);
            ServiceRuntimeConfiguration resConf = this.waitForServiceRuntimeChange(svc);
            if (!ServiceRuntimeConfiguration.DeploymentState.READY.equals((Object)resConf.getDeploymentState())) {
                throw new CommandExecutorException("Service should get ready but it's mode is " + (Object)((Object)resConf.getDeploymentState()) + ". " + this.getDeploymentErrorInfo(resConf));
            }
            LOG.info(svc + " runtime mode is changed.");
        } else {
            LOG.info(svc + " has already the mode.");
        }
    }

    @Override
    public AgentConfigurations getAgents() throws CommunicatorException, CommandExecutorException {
        return this.smeClient.getAgentConfigurations();
    }

    @Override
    public ServiceRuntimeConfiguration getServiceRuntimeInfo(IService svc) throws CommunicatorException {
        return this.smeClient.getServiceRuntimeConfiguration(svc);
    }

    @Override
    public ServiceRuntimeReport getServiceRuntimeReport(IService svc) throws CommunicatorException {
        return this.smeClient.getServiceRuntimeReport(svc);
    }

    @Override
    public ServiceListAtom getServiceList(String projectId) throws CommunicatorException {
        return this.smeClient.getServiceList(projectId);
    }

    private boolean isSimulatingFromUserPerspective(ServiceRuntimeConfiguration conf) {
        return ServiceRuntimeConfiguration.RuntimeMode.SIMULATING == conf.getDisplayRuntimeMode();
    }

    private void validateServiceRuntime(ServiceRuntimeConfiguration conf) throws CommandExecutorException {
        switch (conf.getRuntimeMode()) {
            case STAND_BY: {
                if (conf.getDataModel() == null) break;
                throw new CommandExecutorException("Data Model can't be set in STAND_BY mode.");
            }
            case SIMULATING: {
                if (conf.getDataModel() != null) break;
                throw new CommandExecutorException("Data Model has to be set in SIMULATING mode. If you want to use only Performance Model, use the STAND_BY mode.");
            }
            case LEARNING: {
                if (conf.getDataModel() != null || conf.getPerfModel() != null) break;
                throw new CommandExecutorException("Either a Data Model or a Performance Model has to be set in the LEARNING mode.");
            }
        }
    }

    private void verifyLock(ServiceRuntimeConfiguration conf) throws CommandExecutorException {
        String clientId = Global.getClientId(this);
        if (!this.force && conf.isLockedForMe(clientId)) {
            throw new CommandExecutorException(String.format("Service [%s] is locked by '%s' but you are connecting as '%s'. If you want to proceed, use the force mode.", conf.getServiceId(), conf.getClientId(), clientId));
        }
    }

    private void stopLearningAnalysis(IService svc) throws CommunicatorException {
        ServiceAnalysis sa = this.smeClient.getServiceAnalysis(svc);
        if (sa.getState().equals((Object)ServiceAnalysis.State.IN_PROGRESS)) {
            sa.setState(ServiceAnalysis.State.FINISHING);
            this.smeClient.setServiceAnalysis(svc, sa);
            sa = this.smeClient.getServiceAnalysis(svc);
            while (sa.getState().isInProgress()) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException e) {
                    throw new CommunicatorException("Error during sleep for service change mode.");
                }
                sa = this.smeClient.getServiceAnalysis(svc);
            }
            if (!sa.getState().equals((Object)ServiceAnalysis.State.FINISHED)) {
                throw new CommunicatorException("Stop Service Analysis resulted into " + (Object)((Object)sa.getState()) + " state.");
            }
        }
    }

    private void changeServiceDeploymentState(IService svc, ServiceRuntimeConfiguration.DeploymentState deploymentState) throws CommunicatorException, CommandExecutorException {
        ServiceRuntimeConfiguration conf = this.smeClient.getServiceRuntimeConfiguration(svc);
        this.verifyLock(conf);
        if (deploymentState.equals((Object)conf.getDeploymentState())) {
            return;
        }
        conf.setDeploymentState(deploymentState);
        conf.setClientId(Global.getClientId(this));
        try {
            this.smeClient.setServiceRuntimeConfiguration(svc, conf);
        }
        catch (CommandExecutorException ex) {
            throw new IllegalStateException("This should not happen", ex);
        }
        ServiceRuntimeConfiguration resConf = this.waitForServiceRuntimeChange(svc);
        if (!deploymentState.equals((Object)resConf.getDeploymentState())) {
            throw new CommandExecutorException(String.format("Service [%s] should be %s but is %s. %s", svc.getName(), deploymentState.toString(), resConf.getDeploymentState().toString(), this.getDeploymentErrorInfo(resConf)));
        }
    }

    private String getDeploymentErrorInfo(ServiceRuntimeConfiguration resConf) {
        return "See server log file for more details. Deployment error: " + resConf.getDeploymentErrorMessage();
    }

    private ServiceRuntimeConfiguration waitForServiceRuntimeChange(IService svc) throws CommunicatorException {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < (long)WAIT_MILISECONDS) {
            ServiceRuntimeConfiguration conf = this.smeClient.getServiceRuntimeConfiguration(svc);
            if (!conf.getDeploymentState().isInProgress()) {
                return conf;
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                throw new CommunicatorException("Error during sleep for service change mode.");
            }
        }
        throw new CommunicatorException("Service did not change the runtime mode in " + WAIT_MILISECONDS + " ms");
    }

    @Override
    public boolean isForce() {
        return this.force;
    }

    @Override
    public void setForce(boolean force) {
        this.force = force;
    }

    @Override
    public IServerManagementEndpointClient getClient() {
        return this.smeClient;
    }

    static {
        try {
            WAIT_MILISECONDS = Integer.parseInt(System.getProperty(PROP_WAIT_MS, "30000"));
        }
        catch (NumberFormatException ex) {
            LOG.error("Wait time configuration error. ", (Throwable)ex);
        }
    }
}

