/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.processor.export;

import com.microfocus.sv.svconfigurator.core.impl.exception.CommandExecutorException;
import com.microfocus.sv.svconfigurator.processor.export.AbstractWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipWriter
extends AbstractWriter {
    private static final Logger LOG = LoggerFactory.getLogger(ZipWriter.class);
    public static final String FILE_EXTENSION = ".vproja";
    ZipOutputStream zipOutputStream;

    public ZipWriter(File root, String projectName) throws CommandExecutorException, IOException {
        String archiveName = ZipWriter.entityNameToFileName(projectName) + FILE_EXTENSION;
        File archiveFile = new File(root, archiveName);
        if (archiveFile.exists()) {
            archiveFile = new File(root, archiveName + "-" + UUID.randomUUID() + FILE_EXTENSION);
        }
        if (archiveFile.exists()) {
            throw new CommandExecutorException("File already exists: " + archiveFile);
        }
        LOG.info("Saving project '" + projectName + "' to '" + archiveFile + "'...");
        this.zipOutputStream = new ZipOutputStream(new FileOutputStream(archiveFile));
        byte[] bytes = projectName.getBytes(Charset.forName("utf-16LE"));
        this.zipOutputStream.setComment(Base64.getEncoder().encodeToString(bytes));
    }

    @Override
    public void writeDataImpl(byte[] data, String filePath) throws IOException {
        ZipEntry entry = new ZipEntry(filePath);
        this.zipOutputStream.putNextEntry(entry);
        this.zipOutputStream.write(data);
        this.zipOutputStream.closeEntry();
    }

    @Override
    public void close() throws IOException {
        this.zipOutputStream.finish();
        this.zipOutputStream.close();
    }
}

