/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.processor;

import com.microfocus.sv.svconfigurator.core.IPerfModel;
import com.microfocus.sv.svconfigurator.core.IService;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommandExecutorException;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommunicatorException;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.ServiceRuntimeConfiguration;
import com.microfocus.sv.svconfigurator.processor.HotSwapProcessorInput;
import com.microfocus.sv.svconfigurator.processor.IHotSwapProcessor;
import com.microfocus.sv.svconfigurator.serverclient.ICommandExecutor;
import com.microfocus.sv.svconfigurator.serverclient.ICommandExecutorFactory;
import com.microfocus.sv.svconfigurator.util.ProjectUtils;

public class HotSwapProcessor
implements IHotSwapProcessor {
    private ICommandExecutorFactory commandExecutorFactory;

    public HotSwapProcessor(ICommandExecutorFactory commandExecutorFactory) {
        this.commandExecutorFactory = commandExecutorFactory;
    }

    @Override
    public ICommandExecutorFactory getCommandExecutorFactory() {
        return this.commandExecutorFactory;
    }

    @Override
    public void process(HotSwapProcessorInput input, ICommandExecutor exec) throws CommunicatorException, CommandExecutorException {
        exec.setForce(input.isForce());
        IService svc = exec.findService(input.getService(), null);
        String perfModelId = this.getPerformanceModelId(input, svc);
        ServiceRuntimeConfiguration rc = exec.getServiceRuntimeInfo(svc);
        this.validate(svc, rc, perfModelId);
        rc.setPerfModelId(perfModelId);
        exec.hotSwapServiceRuntime(svc, rc);
    }

    private String getPerformanceModelId(HotSwapProcessorInput input, IService svc) throws CommandExecutorException {
        return input.getPerfModel() == null ? null : ProjectUtils.findProjElem(svc.getPerfModels(), input.getPerfModel(), "Performance model").getId();
    }

    private void validate(IService svc, ServiceRuntimeConfiguration rc, String pmId) throws CommandExecutorException {
        if (!ServiceRuntimeConfiguration.DeploymentState.READY.equals((Object)rc.getDeploymentState())) {
            throw new CommandExecutorException("Service is not deployed.");
        }
        if (!this.isInSimulation(rc)) {
            throw new CommandExecutorException("Service is not in Simulation.");
        }
        if (this.isPMOffline(svc, rc.getPerfModelId())) {
            throw new CommandExecutorException("Services' Actual Performance Model is Offline.");
        }
        if (this.isPMOffline(svc, pmId)) {
            throw new CommandExecutorException("Actual Services' Performance Model is Offline.");
        }
    }

    private boolean isPMOffline(IService svc, String dataModelId) {
        if (dataModelId == null) {
            return false;
        }
        for (IPerfModel pm : svc.getPerfModels()) {
            if (!pm.getId().equals(dataModelId)) continue;
            return pm.isOffline();
        }
        return true;
    }

    private boolean isInSimulation(ServiceRuntimeConfiguration rc) {
        return ServiceRuntimeConfiguration.RuntimeMode.SIMULATING == rc.getDisplayRuntimeMode();
    }
}

