/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.core.server;

import com.microfocus.sv.svconfigurator.core.impl.Server;
import com.microfocus.sv.svconfigurator.core.impl.exception.AbstractSVCException;
import com.microfocus.sv.svconfigurator.core.impl.exception.SVCParseException;
import com.microfocus.sv.svconfigurator.core.impl.processor.Credentials;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerParser {
    private static Logger LOG = LoggerFactory.getLogger(ServerParser.class);
    public static final Charset FILE_ENCODING = Charset.forName("UTF-8");
    public static final String URL_SUFFIX = ".url";
    public static final String USERNAME_SUFFIX = ".username";
    public static final String PASSWORD_SUFFIX = ".password";
    public static final String TRUST_EVERYONE_SUFFIX = ".trustEveryone";

    public static List<Server> parseServers(File inputFile, String selectedServerId) throws AbstractSVCException {
        List<Server> list;
        if (inputFile == null) {
            throw new SVCParseException("Input file cannot be empty");
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(inputFile);
            list = ServerParser.parseServers(fis, selectedServerId);
        }
        catch (IOException e) {
            try {
                throw new SVCParseException("Failed to parse input file", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)fis);
        return list;
    }

    public static List<Server> parseServers(InputStream input, String selectedServerId) throws AbstractSVCException {
        if (input == null) {
            throw new SVCParseException("Input cannot be empty");
        }
        Properties props = new Properties();
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader(input, FILE_ENCODING);
            props.load(isr);
        }
        catch (IOException e) {
            try {
                throw new SVCParseException("Failed to parse input file", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(isr);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)isr);
        ArrayList<Server> servers = new ArrayList<Server>();
        Enumeration<Object> keys = props.keys();
        HashSet<String> serverIds = new HashSet<String>();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            serverIds.add(ServerParser.getServerId(key));
        }
        for (String serverId : serverIds) {
            if (selectedServerId != null && !selectedServerId.equals(serverId)) {
                LOG.debug("Skipping unselected server ID '" + serverId + "'...");
                continue;
            }
            LOG.debug("Loading server ID '" + serverId + "'...");
            String urlValue = props.getProperty(serverId + URL_SUFFIX);
            if (urlValue == null) {
                throw new SVCParseException("No URL key '" + serverId + URL_SUFFIX + "' found for server ID '" + serverId + "'.");
            }
            String usernameValue = props.getProperty(serverId + USERNAME_SUFFIX);
            String passwordValue = props.getProperty(serverId + PASSWORD_SUFFIX);
            boolean trustEveryone = "true".equalsIgnoreCase(props.getProperty(serverId + TRUST_EVERYONE_SUFFIX));
            try {
                Server srv;
                if (usernameValue == null && passwordValue == null) {
                    srv = new Server(serverId, new URL(urlValue), trustEveryone, null);
                } else if (usernameValue != null && passwordValue != null) {
                    srv = new Server(serverId, new URL(urlValue), trustEveryone, new Credentials(usernameValue, passwordValue));
                } else {
                    throw new SVCParseException("Server ID '" + serverId + "' is missing username or password.");
                }
                servers.add(srv);
            }
            catch (MalformedURLException e) {
                throw new SVCParseException("Failed to parse URL '" + urlValue + "' for server ID '" + serverId + "'.");
            }
        }
        return servers;
    }

    public static String getServerId(String key) throws SVCParseException {
        int idx = key.indexOf(46);
        if (idx >= 0) {
            return key.substring(0, idx);
        }
        throw new SVCParseException("Failed to get server ID for the key '" + key + "'");
    }
}

