/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.core.impl.visitor;

import com.microfocus.sv.svconfigurator.core.IContentFile;
import com.microfocus.sv.svconfigurator.core.IDataModel;
import com.microfocus.sv.svconfigurator.core.IDataSet;
import com.microfocus.sv.svconfigurator.core.ILoggedServiceCallList;
import com.microfocus.sv.svconfigurator.core.IManifest;
import com.microfocus.sv.svconfigurator.core.IPerfModel;
import com.microfocus.sv.svconfigurator.core.IProject;
import com.microfocus.sv.svconfigurator.core.IProjectElementVisitor;
import com.microfocus.sv.svconfigurator.core.IService;
import com.microfocus.sv.svconfigurator.core.IServiceDescription;
import com.microfocus.sv.svconfigurator.core.ITopology;

public class PrintStructureVisitor
implements IProjectElementVisitor {
    private StringBuilder sb = new StringBuilder();

    @Override
    public void visit(IProject p) {
        this.sb.append("project: " + p.getId());
        for (IService svc : p.getServices()) {
            svc.accept(this);
        }
    }

    @Override
    public void visit(IService s) {
        this.indent(1);
        this.sb.append("service: " + s.getId());
        for (IDataModel dm : s.getDataModels()) {
            dm.accept(this);
        }
        for (IPerfModel pm : s.getPerfModels()) {
            pm.accept(this);
        }
        for (IServiceDescription sd : s.getDescriptions()) {
            sd.accept(this);
        }
        for (IContentFile cf : s.getContentFiles()) {
            cf.accept(this);
        }
    }

    @Override
    public void visit(IDataModel dm) {
        this.indent(2);
        this.sb.append("data model: " + dm.getId());
        for (IDataSet ds : dm.getDataSets()) {
            ds.accept(this);
        }
    }

    @Override
    public void visit(IPerfModel pm) {
        this.indent(2);
        this.sb.append("performance model: " + pm.getId());
    }

    @Override
    public void visit(IServiceDescription sd) {
        this.indent(2);
        this.sb.append("service description: " + sd.getId());
    }

    @Override
    public void visit(IContentFile cf) {
        this.indent(2);
        this.sb.append("content file: " + cf.getId());
    }

    @Override
    public void visit(IDataSet ds) {
        this.indent(3);
        this.sb.append("data set: " + ds.getId());
    }

    @Override
    public void visit(IManifest m) {
    }

    @Override
    public void visit(ITopology t) {
    }

    @Override
    public void visit(ILoggedServiceCallList loggedServiceCallList) {
    }

    private void indent(int level) {
        this.sb.append("\n");
        for (int i = 0; i < level; ++i) {
            this.sb.append("\t");
        }
    }

    public String getStructure() {
        return this.sb.toString();
    }
}

